//---------------------------------------------------------------------------
// Copyright (c) 1995-1999 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

//---------------------------------------------------------------------------

#ifndef REALTYPE_HH
#define REALTYPE_HH

class IntegerType;

#include "TypeInfo.hh"
#include "ScalarType.hh"

class SavantstringType;
class RealType;
extern realInfo SavantrealType_info;

class RealType: public ScalarType {
public:
  RealType();
  RealType(ObjectBase::ObjectType);
  RealType(ObjectBase::ObjectType, const UniversalReal&);
  RealType(ObjectBase::ObjectType, const RealType&);
  RealType(bool, const RealType&);
  RealType(const RealType&);

  //New constructors added for folding types
  RealType(ObjectBase::ObjectType, const realInfo&);
  RealType(ObjectBase::ObjectType, const TypeInfo &);
  RealType(ObjectBase::ObjectType, const UniversalReal&, const realInfo&);
  RealType(ObjectBase::ObjectType, const RealType&, const realInfo&);
  RealType(const RealType&, const realInfo&);
  RealType(bool, const RealType&, const realInfo&);

  virtual ~RealType() {}

  RealType& operator = (const RealType&);

  Type get_kind() const;
  virtual const VHDLData& leftValue();

  //These are the attributes of Real types

  static RealType          LEFT      (const realInfo &);
  static RealType          RIGHT     (const realInfo &);
  static RealType          HIGH      (const realInfo &);
  static RealType          LOW       (const realInfo &);
  static EnumerationType   ASCENDING (const realInfo &);
  static SavantstringType  IMAGE     (const RealType &);
  static RealType          VALUE     (const SavantstringType&,
				      const realInfo& = SavantrealType_info);
  static RealType          POS       (const RealType&,
				      const realInfo& = SavantrealType_info);
  static RealType          VAL       (const RealType&,
				      const realInfo& = SavantrealType_info);

  TypeInfo& getTypeInfo() const;
  
public:
  realInfo range;
};

RealType savantPlus(const RealType&, const RealType&);
RealType savantMinus(const RealType&, const RealType&);
RealType savantUnaryPlus(const RealType&);
RealType savantUnaryMinus(const RealType&);
RealType savantMultiply(const RealType&, const RealType&);
RealType savantDivide(const RealType&, const RealType&);
RealType savantPow(const RealType&, const IntegerType&);
RealType savantAbs(const RealType&);

#endif
