//---------------------------------------------------------------------------
// Copyright (c) 1995-1999 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

//---------------------------------------------------------------------------

#ifndef VHDLKERNELBASE_HH
#define VHDLKERNELBASE_HH

// This class has been created for savant interface alone.  It does not
// containany data.  It has some virtual methods that are used by savant.
// Why is this class necessary?
//   Since VHDLKernel is templatized, and so is TimeWarp, declaring a
//   pointer to either of this is not possible without knowing the
//   template parameter (which is not possible).  The only non templatized
//   class in this hierarchy is BasicTimeWarp, but a virtual method called
//   "writeline" is totally irrelevant there.  That is why this class has
//   been created.
// This will be multiply inherited along with SimulationObj, which is
// templatized.
#include "standard.hh"
#include "CallStack.hh"

class Wait;
class SavantlineType;
class FileType;
class BasicState;
class RecordType;

class VHDLKernelBase {
public:
  VHDLKernelBase() {};
  virtual ~VHDLKernelBase() {};

  virtual VTime getTimeNow() const = 0;
  virtual int myId() const = 0;
  virtual CallStack* getCallStack() const = 0;
  virtual BasicState* getState() const = 0;

  // Wait statements
  virtual bool resumeWait(int, const EnumerationType& = SAVANT_BOOLEAN_TRUE) = 0;
  virtual void executeWait(int, const PhysicalType& = SAVANT_INFINITY_TIME) = 0;
  virtual void setProcedureWait(const Wait*) = 0;
  virtual int getWaitLabel() const = 0;

  // Signal assignment.
  virtual void assignSignal(VHDLType& dest, int sigsrc, const VHDLType& src,
			    const PhysicalType& delay,
			    const PhysicalType& rejTime = SAVANT_ZERO_TIME, 
			    const ArrayInfo& dinfo = defaultInfo,
			    const ArrayInfo& sinfo = defaultInfo) = 0;
  virtual void assignSignal(SignalBase&, int, const VHDLData&, const VTime&, 
			    const VTime& = ZERO, 
			    const ArrayInfo& = defaultInfo, 
			    const ArrayInfo& = defaultInfo)= 0;
  virtual void assignSignal(SignalBase&, int, const char, const VTime&, 
		    const VTime& = ZERO, const ArrayInfo& = defaultInfo, 
		    const ArrayInfo& = defaultInfo) = 0;

  virtual void assignNullTransaction(VHDLType& dest, int sigsrc,
		     const PhysicalType& delay,
		     const PhysicalType& rejTime = SAVANT_ZERO_TIME, 
		     const ArrayInfo& dinfo = defaultInfo,
		     const ArrayInfo& sinfo = defaultInfo) = 0;

  virtual void assignNullTransaction(SignalBase&, int, const VTime&, 
		    const VTime& = ZERO, const ArrayInfo& = nullInfo, 
		    const ArrayInfo& = nullInfo) = 0;

  // lib STANDARD and TEXTIO functions and procedures
  virtual EnumerationType savantendfile_boolean(VHDLKernelBase*, int) = 0;
  virtual EnumerationType savantendfile_boolean(VHDLKernelBase*, FileType&) = 0;
  virtual EnumerationType savantendfile(VHDLKernelBase*, int) = 0;
  virtual EnumerationType savantendfile(VHDLKernelBase*, FileType&) = 0;

  virtual int  savantreadline(VHDLKernelBase*, int, 
			      AccessVariable<char*>&) = 0;
  virtual int savantreadline(VHDLKernelBase*, int, SavantlineType &) = 0;
  virtual int savantreadline(VHDLKernelBase*, int, SavantlineType&, IntegerType&) = 0;
  virtual int savantwriteline(VHDLKernelBase*, int, 
			      AccessVariable<char*>&) = 0;
  virtual int savantwriteline(VHDLKernelBase*, int, SavantlineType &)=0;
  virtual int savantwriteline(VHDLKernelBase*, FileType&, SavantlineType&) = 0;
  virtual int savantreadline(VHDLKernelBase*, const FileType&, SavantlineType&) = 0;
  // Signal Attributes.
  virtual EnumerationType locateQuietAttribute(const SignalBase *, 
					  const VTime = ZERO) = 0;
  virtual EnumerationType locateQuietAttribute(const VHDLType* sig, 
						  const VTime = ZERO) = 0;
  virtual EnumerationType locateQuietAttribute(const ScalarType* sig, 
						  const VTime = ZERO) = 0;
  virtual EnumerationType locateQuietAttribute(const RecordType* sig, 
						  const VTime = ZERO) = 0;
  virtual EnumerationType locateQuietAttribute(const VectorBase* sig, 
						  const VTime = ZERO) = 0;

  virtual EnumerationType locateEventAttribute(const VHDLType* sig) = 0;
  virtual EnumerationType locateEventAttribute(SignalBase *) = 0;
  virtual EnumerationType locateEventAttribute(const ScalarType* sig) = 0;
  virtual EnumerationType locateEventAttribute(const RecordType* sig) = 0;
  virtual EnumerationType locateEventAttribute(const VectorBase* sig) = 0;

  virtual EnumerationType locateActiveAttribute(const VHDLType* sig) = 0;
  virtual EnumerationType locateActiveAttribute(const SignalBase *) = 0;
  virtual EnumerationType locateActiveAttribute(const ScalarType* sig) = 0;
  virtual EnumerationType locateActiveAttribute(const RecordType* sig) = 0;
  virtual EnumerationType locateActiveAttribute(const VectorBase* sig) = 0;

  virtual EnumerationType locateStableAttribute(const SignalBase *, 
					  const VTime = ZERO) = 0;
  virtual EnumerationType locateStableAttribute(const VHDLType* sig,  
						   const VTime = ZERO) = 0;
  virtual EnumerationType locateStableAttribute(const ScalarType* sig,const 
						   VTime = ZERO) = 0;
  virtual EnumerationType locateStableAttribute(const RecordType* sig,const 
						   VTime = ZERO) = 0;
  virtual EnumerationType locateStableAttribute(const VectorBase* sig,const 
						   VTime = ZERO) = 0;

  virtual EnumerationType* locateTransactionAttribute(const VHDLType* sig) = 0;
  virtual EnumerationType* locateTransactionAttribute(const SignalBase *) = 0;
  virtual EnumerationType* locateTransactionAttribute(const ScalarType* sig) = 0;
  virtual EnumerationType* locateTransactionAttribute(const RecordType* sig) = 0;
  virtual EnumerationType* locateTransactionAttribute(const VectorBase* sig) = 0;

  virtual PhysicalType locateLastActiveAttribute(const VHDLType* sig) = 0;
  virtual PhysicalType locateLastActiveAttribute(const SignalBase *) = 0;
  virtual PhysicalType locateLastActiveAttribute(const ScalarType* sig) = 0;
  virtual PhysicalType locateLastActiveAttribute(const RecordType* sig) = 0;
  virtual PhysicalType locateLastActiveAttribute(const VectorBase* sig) = 0;

  virtual PhysicalType locateLastEventAttribute(const VHDLType* sig) = 0;
  virtual PhysicalType locateLastEventAttribute(const SignalBase *) = 0;
  virtual PhysicalType locateLastEventAttribute(const ScalarType* sig) = 0;
  virtual PhysicalType locateLastEventAttribute(const RecordType* sig) = 0;
  virtual PhysicalType locateLastEventAttribute(const VectorBase* sig) = 0;

  virtual VHDLType* locateLastValueAttribute(const VHDLType* sig) = 0;
  virtual VHDLType* locateLastValueAttribute(const SignalBase *) = 0;
  virtual VHDLType* locateLastValueAttribute(const ScalarType* sig) = 0;
  virtual VHDLType* locateLastValueAttribute(const RecordType* sig) = 0;
  virtual VHDLType* locateLastValueAttribute(const VectorBase* sig) = 0;

  virtual int openFile(const char *, const _savant_file_open_kind &, ios::open_mode = ios::out) = 0;
  virtual void closeFile(const _savant_file_open_kind &, int) = 0;

  virtual void updateSignal(SignalBase *, bool = false) = 0; 
  virtual void updateSignal(VHDLType *) = 0;
};

#endif
