/*
 *
 *   Copyright (C) 2005-2010 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */


#ifndef UG_DOWNLOAD_DIALOG_H
#define UG_DOWNLOAD_DIALOG_H

#include <gtk/gtk.h>
#include <ug_download_form.h>
#include <ug_batch_form.h>
#include <ug_selector.h>
#include <ug_category.h>

#ifdef __cplusplus
extern "C" {
#endif


typedef struct	UgDownloadDialog_		UgDownloadDialog;

struct UgDownloadDialog_
{
	GtkDialog*		self;

	GtkBox*				hbox;
	GtkTreeView*		category_view;

	GtkWidget*			first_page;		// first page (widget) in right side of hbox
	GtkWidget*			current_page;	// current page (widget) in right side of hbox
	gboolean			response_ok;

	UgDownloadForm	download;
	UgProxyForm		proxy;
	UgBatchForm		batch;
	UgSelector			selector;

	// for user
	UgDataset*			dataset;
	gpointer			user_data;
};

UgDownloadDialog*	ug_download_dialog_new (const gchar* title, GtkWindow* parent);
UgDownloadDialog*	ug_download_dialog_new_selector (const gchar* title, GtkWindow* parent);
UgDownloadDialog*	ug_download_dialog_new_batch (GtkWindow* parent);
void				ug_download_dialog_destroy (UgDownloadDialog* dialog);
gboolean			ug_download_dialog_response (UgDownloadDialog* dialog, gint response_id);

void	ug_download_dialog_get (UgDownloadDialog* dialog, UgDataset* dataset);	// replace
void	ug_download_dialog_set (UgDownloadDialog* dialog, UgDataset* dataset);	// change widget value
void	ug_download_dialog_set_category_list (UgDownloadDialog* dialog, GtkListStore* category_list);
void	ug_download_dialog_select_category (UgDownloadDialog* dialog, UgCategory* category);

UgCategory*	ug_download_dialog_get_category (UgDownloadDialog* dialog);	// selected category
UgDataset*	ug_download_dialog_get_download_list (UgDownloadDialog* dialog);	// create new list


#ifdef __cplusplus
}
#endif

#endif  // End of UG_DOWNLOAD_DIALOG_H

