/*
 *
 *   Copyright (C) 2005-2010 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */

#ifndef __UGET_H
#define __UGET_H

#include <gtk/gtk.h>
#include <ug_category.h>
#include <ug_ipc.h>
#include <ug_option.h>

#ifdef __cplusplus
extern "C" {
#endif


#define UGET_DATA_FOLDER		"Uget"
#define UGET_DATA_FILE			"data.xml"
#define UGET_ICON_NAME			"uget-icon"

	// compile with GTK+ 2.14
#if (GTK_MAJOR_VERSION==2 && GTK_MINOR_VERSION < 16)
#define gtk_status_icon_set_tooltip_text	gtk_status_icon_set_tooltip
#endif

typedef struct Uget_					Uget;
typedef struct UgetVisibleSetting_		UgetVisibleSetting;

// UgMarkup input  : ug_data_in_markup()
// UgMarkup output : ug_data_to_markup()
struct UgetVisibleSetting_
{
	UgDataClass*	data_class;		// for UgMarkup input/output

	gboolean	toolbar;
	gboolean	statusbar;
	gboolean	total_list;
	gboolean	category_tree;
};

struct Uget_
{
	UgDataClass*	data_class;		// for UgMarkup input/output

	// these categories place in total_list
	UgCategory*		queuing;
	UgCategory*		completed;
	UgCategory*		recycled;

	// used by uget_switch_category()
	UgCategory*		current;					// current displayed category
	gulong			download_changed_signal;	// "changed" in GtkTreeSelection
	gulong			download_button_signal;		// "button-press-event" in GtkTreeView
	gulong			download_key_signal;		// "key-press-event" in GtkTreeView

	GtkListStore*	total_list;
	GtkTreeView*	total_list_view;
	gulong			total_list_signal;		// GtkTreeSelection "changed" signal
	GtkWidget*		total_list_label;

	UgCategory*		category_default;		// default for new category
	GtkListStore*	category_list;
	GtkTreeStore*	category_tree;
	GtkTreeView*	category_tree_view;
	GtkWidget*		category_tree_scroll;	// (GtkScrolledWindow) container widget for category_tree_view
	gulong			category_tree_signal;	// GtkTreeSelection "changed" signal
	GtkWidget*		category_tree_label;
	GtkWidget*		label_no_selected;		// GtkLabel "No category selected."

	GList*			folder_list;
	UgetVisibleSetting	visible;		// visible widget

	// dialog. To make sure below dialogs don't show again at the same time.
	GtkWidget*		dialog_clipboard_no_url;
	GtkWidget*		dialog_close_confirmation;
	GtkWidget*		dialog_settings;

	// clipboard
	GtkClipboard*	clipboard;
	gchar*			clipboard_text;
	GRegex*			clipboard_regex;
	gchar*			clipboard_pattern;
	gboolean		clipboard_processing;
	gboolean		clipboard_monitor;

	// Launch default application for downloaded file
	gboolean		launch_app;
	gchar*			launch_app_types;
	GRegex*			launch_app_regex;

	// auto save
	gboolean		auto_save;
	gint			auto_save_interval;

	// IPC & command option
	UgIpc*			ipc;
	GOptionContext*	option_context;
	GOptionGroup*	option_group;

	// accelerators (initialize in uget-gui.c)
	GtkAccelGroup*	accelgroup;

	// icon in system tray (initialize in uget-gui.c)
	GtkStatusIcon*	status_icon;
	GtkMenu*		status_icon_menu;	// popup menu

	// Main Window (initialize in uget-gui.c)
	GtkWindow*		window;
	gint			window_x;		// save/load window position
	gint			window_y;
	gint			window_width;
	gint			window_height;
	gboolean		window_maximized;
	gboolean		window_close_confirmation;
	gint			window_close_setting;
	// window_close_setting == 0, Let user decide.
	// window_close_setting == 1, Minimize to tray.
	// window_close_setting == 2, Exit Uget.
	// window_close_confirmation == FALSE, Remember this action.
	// window_close_confirmation == TRUE,  Always confirm.

	gboolean		start_in_tray;

	// layout
	GtkBox*			left_vbox;	// left  side (total list and category tree)
	GtkPaned*		vpaned;		// right side (download list and summary)
	GtkPaned*		hpaned;		// separate left side and right side

	// summary
	GtkListStore*	summary_store;
	GtkTreeView*	summary_view;
	GtkWidget*		summary_scroll;	// (GtkScrolledWindow) container widget for summary_view
	GtkMenu*		summary_menu;	// popup menu

	// toolbar , menubar , statusbar
	GtkStatusbar*	statusbar;

	// ------------------------------------------
	// Toolbar --- start ---
	struct Toolbar
	{
		GtkWidget*	self;	// GtkToolbar

		GtkToolItem*	create;
		GtkToolItem*	save;
		GtkToolItem*	runnable;
		GtkToolItem*	pause;
		GtkToolItem*	properties;
		GtkToolItem*	move_up;
		GtkToolItem*	move_down;
		GtkToolItem*	move_top;
		GtkToolItem*	move_bottom;
	} toolbar;
	// Toolbar --- end ---
	// ------------------------------------------

	// ------------------------------------------
	// MenuBar --- start ---
	struct MenuBar
	{
		GtkWidget*	self;	// GtkMenuBar

		// GtkWidget*	shell;		// GtkMenuShell*
		// GtkWidget*	menu;		// GtkMenu*
		// GtkWidget*	other;		// GtkMenuItem*
		struct FileMenu
		{
			// file.create
			struct {
				GtkWidget*	download;
				GtkWidget*	category;
				GtkWidget*	batch;
				GtkWidget*	from_clipboard;
			} create;
			// file.save
			GtkWidget*	save;
			// file.import & export
			GtkWidget*	import_html;
			GtkWidget*	import_text;
			GtkWidget*	export_text;

			GtkWidget*	quit;
		} file;

		struct EditMenu
		{
			GtkWidget*	clipboard_monitor;
			GtkWidget*	clipboard_option;
			GtkWidget*	settings;
		} edit;

		struct ViewMenu
		{
			GtkWidget*	toolbar;
			GtkWidget*	statusbar;
			GtkWidget*	total_list;
			GtkWidget*	category_tree;

			GtkWidget*	summary;
			struct {
				GtkWidget*	name;
				GtkWidget*	folder;
				GtkWidget*	category;
//				GtkWidget*	elapsed;
				GtkWidget*	url;
				GtkWidget*	message;
			}	summary_items;

			GtkWidget*	rules_hint;	// download rows
			struct {
				GtkWidget*	self;	// GtkMenuItem

				GtkWidget*	completed;
				GtkWidget*	total;
				GtkWidget*	percent;
				GtkWidget*	elapsed;	// consuming time
				GtkWidget*	left;		// remaining time
				GtkWidget*	speed;
				GtkWidget*	retry;
				GtkWidget*	category;
				GtkWidget*	url;
			}	columns;			// download columns
		} view;

		struct CategoryMenu
		{
//			GtkWidget*	self;		// GtkMenuItem
			GtkWidget*	menu;		// GtkMenu

			GtkWidget*	create;
			GtkWidget*	delete;
			GtkWidget*	properties;
			GtkWidget*	default_for_new;
		} category;

		struct DownloadMenu
		{
//			GtkWidget*	self;		// GtkMenuItem
			GtkWidget*	menu;		// GtkMenu

//			GtkWidget*	create;
			GtkWidget*	delete;
			GtkWidget*	delete_file;	// delete file and data.
			GtkWidget*	open;
			GtkWidget*	open_folder;	// open containing folder
			GtkWidget*	runnable;
			GtkWidget*	pause;

			struct {
				GtkWidget*		self;		// GtkMenuItem
				GtkWidget*		menu;		// GtkMenu

				// This array used for mapping menu item and it's category
				// index 0, 2, 4, 6...	GtkMenuItem*
				// index 1, 3, 5, 7...	UgCategory*
				GPtrArray*		array;
			}	move_to;

			GtkWidget*	move_up;
			GtkWidget*	move_down;
			GtkWidget*	move_top;
			GtkWidget*	move_bottom;
			GtkWidget*	properties;
		} download;

		struct HelpMenu
		{
			GtkWidget*	about_uget;
		} help;
	} menubar;
	// MenuBar --- end ---
	// ------------------------------------------
};

Uget*	uget_new (UgIpc* ipc);
void	uget_run (Uget*  app);
// category
void	uget_switch_category (Uget* app, UgCategory* category);
void	uget_append_category (Uget* app, UgCategory* category);
// visible
void	uget_apply_visible (Uget* app);
// Update menu.view
void	uget_update_menu_view (Uget* app);
// Update menu.download.move_to
void	uget_update_menu_move_to (Uget* app, gboolean reset_item);
void	uget_update_summary (Uget* app);
void	uget_update_statusbar (Uget* app);
// Update sensitive state in menu/toolbar items if category/download selection changed.
void	uget_update_category_sensitive (Uget* app);
void	uget_update_download_sensitive (Uget* app);
// clipboard and import
GList*	uget_clipboard_get_url (Uget* app, gint n_url_limit);
GList*	uget_regex_get_url (Uget* app, const gchar* text, gint text_len);
// call uget_save() and quit
void	uget_quit (Uget* app);
// save/load setting
gboolean	uget_load (Uget* app);
void		uget_save (Uget* app);
// option
gboolean	uget_parse_option (Uget* app, int argc, char** argv);

// Notification (uget-notify.c)
void	uget_notification_init (void);
void	uget_notification_finalize (void);
void	uget_notify_download_completed (Uget* app);

// ----------------------------------------------
// signal callback
void	uget_on_category_selection_changed (GtkTreeSelection* selection, Uget* app);
void	uget_on_queue_selection_changed    (GtkTreeSelection* selection, Uget* app);
// event
gboolean	uget_on_right_button_press (GtkTreeView* treeview, GdkEventButton* event, Uget* app);
gboolean	uget_on_window_key_press_event (GtkWidget *widget, GdkEventKey *event, Uget* app);
gboolean	uget_on_download_key_press_event  (GtkWidget *widget, GdkEventKey *event, Uget* app);
// window close confirmation, return TRUE for signal "delete-event".
gboolean	uget_on_window_close (Uget* app);
// timer callback
gboolean	uget_on_timer (Uget* app);
// status icon in system tray
void	uget_on_status_icon_activate (GtkStatusIcon *status_icon, Uget* app);
void	uget_on_status_icon_popup_menu (GtkStatusIcon *status_icon, guint button, guint activate_time, Uget* app);
// category
void	uget_on_create_category (GtkWidget* widget, Uget* app);
void	uget_on_delete_category (GtkWidget* widget, Uget* app);
void	uget_on_config_category (GtkWidget* widget, Uget* app);
void	uget_on_config_category_default (GtkWidget* widget, Uget* app);
// download
void	uget_on_create_batch (GtkWidget* widget, Uget* app);
void	uget_on_create_from_clipboard (GtkWidget* widget, Uget* app);
void	uget_on_create_download (Uget* app);
void	uget_on_create_download_from_ipc (Uget* app, UgDataset* dataset, UgCategory* category);
void	uget_on_delete_download (GtkWidget* widget, Uget* app);
void	uget_on_delete_download_file (GtkWidget* widget, Uget* app);
void	uget_on_config_download (GtkWidget* widget, Uget* app);
void	uget_on_open_downloaded_file (GtkWidget* widget, Uget* app);
void	uget_on_open_downloaded_folder (GtkWidget* widget, Uget* app);
void	uget_on_set_download_runnable (GtkWidget* widget, Uget* app);
void	uget_on_set_download_to_pause (GtkWidget* widget, Uget* app);
void	uget_on_move_download (GtkWidget* widget, Uget* app);
void	uget_on_move_download_up (GtkWidget* widget, Uget* app);
void	uget_on_move_download_down (GtkWidget* widget, Uget* app);
void	uget_on_move_download_to_top (GtkWidget* widget, Uget* app);
void	uget_on_move_download_to_bottom (GtkWidget* widget, Uget* app);
// import/export
void	uget_import_list_file (Uget* app, gchar* filename_utf8, gboolean quiet);
void	uget_on_import_html_file (GtkWidget* widget, Uget* app);	// uget-import.c
void	uget_on_import_text_file (GtkWidget* widget, Uget* app);	// uget-import.c
void	uget_on_export_text_file (GtkWidget* widget, Uget* app);	// uget-export.c
// edit menu
void	uget_on_clipboard_monitor (GtkWidget* widget, Uget* app);
void	uget_on_clipboard_option  (GtkWidget* widget, Uget* app);
void	uget_on_config_settings   (GtkWidget* widget, Uget* app);
// summary
void	uget_on_summary_copy_selected (Uget* app);
void	uget_on_summary_copy_all      (GtkWidget* widget, Uget* app);
// Change visible status of toolbar/statusbar/category.
void	uget_on_change_visible_view (GtkWidget* widget, Uget* app);
// Change visible status of download columns.
void	uget_on_change_visible_column (GtkWidget* widget, Uget* app);
// Change visible status of summary items.
void	uget_on_change_visible_summary (GtkWidget* widget, Uget* app);

void	uget_on_about (GtkWidget* widget, Uget* app);


#ifdef __cplusplus
}
#endif

#endif  // End of __UGET_H

