function [out1, out2, out3, out4, out5] = umfpack (in1, in2, in3, in4, in5)
%UMFPACK
%
%   UMFPACK is a Matlab mexFunction for solving sparse linear systems for
%   Matlab V6.0 or later.
%
%   UMFPACK:                            |  Matlab approximate equivalent:
%   ---------------------------------------------------------------------
%   x = umfpack (A, '\', b) ;           |  x = A \ b
%                                       |
%   x = umfpack (b, '/', A) ;           |  x = b / A
%                                       |
%   [L,U,P,Q] = umfpack (A) ;           |  Q = colamd (A) ;
%                                       |  [L,U,P] = lu (A (:,Q)) ;
%                                       |
%   [Q,F,C] = umfpack (A, 'symbolic') ; |  Q = colamd (A) ;
%                                       |  [count,h,parent,post] = ...
%                                       |  symbfact (A (:,Q), 'col') ;
%
%   A must be square, sparse, non-singular, and cannot be complex.  b must be a
%   dense real vector.
%
%   UMFPACK Version 3.2, Jan. 1, 2002.  Copyright (c) 2002 by Timothy A.
%   Davis, University of Florida, davis@cise.ufl.edu.  All Rights Reserved.
%   Type "help umfpack_details" for License.
%
%   See also:
%	umfpack_make	  to compile umfpack for use in Matlab
%	umfpack_details	  type "help umfpack_details" for more information
%	umfpack_report	  prints optional control settings and statistics
%	umfpack_demo	  a demo
%	umfpack_simple	  a simple demo

% UMFPACK License:
%
%   Your use or distribution of UMFPACK or any derivative code implies that
%   you agree to this License.
%
%   THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY
%   EXPRESSED OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
%
%   Permission is hereby granted to use or copy this program, provided
%   that the Copyright, this License, and the Availability of the original
%   version is retained on all copies.  User documentation of any code that
%   uses this code or any derivative code must cite the Copyright, this
%   License, the Availability note, and "Used by permission."  If this
%   code or any derivative code is accessible from within MATLAB, then
%   typing "help umfpack" must cite the Copyright, and "type umfpack"
%   must also cite this License and the Availability note.  Permission to
%   modify the code and to distribute modified code is granted, provided
%   the Copyright, this License, and the Availability note are retained,
%   and a notice that the code was modified is included.  This software
%   was developed with support from the National Science Foundation, and
%   is provided to you free of charge.
%
% Availability:
%
%   http://www.cise.ufl.edu/research/sparse.

error ('umfpack mexFunction not found!  Use umfpack_make to compile umfpack.') ;

