/* ========================================================================== */
/* === UMFPACK_get_symbolic ================================================= */
/* ========================================================================== */

/* -------------------------------------------------------------------------- */
/* UMFPACK Version 3.2 (Jan. 1, 2002), Copyright (c) 2002 by Timothy A.       */
/* Davis, University of Florida, davis@cise.ufl.edu.  All Rights Reserved.    */
/* See README, umfpack.h, or type "umfpack_details" in Matlab for License.    */
/* -------------------------------------------------------------------------- */

/*
    User-callable.  Gets the symbolic information held in the Symbolic object.
    See umfpack_get_symbolic.h for a more detailed description.
*/

#include "umf_internal.h"
#include "umf_valid_symbolic.h"

/* ========================================================================== */

GLOBAL Int UMFPACK_get_symbolic
(
    Int *p_n,
    Int *p_nz,
    Int *p_nfr,
    Int *p_nchains,
    Int *p_nsparse_col,	/* all columns treated as sparse, so this is n */
    Int Qtree [ ],
    Int Front_npivots [ ],
    Int Front_parent [ ],
    Int Chain_start [ ],
    Int Chain_maxrows [ ],
    Int Chain_maxcols [ ],
    void *SymbolicHandle
)
{
    SymbolicType *Symbolic ;
    Int k, n, nfr, nchains, *p ;

    /* ---------------------------------------------------------------------- */
    /* check inputs */
    /* ---------------------------------------------------------------------- */

    Symbolic = (SymbolicType *) SymbolicHandle ;
    if (!UMF_valid_symbolic (Symbolic))
    {
	return (UMFPACK_ERROR_invalid_Symbolic_object) ;
    }

    /* ---------------------------------------------------------------------- */
    /* get contents of Symbolic */
    /* ---------------------------------------------------------------------- */

    n = Symbolic->n ;
    nfr = Symbolic->nfr ;
    nchains = Symbolic->nchains ;

    if (p_n)
    {
	*p_n = n ;
    }

    if (p_nz)
    {
	*p_nz = Symbolic->nz ;
    }

    if (p_nfr)
    {
	*p_nfr = nfr ;
    }

    if (p_nchains)
    {
	*p_nchains = nchains ;
    }

    if (p_nsparse_col)
    {
	*p_nsparse_col = n ;
    }

    if (Qtree)
    {
	p = Symbolic->Cperm_init ;
	for (k = 0 ; k < n ; k++)
	{
	    Qtree [k] = p [k] ;
	}
    }

    if (Front_npivots)
    {
	p = Symbolic->Front_npivots ;
	for (k = 0 ; k < nfr ; k++)
	{
	    Front_npivots [k] = p [k] ;
	}
    }

    if (Front_parent)
    {
	p = Symbolic->Front_parent ;
	for (k = 0 ; k < nfr ; k++)
	{
	    Front_parent [k] = p [k] ;
	}
    }

    if (Chain_start)
    {
	p = Symbolic->Chain_start ;
	for (k = 0 ; k <= nchains ; k++)
	{
	    Chain_start [k] = p [k] ;
	}
    }

    if (Chain_maxrows)
    {
	p = Symbolic->Chain_maxrows ;
	for (k = 0 ; k < nchains ; k++)
	{
	    Chain_maxrows [k] = p [k] ;
	}
    }

    if (Chain_maxcols)
    {
	p = Symbolic->Chain_maxcols ;
	for (k = 0 ; k < nchains ; k++)
	{
	    Chain_maxcols [k] = p [k] ;
	}
    }

    return (UMFPACK_OK) ;
}

