/* ========================================================================== */
/* === umfpack_triplet_to_col =============================================== */
/* ========================================================================== */

/* -------------------------------------------------------------------------- */
/* UMFPACK Version 3.2 (Jan. 1, 2002), Copyright (c) 2002 by Timothy A.       */
/* Davis, University of Florida, davis@cise.ufl.edu.  All Rights Reserved.    */
/* See README, umfpack.h, or type "umfpack_details" in Matlab for License.    */
/* -------------------------------------------------------------------------- */

int umfpack_triplet_to_col
(
    int n,
    int nz,
    const int Ti [ ],
    const int Tj [ ],
    const double Tx [ ],
    int Bp [ ],
    int Bi [ ],
    double Bx [ ]
) ;

long umfpack_l_triplet_to_col
(
    long n,
    long nz,
    const long Ti [ ],
    const long Tj [ ],
    const double Tx [ ],
    long Bp [ ],
    long Bi [ ],
    double Bx [ ]
) ;

/*
int Syntax:

    #include "umfpack.h"
    int n, nz, *Ti, *Tj, *Bp, *Bi, status ;
    double *Tx, *Bx ;
    status = umfpack_triplet_to_col (n, nz, Ti, Tj, Tx, Bp, Bi, Bx) ;

long Syntax:

    #include "umfpack.h"
    long n, nz, *Ti, *Tj, *Bp, *Bi, status ;
    double *Tx, *Bx ;
    status = umfpack_l_triplet_to_col (n, nz, Ti, Tj, Tx, Bp, Bi, Bx) ;

Purpose:

    Converts a sparse matrix from "triplet" form to compressed-column form.

    The triplet form of a matrix is a very simple data structure for basic
    sparse matrix operations.  For example, suppose you wish to factorize a
    matrix A coming from a finite element method, in which A is a sum of
    dense submatrices, A = E1 + E2 + E3 + ... .  The entries in each element
    matrix Ei can be concatenated together in the three triplet arrays, and
    any overlap between the elements will be correctly summed by
    umfpack_triplet_to_col.

    Transposing a matrix in triplet form is simple; just interchange the
    use of Ti and Tj.

    Permuting a matrix in triplet form is also simple.  If you want the matrix
    PAQ, or A (P,Q) in Matlab notation, where P [k] = i means that row i of
    A is the kth row of PAQ and Q [k] = j means that column j of A is the kth
    column of PAQ, then do the following.  First, create inverse permutations
    Pinv and Qinv such that Pinv [i] = k if P [k] = i and Qinv [j] = k if
    Q [k] = j.  Next, for the mth triplet (Ti [m], Tj [m], Tx [m]), replace
    Ti [m] with Pinv [Ti [m]] and replace Tj [m] with Qinv [Tj [m]].

    If you have a column-form matrix with duplicate entries or unsorted
    columns, you can sort it and sum up the duplicates by first converting it
    to triplet form with umfpack_col_to_triplet, and then coverting it back
    with umfpack_triplet_to_col.

    You can print the input triplet form with umfpack_report_triplet, and
    the output matrix with umfpack_report_matrix.

    The matrix may be singular (nz can be zero, and empty rows and/or columns
    may exist).

Returns:

    UMFPACK_OK if successful.
    UMFPACK_ERROR_argument_missing if Bp, Bi, Ti, and/or Tj are missing.
    UMFPACK_ERROR_n_nonpositive if n <= 0.
    UMFPACK_ERROR_nz_negative if nz < 0.
    UMFPACK_ERROR_invalid_triplet if for any k, Ti [k] and/or Tj [k] are not in
	the range 0 to n-1.
    UMFPACK_ERROR_out_of_memory if unable to allocate sufficient workspace.

Arguments:

    Int n ;		Input argument, not modified.

	A is an n-by-n matrix.  Restriction: n > 0.  All row and column indices
	in the triplet form must be in the range 0 to n-1.

    Int nz ;		Input argument, not modified.

	The number of entries in the triplet form of the matrix.  Restriction:
	nz >= 0.

    Int Ti [nz] ;	Input argument, not modified.
    Int Tj [nz] ;	Input argument, not modified.
    double Tx [nz] ;	Input argument, not modified.

	Ti, Tj, and Tx hold the "triplet" form of a sparse matrix.  The kth
	nonzero entry is in row i = Ti [k], column j = Tj [k], and has a
	numerical value of a_ij = Tx [k].  The row and column indices i and j
	must be in the range 0 to n-1.  Duplicate entries may be present; they
	are summed in the output matrix.  This is not an error condition.
	The "triplets" may be in any order.  Tx is optional; if Tx and/or Bx
	are not present (a (double *) NULL pointer), then Bx is not computed.

    Int Bp [n+1] ;	Output argument, not modified.

	Bp is an integer array of size n+1 on input.
	On output, Bp holds the "pointers" for the column form of the sparse
	matrix A.  Column j of the matrix A is held in
	Bi [(Bp [j]) ... (Bp [j+1]-1)].  The first entry, Bp [0], is zero, and
	Bp [j] <= Bp [j+1] holds for all j in the range 0 to n-1.  The value
	nz2 = Bp [n] is thus the total number of entries in the pattern of the
	matrix A.  Equivalently, the number of duplicate triplets is
	nz - Bp [n].

    Int Bi [max(n,nz2)] ;	Output argument, not modified.

	Bi is an integer array of size max (n,nz2) on input, where nz2 <= nz.
	Bi is also used as workspace during the conversion, and for this use
	the size of Bi must also be at least n.

	The nonzero pattern (row indices) for column j is stored in
	Bi [(Bp [j]) ... (Bp [j+1]-1)].  The row indices in a given column j
	are in ascending order, and no duplicate row indices are present.
	Row indices are in the range 0 to n-1 (the matrix is 0-based).

    double Bx [nz2] ;	Output argument, not modified, of size nz2 = Bp [n].

	Bx is a double array of size nz2 on input, where nz2 <= nz.  Bx is
	optional; if Tx and/or Bx are not present (a (double *) NULL pointer),
	then Bx is not computed.  If present, Bx holds the numerical values of
	the sparse matrix A.  The nonzero pattern (row indices) for column j is
	stored in Bi [(Bp [j]) ... (Bp [j+1]-1)], and the corresponding
	numerical values are stored in Bx [(Bp [j]) ... (Bp [j+1]-1)].

*/

