/*
 *
 * Copyright (C) 1997, 1998, 1999, 2000, 2001 Loic Dachary
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif /* HAVE_MALLOC_H */
#include <stdlib.h>
#include <uri.h>

#include <stdio.h>
#include <salloc.h>

char* smalloc(int size)
{
  char* tmp = (char*)malloc(size);
  if(tmp == 0) {
    fprintf(stderr, _("cannot malloc %d bytes\n"), size);
    exit(1);
  }
  tmp[0] = '\0';
  return tmp;
}

char* srealloc(char* pointer, int size)
{
  char* tmp = (char*)realloc(pointer, size);
  if(tmp == 0) {
    fprintf(stderr, _("cannot realloc %d bytes\n"), size);
    exit(1);
  }
  return tmp;
}

void static_alloc(char** tmp, int* tmp_size, int new_size)
{
  if(*tmp_size == 0) {
    *tmp_size = 16;
    *tmp = (char*)smalloc(*tmp_size);
  }
  if(*tmp_size < new_size) {
    *tmp_size = new_size + 1;
    *tmp = (char*)srealloc(*tmp, *tmp_size);
  }
}

