/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#ifndef GTK_LINEOBJECTWIDGET_H
#define GTK_LINEOBJECTWIDGET_H

#include <glib.h>
#include <glib-object.h>

G_BEGIN_DECLS
/**
 * LINE_OBJECT_TYPE
 *
 * Returns: the associated #GType to the LineObject objects.
 *
 * Since: 3.4
 */
#define LINE_OBJECT_TYPE         (lineObject_get_type ())
/**
 * LINE_OBJECT:
 *
 * Cast the given object to a #LineObject object.
 *
 * Since: 3.4
 */
#define LINE_OBJECT(obj)         (G_TYPE_CHECK_INSTANCE_CAST ((obj), LINE_OBJECT_TYPE, LineObject))
/**
 * LINE_OBJECT_CLASS
 *
 * Cast the given class to a #LineObjectClass object.
 *
 * Since: 3.4
 */
#define LINE_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), LINE_OBJECT_TYPE, LineObjectClass))
/**
 * IS_LINE_OBJECT
 *
 * Returns: if the given object is a valid #LineObject object.
 *
 * Since: 3.4
 */
#define IS_LINE_OBJECT(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), LINE_OBJECT_TYPE))
/**
 * IS_LINE_OBJECT_CLASS
 *
 * Returns: if the given class is a valid #LineObjectClass class.
 *
 * Since: 3.4
 */
#define IS_LINE_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), LINE_OBJECT_TYPE))

/**
 * LineObject:
 *
 * Private structure to store informations of a #LineObject object.
 *
 * Since: 3.4
 */
typedef struct _LineObject LineObject;
/* typedef struct LineObjectPrivate_struct LineObjectPrivate; */
/**
 * LineObjectClass
 *
 * Private structure to store informations of a #LineObjectClass object.
 *
 * Since: 3.4
 */
typedef struct _LineObjectClass LineObjectClass;

/**
 * lineObject_get_type
 *
 * #GType are unique numbers to identify objects.
 *
 * Returns: the #GType associated with #LineObject objects.
 *
 * Since: 3.4
 */
GType lineObject_get_type(void);
/**
 * lineObjectNew :
 * @label: the name of the group, output in bold.
 *
 * A #LineObject widget is a widget allowing to choose the
 * properties of a line. These properties are the line stipple
 * pattern, its colour and its width. The colour is available through
 * #GtkRange and with a #ColorComboBox widget. There is also a
 * checkbox allowing to turn the line on or off.
 *
 * Returns: a newly created #LineObject widget.
 *
 * Since: 3.4
 */
GtkWidget* lineObjectNew(const gchar *label);

/**
 * lineObjectSet_use:
 * @line: the object to modify ;
 * @status: a boolean.
 *
 * The line can be turn on or off, call this routine to change the
 * interface status.
 */
void lineObjectSet_use(LineObject *line, gboolean status);
/**
 * lineObjectSet_width:
 * @line: the object to modify ;
 * @width: a value.
 *
 * The line can be drawn with a given width, call this routine to change the
 * interface value.
 */
void lineObjectSet_width(LineObject *line, gint width);
/**
 * lineObjectSet_color:
 * @line: the object to modify ;
 * @rgb: a RGB array.
 *
 * The line can is drawn in a given colour. Change the interface
 * values using this routine. The colour ranges are updated and if it
 * correspond to a registered colour, it is selected in the combobox.
 */
void lineObjectSet_color(LineObject *line, float rgb[3]);
/**
 * lineObjectSet_stipple:
 * @line: the object to modify ;
 * @stipple: a value.
 *
 * The line can be drawn with a given stipple pattern, call this
 * routine to change the interface value.
 */
void lineObjectSet_stipple(LineObject *line, guint16 stipple);

G_END_DECLS

#endif
