/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#ifndef PANELCONFIG_H
#define PANELCONFIG_H

#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <visu_tools.h>
#include <gtk_renderingWindowWidget.h>

#include "panelElements.h"


/**
 * panelConfigInit:
 *
 * Should be used in the list declared in externalModules.h to be loaded by
 * V_Sim on start-up. This routine will create the #ToolPanel where the configuration
 * stuff can be done, such as the auto-reloading.
 *
 * Returns: a newly created #ToolPanel object.
 */
ToolPanel* panelConfigInit();

/**
 * panelConfigSet_tabView:
 * @viewed: a boolean value.
 *
 * The note can show its tabs or not. Change this with that method.
 */
void panelConfigSet_tabView(gboolean viewed);
/**
 * panelConfigSet_automaticRefresh:
 * @window: the #VisuRenderingWindow to associated the auto refresh ;
 * @bool: a boolean value.
 *
 * V_Sim can poll the rendered file at periodic intervals to check if the file
 * has been modified. If true, the file is reloaded. Turn this functionality on or off
 * with this method. See panelConfigSet_refreshPeriod() to tune the period of the polling.
 */
void panelConfigSet_automaticRefresh(VisuRenderingWindow *window, int bool);
/**
 * panelConfigSet_refreshPeriod:
 * @window: the #VisuRenderingWindow to associated the auto refresh ;
 * @val: a floating point value in milliseconds.
 *
 * V_Sim can poll the rendered file at periodic intervals. Use this method to tune
 * the period. See panelConfigSet_automaticRefresh() to enable this functionality.
 */
void panelConfigSet_refreshPeriod(VisuRenderingWindow *window, float val);

#endif

