/* valaobjecttype.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valaobjecttype.h>
#include <vala/valacodenode.h>
#include <vala/valatypesymbol.h>




struct _ValaObjectTypePrivate {
	ValaObjectTypeSymbol* _type_symbol;
};

#define VALA_OBJECT_TYPE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_OBJECT_TYPE, ValaObjectTypePrivate))
enum  {
	VALA_OBJECT_TYPE_DUMMY_PROPERTY,
	VALA_OBJECT_TYPE_TYPE_SYMBOL
};
static ValaDataType* vala_object_type_real_copy (ValaDataType* base);
static char* vala_object_type_real_get_cname (ValaDataType* base);
static gboolean vala_object_type_real_stricter (ValaDataType* base, ValaDataType* target_type);
static gpointer vala_object_type_parent_class = NULL;
static void vala_object_type_dispose (GObject * obj);



ValaObjectType* vala_object_type_new (ValaObjectTypeSymbol* type_symbol) {
	ValaObjectType * self;
	g_return_val_if_fail (VALA_IS_OBJECT_TYPE_SYMBOL (type_symbol), NULL);
	self = g_object_newv (VALA_TYPE_OBJECT_TYPE, 0, NULL);
	vala_object_type_set_type_symbol (self, type_symbol);
	vala_data_type_set_data_type (VALA_DATA_TYPE (self), VALA_TYPESYMBOL (type_symbol));
	return self;
}


static ValaDataType* vala_object_type_real_copy (ValaDataType* base) {
	ValaObjectType * self;
	ValaObjectType* result;
	self = VALA_OBJECT_TYPE (base);
	result = vala_object_type_new (self->priv->_type_symbol);
	vala_code_node_set_source_reference (VALA_CODE_NODE (result), vala_code_node_get_source_reference (VALA_CODE_NODE (self)));
	vala_data_type_set_value_owned (VALA_DATA_TYPE (result), vala_data_type_get_value_owned (VALA_DATA_TYPE (self)));
	vala_data_type_set_nullable (VALA_DATA_TYPE (result), vala_data_type_get_nullable (VALA_DATA_TYPE (self)));
	vala_data_type_set_is_dynamic (VALA_DATA_TYPE (result), vala_data_type_get_is_dynamic (VALA_DATA_TYPE (self)));
	vala_data_type_set_floating_reference (VALA_DATA_TYPE (result), vala_data_type_get_floating_reference (VALA_DATA_TYPE (self)));
	{
		GeeList* arg_collection;
		int arg_it;
		arg_collection = vala_data_type_get_type_arguments (VALA_DATA_TYPE (self));
		for (arg_it = 0; arg_it < gee_collection_get_size (GEE_COLLECTION (arg_collection)); arg_it = arg_it + 1) {
			ValaDataType* arg;
			arg = ((ValaDataType*) (gee_list_get (GEE_LIST (arg_collection), arg_it)));
			{
				ValaDataType* _tmp0;
				_tmp0 = NULL;
				vala_data_type_add_type_argument (VALA_DATA_TYPE (result), (_tmp0 = vala_data_type_copy (arg)));
				(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
				(arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL)));
			}
		}
		(arg_collection == NULL ? NULL : (arg_collection = (g_object_unref (arg_collection), NULL)));
	}
	return VALA_DATA_TYPE (result);
}


static char* vala_object_type_real_get_cname (ValaDataType* base) {
	ValaObjectType * self;
	char* _tmp0;
	char* _tmp1;
	self = VALA_OBJECT_TYPE (base);
	_tmp0 = NULL;
	_tmp1 = NULL;
	return (_tmp1 = g_strdup_printf ("%s*", (_tmp0 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (self->priv->_type_symbol), !vala_data_type_get_value_owned (VALA_DATA_TYPE (self))))), (_tmp0 = (g_free (_tmp0), NULL)), _tmp1);
}


static gboolean vala_object_type_real_stricter (ValaDataType* base, ValaDataType* target_type) {
	ValaObjectType * self;
	ValaObjectType* _tmp1;
	ValaDataType* _tmp0;
	ValaObjectType* obj_target_type;
	gboolean _tmp5;
	self = VALA_OBJECT_TYPE (base);
	g_return_val_if_fail (VALA_IS_DATA_TYPE (target_type), FALSE);
	_tmp1 = NULL;
	_tmp0 = NULL;
	obj_target_type = (_tmp1 = (_tmp0 = target_type, (VALA_IS_OBJECT_TYPE (_tmp0) ? ((ValaObjectType*) (_tmp0)) : NULL)), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
	if (obj_target_type == NULL) {
		gboolean _tmp2;
		return (_tmp2 = FALSE, (obj_target_type == NULL ? NULL : (obj_target_type = (g_object_unref (obj_target_type), NULL))), _tmp2);
	}
	if (vala_data_type_get_value_owned (VALA_DATA_TYPE (self)) != vala_data_type_get_value_owned (target_type)) {
		gboolean _tmp3;
		return (_tmp3 = FALSE, (obj_target_type == NULL ? NULL : (obj_target_type = (g_object_unref (obj_target_type), NULL))), _tmp3);
	}
	if (vala_data_type_get_nullable (VALA_DATA_TYPE (self)) && !vala_data_type_get_nullable (target_type)) {
		gboolean _tmp4;
		return (_tmp4 = FALSE, (obj_target_type == NULL ? NULL : (obj_target_type = (g_object_unref (obj_target_type), NULL))), _tmp4);
	}
	return (_tmp5 = vala_typesymbol_is_subtype_of (VALA_TYPESYMBOL (self->priv->_type_symbol), VALA_TYPESYMBOL (obj_target_type->priv->_type_symbol)), (obj_target_type == NULL ? NULL : (obj_target_type = (g_object_unref (obj_target_type), NULL))), _tmp5);
}


ValaObjectTypeSymbol* vala_object_type_get_type_symbol (ValaObjectType* self) {
	g_return_val_if_fail (VALA_IS_OBJECT_TYPE (self), NULL);
	return self->priv->_type_symbol;
}


void vala_object_type_set_type_symbol (ValaObjectType* self, ValaObjectTypeSymbol* value) {
	g_return_if_fail (VALA_IS_OBJECT_TYPE (self));
	self->priv->_type_symbol = value;
}


static void vala_object_type_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaObjectType * self;
	self = VALA_OBJECT_TYPE (object);
	switch (property_id) {
		case VALA_OBJECT_TYPE_TYPE_SYMBOL:
		g_value_set_object (value, vala_object_type_get_type_symbol (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_object_type_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaObjectType * self;
	self = VALA_OBJECT_TYPE (object);
	switch (property_id) {
		case VALA_OBJECT_TYPE_TYPE_SYMBOL:
		vala_object_type_set_type_symbol (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_object_type_class_init (ValaObjectTypeClass * klass) {
	vala_object_type_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaObjectTypePrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_object_type_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_object_type_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_object_type_dispose;
	VALA_DATA_TYPE_CLASS (klass)->copy = vala_object_type_real_copy;
	VALA_DATA_TYPE_CLASS (klass)->get_cname = vala_object_type_real_get_cname;
	VALA_DATA_TYPE_CLASS (klass)->stricter = vala_object_type_real_stricter;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_OBJECT_TYPE_TYPE_SYMBOL, g_param_spec_object ("type-symbol", "type-symbol", "type-symbol", VALA_TYPE_OBJECT_TYPE_SYMBOL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_object_type_instance_init (ValaObjectType * self) {
	self->priv = VALA_OBJECT_TYPE_GET_PRIVATE (self);
}


static void vala_object_type_dispose (GObject * obj) {
	ValaObjectType * self;
	self = VALA_OBJECT_TYPE (obj);
	G_OBJECT_CLASS (vala_object_type_parent_class)->dispose (obj);
}


GType vala_object_type_get_type (void) {
	static GType vala_object_type_type_id = 0;
	if (G_UNLIKELY (vala_object_type_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaObjectTypeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_object_type_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaObjectType), 0, (GInstanceInitFunc) vala_object_type_instance_init };
		vala_object_type_type_id = g_type_register_static (VALA_TYPE_REFERENCE_TYPE, "ValaObjectType", &g_define_type_info, 0);
	}
	return vala_object_type_type_id;
}




