/* vtgprojectbuilder.c generated by valac 0.12.1.1-323029-dirty, the Vala compiler
 * generated from vtgprojectbuilder.vala, do not modify */

/*
 *  vtgprojectbuilder.vala - Vala developer toys for GEdit
 *  
 *  Copyright (C) 2008 - Andrea Del Signore <sejerpz@tin.it>
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *   
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330,
 *  Boston, MA 02111-1307, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gedit/gedit-window.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <vbf.h>
#include <sys/wait.h>
#include <gdk/gdk.h>
#include <signal.h>
#include <sys/types.h>


#define VTG_TYPE_PROJECT_BUILDER (vtg_project_builder_get_type ())
#define VTG_PROJECT_BUILDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PROJECT_BUILDER, VtgProjectBuilder))
#define VTG_PROJECT_BUILDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PROJECT_BUILDER, VtgProjectBuilderClass))
#define VTG_IS_PROJECT_BUILDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PROJECT_BUILDER))
#define VTG_IS_PROJECT_BUILDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PROJECT_BUILDER))
#define VTG_PROJECT_BUILDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PROJECT_BUILDER, VtgProjectBuilderClass))

typedef struct _VtgProjectBuilder VtgProjectBuilder;
typedef struct _VtgProjectBuilderClass VtgProjectBuilderClass;
typedef struct _VtgProjectBuilderPrivate VtgProjectBuilderPrivate;

#define VTG_TYPE_PLUGIN_INSTANCE (vtg_plugin_instance_get_type ())
#define VTG_PLUGIN_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstance))
#define VTG_PLUGIN_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstanceClass))
#define VTG_IS_PLUGIN_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PLUGIN_INSTANCE))
#define VTG_IS_PLUGIN_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PLUGIN_INSTANCE))
#define VTG_PLUGIN_INSTANCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstanceClass))

typedef struct _VtgPluginInstance VtgPluginInstance;
typedef struct _VtgPluginInstanceClass VtgPluginInstanceClass;

#define VTG_TYPE_BUILD_LOG_VIEW (vtg_build_log_view_get_type ())
#define VTG_BUILD_LOG_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_BUILD_LOG_VIEW, VtgBuildLogView))
#define VTG_BUILD_LOG_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_BUILD_LOG_VIEW, VtgBuildLogViewClass))
#define VTG_IS_BUILD_LOG_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_BUILD_LOG_VIEW))
#define VTG_IS_BUILD_LOG_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_BUILD_LOG_VIEW))
#define VTG_BUILD_LOG_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_BUILD_LOG_VIEW, VtgBuildLogViewClass))

typedef struct _VtgBuildLogView VtgBuildLogView;
typedef struct _VtgBuildLogViewClass VtgBuildLogViewClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define VTG_TYPE_OUTPUT_VIEW (vtg_output_view_get_type ())
#define VTG_OUTPUT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_OUTPUT_VIEW, VtgOutputView))
#define VTG_OUTPUT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_OUTPUT_VIEW, VtgOutputViewClass))
#define VTG_IS_OUTPUT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_OUTPUT_VIEW))
#define VTG_IS_OUTPUT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_OUTPUT_VIEW))
#define VTG_OUTPUT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_OUTPUT_VIEW, VtgOutputViewClass))

typedef struct _VtgOutputView VtgOutputView;
typedef struct _VtgOutputViewClass VtgOutputViewClass;

#define VTG_TYPE_OUTPUT_TYPES (vtg_output_types_get_type ())

#define VTG_TYPE_PROJECT_MANAGER (vtg_project_manager_get_type ())
#define VTG_PROJECT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PROJECT_MANAGER, VtgProjectManager))
#define VTG_PROJECT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PROJECT_MANAGER, VtgProjectManagerClass))
#define VTG_IS_PROJECT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PROJECT_MANAGER))
#define VTG_IS_PROJECT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PROJECT_MANAGER))
#define VTG_PROJECT_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PROJECT_MANAGER, VtgProjectManagerClass))

typedef struct _VtgProjectManager VtgProjectManager;
typedef struct _VtgProjectManagerClass VtgProjectManagerClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_main_context_unref0(var) ((var == NULL) ? NULL : (var = (g_main_context_unref (var), NULL)))

struct _VtgProjectBuilder {
	GObject parent_instance;
	VtgProjectBuilderPrivate * priv;
};

struct _VtgProjectBuilderClass {
	GObjectClass parent_class;
};

struct _VtgProjectBuilderPrivate {
	VtgPluginInstance* _plugin_instance;
	VtgBuildLogView* _build_view;
	guint _child_watch_id;
	gboolean is_bottom_pane_visible;
	gint last_exit_code;
	GPid _child_pid;
	gchar* _operation;
};

typedef enum  {
	VTG_OUTPUT_TYPES_MESSAGE,
	VTG_OUTPUT_TYPES_ERROR,
	VTG_OUTPUT_TYPES_CHILD_PROCESS,
	VTG_OUTPUT_TYPES_BUILD,
	VTG_OUTPUT_TYPES_AUTO_BUILD,
	VTG_OUTPUT_TYPES_SEARCH
} VtgOutputTypes;


static gpointer vtg_project_builder_parent_class = NULL;
static GType vtg_project_builder_type_id = 0;

GType vtg_project_builder_get_type (void) G_GNUC_CONST;
GType vtg_project_builder_register_type (GTypeModule * module);
GType vtg_plugin_instance_get_type (void) G_GNUC_CONST;
GType vtg_plugin_instance_register_type (GTypeModule * module);
GType vtg_build_log_view_get_type (void) G_GNUC_CONST;
GType vtg_build_log_view_register_type (GTypeModule * module);
#define VTG_PROJECT_BUILDER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VTG_TYPE_PROJECT_BUILDER, VtgProjectBuilderPrivate))
enum  {
	VTG_PROJECT_BUILDER_DUMMY_PROPERTY,
	VTG_PROJECT_BUILDER_ERROR_PANE,
	VTG_PROJECT_BUILDER_IS_BUILDING
};
void vtg_utils_trace (const gchar* format, ...);
void vtg_build_log_view_destroy (VtgBuildLogView* self);
VtgProjectBuilder* vtg_project_builder_new (VtgPluginInstance* plugin_instance);
VtgProjectBuilder* vtg_project_builder_construct (GType object_type, VtgPluginInstance* plugin_instance);
VtgBuildLogView* vtg_build_log_view_new (VtgPluginInstance* plugin_instance);
VtgBuildLogView* vtg_build_log_view_construct (GType object_type, VtgPluginInstance* plugin_instance);
GeditWindow* vtg_plugin_instance_get_window (VtgPluginInstance* self);
gboolean vtg_project_builder_compile_file (VtgProjectBuilder* self, const gchar* filename, const gchar* params);
GType vtg_output_view_get_type (void) G_GNUC_CONST;
GType vtg_output_view_register_type (GTypeModule * module);
VtgOutputView* vtg_plugin_instance_get_output_view (VtgPluginInstance* self);
void vtg_output_view_clean_output (VtgOutputView* self);
GType vtg_output_types_get_type (void) G_GNUC_CONST;
void vtg_output_view_log_message (VtgOutputView* self, VtgOutputTypes output_type, const gchar* message);
static void vtg_project_builder_on_child_watch (VtgProjectBuilder* self, GPid pid, gint status);
static void _vtg_project_builder_on_child_watch_gchild_watch_func (GPid pid, gint status, gpointer self);
GType vtg_project_manager_get_type (void) G_GNUC_CONST;
GType vtg_project_manager_register_type (GTypeModule * module);
void vtg_build_log_view_initialize (VtgBuildLogView* self, VtgProjectManager* project);
void vtg_output_view_start_watch (VtgOutputView* self, VtgOutputTypes output_type, guint id, gint stdo, gint stde, gint stdi);
void vtg_output_view_activate (VtgOutputView* self);
gboolean vtg_project_builder_build (VtgProjectBuilder* self, VtgProjectManager* project_manager, const gchar* params);
VbfProject* vtg_project_manager_get_project (VtgProjectManager* self);
void vtg_interaction_error_message (const gchar* message, GError* err);
gboolean vtg_project_builder_configure (VtgProjectBuilder* self, VtgProjectManager* project_manager, const gchar* params);
gboolean vtg_project_builder_clean (VtgProjectBuilder* self, VtgProjectManager* project_manager, gboolean vala_stamp);
void vtg_project_builder_next_error (VtgProjectBuilder* self);
void vtg_build_log_view_next_error (VtgBuildLogView* self);
void vtg_project_builder_previous_error (VtgProjectBuilder* self);
void vtg_build_log_view_previous_error (VtgBuildLogView* self);
void vtg_output_view_stop_watch (VtgOutputView* self, guint id);
void vtg_interaction_info_message (const gchar* message);
gint vtg_build_log_view_get_error_count (VtgBuildLogView* self);
void vtg_build_log_view_activate (VtgBuildLogView* self);
void vtg_project_builder_stop_build (VtgProjectBuilder* self);
VtgBuildLogView* vtg_project_builder_get_error_pane (VtgProjectBuilder* self);
gboolean vtg_project_builder_get_is_building (VtgProjectBuilder* self);
static void vtg_project_builder_finalize (GObject* obj);
static void _vala_vtg_project_builder_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


VtgProjectBuilder* vtg_project_builder_construct (GType object_type, VtgPluginInstance* plugin_instance) {
	VtgProjectBuilder * self = NULL;
	VtgBuildLogView* _tmp0_ = NULL;
	GeditWindow* _tmp1_ = NULL;
	GeditPanel* _tmp2_ = NULL;
	gboolean _tmp3_;
	g_return_val_if_fail (plugin_instance != NULL, NULL);
	self = (VtgProjectBuilder*) g_object_new (object_type, NULL);
	self->priv->_plugin_instance = plugin_instance;
	_tmp0_ = vtg_build_log_view_new (self->priv->_plugin_instance);
	_g_object_unref0 (self->priv->_build_view);
	self->priv->_build_view = _tmp0_;
	_tmp1_ = vtg_plugin_instance_get_window (self->priv->_plugin_instance);
	_tmp2_ = gedit_window_get_bottom_panel (_tmp1_);
	_tmp3_ = gtk_widget_get_visible ((GtkWidget*) _tmp2_);
	self->priv->is_bottom_pane_visible = _tmp3_;
	return self;
}


VtgProjectBuilder* vtg_project_builder_new (VtgPluginInstance* plugin_instance) {
	return vtg_project_builder_construct (VTG_TYPE_PROJECT_BUILDER, plugin_instance);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _vtg_project_builder_on_child_watch_gchild_watch_func (GPid pid, gint status, gpointer self) {
	vtg_project_builder_on_child_watch (self, pid, status);
}


gboolean vtg_project_builder_compile_file (VtgProjectBuilder* self, const gchar* filename, const gchar* params) {
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	gchar* working_dir;
	gint stdo = 0;
	gint stde = 0;
	VtgOutputView* _tmp1_ = NULL;
	VtgOutputView* _tmp2_;
	VtgOutputView* log;
	gchar* cmd = NULL;
	gchar** pars = NULL;
	gint pars_length1 = 0;
	gint _pars_size_ = 0;
	gchar** _tmp5_ = NULL;
	gint _tmp6_;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* start_message;
	gint _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_;
	GPid _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (filename != NULL, FALSE);
	if (self->priv->_child_watch_id != 0) {
		result = FALSE;
		return result;
	}
	_tmp0_ = g_path_get_dirname (filename);
	working_dir = _tmp0_;
	_tmp1_ = vtg_plugin_instance_get_output_view (self->priv->_plugin_instance);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	log = _tmp2_;
	if (params != NULL) {
		gchar* _tmp3_ = NULL;
		_tmp3_ = g_strdup_printf ("%s %s %s", "valac", params, filename);
		_g_free0 (cmd);
		cmd = _tmp3_;
	} else {
		gchar* _tmp4_ = NULL;
		_tmp4_ = g_strdup_printf ("valac %s", filename);
		_g_free0 (cmd);
		cmd = _tmp4_;
	}
	g_shell_parse_argv (cmd, &_tmp6_, &_tmp5_, &_inner_error_);
	pars = (_vala_array_free (pars, pars_length1, (GDestroyNotify) g_free), NULL);
	pars = _tmp5_;
	pars_length1 = _tmp6_;
	if (_inner_error_ != NULL) {
		pars = (_vala_array_free (pars, pars_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (cmd);
		goto __catch22_g_error;
	}
	vtg_output_view_clean_output (log);
	_tmp7_ = _ ("Start compiling file: %s\n");
	_tmp8_ = g_strdup_printf (_tmp7_, filename);
	start_message = _tmp8_;
	vtg_output_view_log_message (log, VTG_OUTPUT_TYPES_MESSAGE, start_message);
	_tmp9_ = strlen (start_message);
	_tmp10_ = g_strnfill ((gsize) (_tmp9_ - 1), '-');
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strdup_printf ("%s\n\n", _tmp11_);
	_tmp13_ = _tmp12_;
	vtg_output_view_log_message (log, VTG_OUTPUT_TYPES_MESSAGE, _tmp13_);
	_g_free0 (_tmp13_);
	_g_free0 (_tmp11_);
	_tmp14_ = g_strdup_printf ("%s\n", cmd);
	_tmp15_ = _tmp14_;
	vtg_output_view_log_message (log, VTG_OUTPUT_TYPES_MESSAGE, _tmp15_);
	_g_free0 (_tmp15_);
	g_spawn_async_with_pipes (working_dir, pars, NULL, G_SPAWN_SEARCH_PATH | G_SPAWN_DO_NOT_REAP_CHILD, NULL, NULL, &_tmp16_, NULL, &_tmp17_, &_tmp18_, &_inner_error_);
	self->priv->_child_pid = _tmp16_;
	stdo = _tmp17_;
	stde = _tmp18_;
	if (_inner_error_ != NULL) {
		_g_free0 (start_message);
		pars = (_vala_array_free (pars, pars_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (cmd);
		goto __catch22_g_error;
	}
	if (self->priv->_child_pid != ((GPid) 0)) {
		const gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		guint _tmp21_;
		_tmp19_ = _ ("File '%s': compilation");
		_tmp20_ = g_strdup_printf (_tmp19_, filename);
		_g_free0 (self->priv->_operation);
		self->priv->_operation = _tmp20_;
		_tmp21_ = g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, self->priv->_child_pid, _vtg_project_builder_on_child_watch_gchild_watch_func, g_object_ref (self), g_object_unref);
		self->priv->_child_watch_id = _tmp21_;
		vtg_build_log_view_initialize (self->priv->_build_view, NULL);
		if (self->priv->last_exit_code == 0) {
			GeditWindow* _tmp22_ = NULL;
			GeditPanel* _tmp23_ = NULL;
			gboolean _tmp24_;
			_tmp22_ = vtg_plugin_instance_get_window (self->priv->_plugin_instance);
			_tmp23_ = gedit_window_get_bottom_panel (_tmp22_);
			_tmp24_ = gtk_widget_get_visible ((GtkWidget*) _tmp23_);
			self->priv->is_bottom_pane_visible = _tmp24_;
		}
		vtg_output_view_start_watch (log, VTG_OUTPUT_TYPES_BUILD, self->priv->_child_watch_id, stdo, stde, -1);
		vtg_output_view_activate (log);
		g_signal_emit_by_name (self, "build-start");
	} else {
		vtg_output_view_log_message (log, VTG_OUTPUT_TYPES_MESSAGE, "error compiling file\n");
	}
	result = TRUE;
	_g_free0 (start_message);
	pars = (_vala_array_free (pars, pars_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (cmd);
	_g_object_unref0 (log);
	_g_free0 (working_dir);
	return result;
	_g_free0 (start_message);
	pars = (_vala_array_free (pars, pars_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (cmd);
	goto __finally22;
	__catch22_g_error:
	{
		GError * err;
		gchar* _tmp25_ = NULL;
		gchar* msg;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp25_ = g_strdup_printf ("error spawning compiler process: %s", err->message);
		msg = _tmp25_;
		g_warning ("vtgprojectbuilder.vala:109: %s", msg);
		vtg_output_view_log_message (log, VTG_OUTPUT_TYPES_ERROR, msg);
		result = FALSE;
		_g_free0 (msg);
		_g_error_free0 (err);
		_g_object_unref0 (log);
		_g_free0 (working_dir);
		return result;
	}
	__finally22:
	_g_object_unref0 (log);
	_g_free0 (working_dir);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return FALSE;
}


gboolean vtg_project_builder_build (VtgProjectBuilder* self, VtgProjectManager* project_manager, const gchar* params) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	VbfProject* _tmp4_ = NULL;
	VbfProject* _tmp5_;
	VbfProject* project;
	gchar* _tmp6_;
	gchar* working_dir;
	gint stdo = 0;
	gint stde = 0;
	VtgOutputView* _tmp7_ = NULL;
	VtgOutputView* _tmp8_;
	VtgOutputView* log;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* start_message;
	gint _tmp11_;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_;
	gchar* cmd = NULL;
	gchar** pars = NULL;
	gint pars_length1 = 0;
	gint _pars_size_ = 0;
	gchar** _tmp22_ = NULL;
	gint _tmp23_;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_;
	GPid _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (project_manager != NULL, FALSE);
	if (self->priv->_child_watch_id != 0) {
		_tmp0_ = TRUE;
	} else {
		VbfProject* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		_tmp1_ = vtg_project_manager_get_project (project_manager);
		_tmp2_ = vbf_project_get_build_command (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp0_ = _tmp3_ == NULL;
		_g_free0 (_tmp3_);
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp4_ = vtg_project_manager_get_project (project_manager);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	project = _tmp5_;
	_tmp6_ = g_strdup (project->id);
	working_dir = _tmp6_;
	_tmp7_ = vtg_plugin_instance_get_output_view (self->priv->_plugin_instance);
	_tmp8_ = _g_object_ref0 (_tmp7_);
	log = _tmp8_;
	vtg_output_view_clean_output (log);
	_tmp9_ = _ ("Start building project: %s\n");
	_tmp10_ = g_strdup_printf (_tmp9_, project->name);
	start_message = _tmp10_;
	vtg_output_view_log_message (log, VTG_OUTPUT_TYPES_MESSAGE, start_message);
	_tmp11_ = strlen (start_message);
	_tmp12_ = g_strnfill ((gsize) (_tmp11_ - 1), '-');
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strdup_printf ("%s\n\n", _tmp13_);
	_tmp15_ = _tmp14_;
	vtg_output_view_log_message (log, VTG_OUTPUT_TYPES_MESSAGE, _tmp15_);
	_g_free0 (_tmp15_);
	_g_free0 (_tmp13_);
	if (params != NULL) {
		VbfProject* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_;
		gchar* _tmp19_ = NULL;
		_tmp16_ = vtg_project_manager_get_project (project_manager);
		_tmp17_ = vbf_project_get_build_command (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = g_strdup_printf ("%s %s", _tmp18_, params);
		_g_free0 (cmd);
		cmd = _tmp19_;
		_g_free0 (_tmp18_);
	} else {
		VbfProject* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		_tmp20_ = vtg_project_manager_get_project (project_manager);
		_tmp21_ = vbf_project_get_build_command (_tmp20_);
		_g_free0 (cmd);
		cmd = _tmp21_;
	}
	g_shell_parse_argv (cmd, &_tmp23_, &_tmp22_, &_inner_error_);
	pars = (_vala_array_free (pars, pars_length1, (GDestroyNotify) g_free), NULL);
	pars = _tmp22_;
	pars_length1 = _tmp23_;
	if (_inner_error_ != NULL) {
		pars = (_vala_array_free (pars, pars_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (cmd);
		_g_free0 (start_message);
		_g_object_unref0 (log);
		goto __catch23_g_error;
	}
	_tmp24_ = g_strdup_printf ("%s\n", cmd);
	_tmp25_ = _tmp24_;
	vtg_output_view_log_message (log, VTG_OUTPUT_TYPES_MESSAGE, _tmp25_);
	_g_free0 (_tmp25_);
	g_spawn_async_with_pipes (working_dir, pars, NULL, G_SPAWN_SEARCH_PATH | G_SPAWN_DO_NOT_REAP_CHILD, NULL, NULL, &_tmp26_, NULL, &_tmp27_, &_tmp28_, &_inner_error_);
	self->priv->_child_pid = _tmp26_;
	stdo = _tmp27_;
	stde = _tmp28_;
	if (_inner_error_ != NULL) {
		pars = (_vala_array_free (pars, pars_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (cmd);
		_g_free0 (start_message);
		_g_object_unref0 (log);
		goto __catch23_g_error;
	}
	if (self->priv->_child_pid != ((GPid) 0)) {
		const gchar* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
		guint _tmp31_;
		_tmp29_ = _ ("Project '%s': build");
		_tmp30_ = g_strdup_printf (_tmp29_, project->name);
		_g_free0 (self->priv->_operation);
		self->priv->_operation = _tmp30_;
		_tmp31_ = g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, self->priv->_child_pid, _vtg_project_builder_on_child_watch_gchild_watch_func, g_object_ref (self), g_object_unref);
		self->priv->_child_watch_id = _tmp31_;
		vtg_build_log_view_initialize (self->priv->_build_view, project_manager);
		if (self->priv->last_exit_code == 0) {
			GeditWindow* _tmp32_ = NULL;
			GeditPanel* _tmp33_ = NULL;
			gboolean _tmp34_;
			_tmp32_ = vtg_plugin_instance_get_window (self->priv->_plugin_instance);
			_tmp33_ = gedit_window_get_bottom_panel (_tmp32_);
			_tmp34_ = gtk_widget_get_visible ((GtkWidget*) _tmp33_);
			self->priv->is_bottom_pane_visible = _tmp34_;
		}
		vtg_output_view_start_watch (log, VTG_OUTPUT_TYPES_BUILD, self->priv->_child_watch_id, stdo, stde, -1);
		vtg_output_view_activate (log);
		g_signal_emit_by_name (self, "build-start");
	} else {
		vtg_output_view_log_message (log, VTG_OUTPUT_TYPES_ERROR, "error spawning 'make' process\n");
	}
	result = TRUE;
	pars = (_vala_array_free (pars, pars_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (cmd);
	_g_free0 (start_message);
	_g_object_unref0 (log);
	_g_free0 (working_dir);
	_g_object_unref0 (project);
	return result;
	pars = (_vala_array_free (pars, pars_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (cmd);
	_g_free0 (start_message);
	_g_object_unref0 (log);
	goto __finally23;
	__catch23_g_error:
	{
		GError * err;
		const gchar* _tmp35_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("vtgprojectbuilder.vala:155: Error spawning build process: %s", err->message);
		_tmp35_ = _ ("Build failed");
		vtg_interaction_error_message (_tmp35_, err);
		result = FALSE;
		_g_error_free0 (err);
		_g_free0 (working_dir);
		_g_object_unref0 (project);
		return result;
	}
	__finally23:
	_g_free0 (working_dir);
	_g_object_unref0 (project);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return FALSE;
}


gboolean vtg_project_builder_configure (VtgProjectBuilder* self, VtgProjectManager* project_manager, const gchar* params) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	VbfProject* _tmp4_ = NULL;
	VbfProject* _tmp5_;
	VbfProject* project;
	gchar* _tmp6_;
	gchar* working_dir;
	gint stdo = 0;
	gint stde = 0;
	VbfProject* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* configure_command;
	VtgOutputView* _tmp9_ = NULL;
	VtgOutputView* _tmp10_;
	VtgOutputView* log;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* start_message;
	gint _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_;
	gchar* cmd = NULL;
	gchar** pars = NULL;
	gint pars_length1 = 0;
	gint _pars_size_ = 0;
	gchar** _tmp20_ = NULL;
	gint _tmp21_;
	gchar* _tmp22_ = NULL;
	gchar* _tmp23_;
	GPid _tmp24_;
	gint _tmp25_;
	gint _tmp26_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (project_manager != NULL, FALSE);
	if (self->priv->_child_watch_id != 0) {
		_tmp0_ = TRUE;
	} else {
		VbfProject* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		_tmp1_ = vtg_project_manager_get_project (project_manager);
		_tmp2_ = vbf_project_get_configure_command (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp0_ = _tmp3_ == NULL;
		_g_free0 (_tmp3_);
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp4_ = vtg_project_manager_get_project (project_manager);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	project = _tmp5_;
	_tmp6_ = g_strdup (project->id);
	working_dir = _tmp6_;
	_tmp7_ = vtg_project_manager_get_project (project_manager);
	_tmp8_ = vbf_project_get_configure_command (_tmp7_);
	configure_command = _tmp8_;
	_tmp9_ = vtg_plugin_instance_get_output_view (self->priv->_plugin_instance);
	_tmp10_ = _g_object_ref0 (_tmp9_);
	log = _tmp10_;
	vtg_output_view_clean_output (log);
	_tmp11_ = _ ("Start configure project: %s\n");
	_tmp12_ = g_strdup_printf (_tmp11_, project->name);
	start_message = _tmp12_;
	vtg_output_view_log_message (log, VTG_OUTPUT_TYPES_MESSAGE, start_message);
	_tmp13_ = strlen (start_message);
	_tmp14_ = g_strnfill ((gsize) (_tmp13_ - 1), '-');
	_tmp15_ = _tmp14_;
	_tmp16_ = g_strdup_printf ("%s\n\n", _tmp15_);
	_tmp17_ = _tmp16_;
	vtg_output_view_log_message (log, VTG_OUTPUT_TYPES_MESSAGE, _tmp17_);
	_g_free0 (_tmp17_);
	_g_free0 (_tmp15_);
	if (params != NULL) {
		gchar* _tmp18_ = NULL;
		_tmp18_ = g_strdup_printf ("%s %s", configure_command, params);
		_g_free0 (cmd);
		cmd = _tmp18_;
	} else {
		gchar* _tmp19_;
		_tmp19_ = g_strdup (configure_command);
		_g_free0 (cmd);
		cmd = _tmp19_;
	}
	g_shell_parse_argv (cmd, &_tmp21_, &_tmp20_, &_inner_error_);
	pars = (_vala_array_free (pars, pars_length1, (GDestroyNotify) g_free), NULL);
	pars = _tmp20_;
	pars_length1 = _tmp21_;
	if (_inner_error_ != NULL) {
		pars = (_vala_array_free (pars, pars_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (cmd);
		_g_free0 (start_message);
		_g_object_unref0 (log);
		goto __catch24_g_error;
	}
	_tmp22_ = g_strdup_printf ("%s\n", cmd);
	_tmp23_ = _tmp22_;
	vtg_output_view_log_message (log, VTG_OUTPUT_TYPES_MESSAGE, _tmp23_);
	_g_free0 (_tmp23_);
	g_spawn_async_with_pipes (working_dir, pars, NULL, G_SPAWN_SEARCH_PATH | G_SPAWN_DO_NOT_REAP_CHILD, NULL, NULL, &_tmp24_, NULL, &_tmp25_, &_tmp26_, &_inner_error_);
	self->priv->_child_pid = _tmp24_;
	stdo = _tmp25_;
	stde = _tmp26_;
	if (_inner_error_ != NULL) {
		pars = (_vala_array_free (pars, pars_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (cmd);
		_g_free0 (start_message);
		_g_object_unref0 (log);
		goto __catch24_g_error;
	}
	if (self->priv->_child_pid != ((GPid) 0)) {
		const gchar* _tmp27_ = NULL;
		gchar* _tmp28_ = NULL;
		guint _tmp29_;
		_tmp27_ = _ ("Project '%s': configuration");
		_tmp28_ = g_strdup_printf (_tmp27_, project->name);
		_g_free0 (self->priv->_operation);
		self->priv->_operation = _tmp28_;
		_tmp29_ = g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, self->priv->_child_pid, _vtg_project_builder_on_child_watch_gchild_watch_func, g_object_ref (self), g_object_unref);
		self->priv->_child_watch_id = _tmp29_;
		vtg_build_log_view_initialize (self->priv->_build_view, project_manager);
		if (self->priv->last_exit_code == 0) {
			GeditWindow* _tmp30_ = NULL;
			GeditPanel* _tmp31_ = NULL;
			gboolean _tmp32_;
			_tmp30_ = vtg_plugin_instance_get_window (self->priv->_plugin_instance);
			_tmp31_ = gedit_window_get_bottom_panel (_tmp30_);
			_tmp32_ = gtk_widget_get_visible ((GtkWidget*) _tmp31_);
			self->priv->is_bottom_pane_visible = _tmp32_;
		}
		vtg_output_view_start_watch (log, VTG_OUTPUT_TYPES_BUILD, self->priv->_child_watch_id, stdo, stde, -1);
		vtg_output_view_activate (log);
		g_signal_emit_by_name (self, "build-start");
	} else {
		const gchar* _tmp33_ = NULL;
		gchar* _tmp34_ = NULL;
		gchar* _tmp35_;
		_tmp33_ = _ ("error spawning '%s' process\n");
		_tmp34_ = g_strdup_printf (_tmp33_, configure_command);
		_tmp35_ = _tmp34_;
		vtg_output_view_log_message (log, VTG_OUTPUT_TYPES_ERROR, _tmp35_);
		_g_free0 (_tmp35_);
	}
	result = TRUE;
	pars = (_vala_array_free (pars, pars_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (cmd);
	_g_free0 (start_message);
	_g_object_unref0 (log);
	_g_free0 (configure_command);
	_g_free0 (working_dir);
	_g_object_unref0 (project);
	return result;
	pars = (_vala_array_free (pars, pars_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (cmd);
	_g_free0 (start_message);
	_g_object_unref0 (log);
	goto __finally24;
	__catch24_g_error:
	{
		GError * err;
		const gchar* _tmp36_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("vtgprojectbuilder.vala:202: Error spawning build process: %s", err->message);
		_tmp36_ = _ ("Configure failed");
		vtg_interaction_error_message (_tmp36_, err);
		result = FALSE;
		_g_error_free0 (err);
		_g_free0 (configure_command);
		_g_free0 (working_dir);
		_g_object_unref0 (project);
		return result;
	}
	__finally24:
	_g_free0 (configure_command);
	_g_free0 (working_dir);
	_g_object_unref0 (project);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return FALSE;
}


gboolean vtg_project_builder_clean (VtgProjectBuilder* self, VtgProjectManager* project_manager, gboolean vala_stamp) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	VbfProject* _tmp4_ = NULL;
	VbfProject* _tmp5_;
	VbfProject* project;
	gchar* _tmp6_;
	gchar* working_dir;
	gint stdo = 0;
	gint stde = 0;
	VtgOutputView* _tmp7_ = NULL;
	VtgOutputView* _tmp8_;
	VtgOutputView* log;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* start_message;
	gint _tmp11_;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_;
	gchar** pars = NULL;
	gint pars_length1 = 0;
	gint _pars_size_ = 0;
	gchar* _tmp27_ = NULL;
	gchar* _tmp28_;
	gchar** _tmp29_ = NULL;
	gint _tmp30_;
	gchar* _tmp31_ = NULL;
	gchar* _tmp32_;
	gchar* _tmp33_ = NULL;
	gchar* _tmp34_;
	GPid _tmp35_;
	gint _tmp36_;
	gint _tmp37_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (project_manager != NULL, FALSE);
	if (self->priv->_child_watch_id != 0) {
		_tmp0_ = TRUE;
	} else {
		VbfProject* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		_tmp1_ = vtg_project_manager_get_project (project_manager);
		_tmp2_ = vbf_project_get_clean_command (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp0_ = _tmp3_ == NULL;
		_g_free0 (_tmp3_);
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp4_ = vtg_project_manager_get_project (project_manager);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	project = _tmp5_;
	_tmp6_ = g_strdup (project->working_dir);
	working_dir = _tmp6_;
	_tmp7_ = vtg_plugin_instance_get_output_view (self->priv->_plugin_instance);
	_tmp8_ = _g_object_ref0 (_tmp7_);
	log = _tmp8_;
	vtg_output_view_clean_output (log);
	_tmp9_ = _ ("Start cleaning project: %s\n");
	_tmp10_ = g_strdup_printf (_tmp9_, project->name);
	start_message = _tmp10_;
	vtg_output_view_log_message (log, VTG_OUTPUT_TYPES_MESSAGE, start_message);
	_tmp11_ = strlen (start_message);
	_tmp12_ = g_strnfill ((gsize) (_tmp11_ - 1), '-');
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strdup_printf ("%s\n\n", _tmp13_);
	_tmp15_ = _tmp14_;
	vtg_output_view_log_message (log, VTG_OUTPUT_TYPES_MESSAGE, _tmp15_);
	_g_free0 (_tmp15_);
	_g_free0 (_tmp13_);
	if (vala_stamp) {
		const gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_;
		gchar* _tmp19_ = NULL;
		gchar* command;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_;
		gboolean _tmp22_;
		gboolean _tmp23_;
		_tmp16_ = _ ("cleaning 'stamp' files for project: %s\n");
		_tmp17_ = g_strdup_printf (_tmp16_, project->name);
		_tmp18_ = _tmp17_;
		vtg_output_view_log_message (log, VTG_OUTPUT_TYPES_MESSAGE, _tmp18_);
		_g_free0 (_tmp18_);
		_tmp19_ = g_strdup_printf ("find %s/ -name *.stamp -delete", working_dir);
		command = _tmp19_;
		_tmp20_ = g_strdup_printf ("%s\n\n", command);
		_tmp21_ = _tmp20_;
		vtg_output_view_log_message (log, VTG_OUTPUT_TYPES_MESSAGE, _tmp21_);
		_g_free0 (_tmp21_);
		_tmp22_ = g_spawn_command_line_sync (command, NULL, NULL, NULL, &_inner_error_);
		_tmp23_ = _tmp22_;
		if (_inner_error_ != NULL) {
			_g_free0 (command);
			_g_free0 (start_message);
			_g_object_unref0 (log);
			goto __catch25_g_error;
		}
		if (!_tmp23_) {
			const gchar* _tmp24_ = NULL;
			gchar* _tmp25_ = NULL;
			gchar* _tmp26_;
			_tmp24_ = _ ("error cleaning 'stamp' files for project: %s\n");
			_tmp25_ = g_strdup_printf (_tmp24_, project->name);
			_tmp26_ = _tmp25_;
			vtg_output_view_log_message (log, VTG_OUTPUT_TYPES_ERROR, _tmp26_);
			_g_free0 (_tmp26_);
			result = FALSE;
			_g_free0 (command);
			_g_free0 (start_message);
			_g_object_unref0 (log);
			_g_free0 (working_dir);
			_g_object_unref0 (project);
			return result;
		}
		_g_free0 (command);
	}
	_tmp27_ = vbf_project_get_clean_command (project);
	_tmp28_ = _tmp27_;
	g_shell_parse_argv (_tmp28_, &_tmp30_, &_tmp29_, &_inner_error_);
	pars = (_vala_array_free (pars, pars_length1, (GDestroyNotify) g_free), NULL);
	pars = _tmp29_;
	pars_length1 = _tmp30_;
	_g_free0 (_tmp28_);
	if (_inner_error_ != NULL) {
		pars = (_vala_array_free (pars, pars_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (start_message);
		_g_object_unref0 (log);
		goto __catch25_g_error;
	}
	_tmp31_ = vbf_project_get_clean_command (project);
	_tmp32_ = _tmp31_;
	_tmp33_ = g_strdup_printf ("%s\n", _tmp32_);
	_tmp34_ = _tmp33_;
	vtg_output_view_log_message (log, VTG_OUTPUT_TYPES_MESSAGE, _tmp34_);
	_g_free0 (_tmp34_);
	_g_free0 (_tmp32_);
	g_spawn_async_with_pipes (working_dir, pars, NULL, G_SPAWN_SEARCH_PATH | G_SPAWN_DO_NOT_REAP_CHILD, NULL, NULL, &_tmp35_, NULL, &_tmp36_, &_tmp37_, &_inner_error_);
	self->priv->_child_pid = _tmp35_;
	stdo = _tmp36_;
	stde = _tmp37_;
	if (_inner_error_ != NULL) {
		pars = (_vala_array_free (pars, pars_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (start_message);
		_g_object_unref0 (log);
		goto __catch25_g_error;
	}
	if (self->priv->_child_pid != ((GPid) 0)) {
		const gchar* _tmp38_ = NULL;
		gchar* _tmp39_ = NULL;
		guint _tmp40_;
		_tmp38_ = _ ("Project '%s': cleaning");
		_tmp39_ = g_strdup_printf (_tmp38_, project->name);
		_g_free0 (self->priv->_operation);
		self->priv->_operation = _tmp39_;
		_tmp40_ = g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, self->priv->_child_pid, _vtg_project_builder_on_child_watch_gchild_watch_func, g_object_ref (self), g_object_unref);
		self->priv->_child_watch_id = _tmp40_;
		vtg_build_log_view_initialize (self->priv->_build_view, project_manager);
		if (self->priv->last_exit_code == 0) {
			GeditWindow* _tmp41_ = NULL;
			GeditPanel* _tmp42_ = NULL;
			gboolean _tmp43_;
			_tmp41_ = vtg_plugin_instance_get_window (self->priv->_plugin_instance);
			_tmp42_ = gedit_window_get_bottom_panel (_tmp41_);
			_tmp43_ = gtk_widget_get_visible ((GtkWidget*) _tmp42_);
			self->priv->is_bottom_pane_visible = _tmp43_;
		}
		vtg_output_view_start_watch (log, VTG_OUTPUT_TYPES_BUILD, self->priv->_child_watch_id, stdo, stde, -1);
		vtg_output_view_activate (log);
		g_signal_emit_by_name (self, "build-start");
	} else {
		vtg_output_view_log_message (log, VTG_OUTPUT_TYPES_ERROR, "error spawning 'make clean' process\n");
	}
	result = TRUE;
	pars = (_vala_array_free (pars, pars_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (start_message);
	_g_object_unref0 (log);
	_g_free0 (working_dir);
	_g_object_unref0 (project);
	return result;
	pars = (_vala_array_free (pars, pars_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (start_message);
	_g_object_unref0 (log);
	goto __finally25;
	__catch25_g_error:
	{
		GError * err;
		const gchar* _tmp44_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("vtgprojectbuilder.vala:252: Error spawning clean command: %s", err->message);
		_tmp44_ = _ ("Clean failed");
		vtg_interaction_error_message (_tmp44_, err);
		result = FALSE;
		_g_error_free0 (err);
		_g_free0 (working_dir);
		_g_object_unref0 (project);
		return result;
	}
	__finally25:
	_g_free0 (working_dir);
	_g_object_unref0 (project);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return FALSE;
}


void vtg_project_builder_next_error (VtgProjectBuilder* self) {
	g_return_if_fail (self != NULL);
	vtg_build_log_view_next_error (self->priv->_build_view);
}


void vtg_project_builder_previous_error (VtgProjectBuilder* self) {
	g_return_if_fail (self != NULL);
	vtg_build_log_view_previous_error (self->priv->_build_view);
}


static void vtg_project_builder_on_child_watch (VtgProjectBuilder* self, GPid pid, gint status) {
	VtgOutputView* _tmp0_ = NULL;
	VtgOutputView* _tmp1_;
	VtgOutputView* log;
	gint _tmp2_;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gboolean _tmp9_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = vtg_plugin_instance_get_output_view (self->priv->_plugin_instance);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	log = _tmp1_;
	vtg_output_view_stop_watch (log, self->priv->_child_watch_id);
	_tmp2_ = WEXITSTATUS (status);
	self->priv->last_exit_code = _tmp2_;
	_tmp3_ = _ ("\ncompilation end with exit status %d\n");
	_tmp4_ = g_strdup_printf (_tmp3_, self->priv->last_exit_code);
	_tmp5_ = _tmp4_;
	vtg_output_view_log_message (log, VTG_OUTPUT_TYPES_MESSAGE, _tmp5_);
	_g_free0 (_tmp5_);
	if (self->priv->last_exit_code != 0) {
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp6_ = _ ("%s failed");
		_tmp7_ = g_strdup_printf (_tmp6_, self->priv->_operation);
		_tmp8_ = _tmp7_;
		vtg_interaction_info_message (_tmp8_);
		_g_free0 (_tmp8_);
	}
	if (self->priv->last_exit_code == 0) {
		_tmp9_ = TRUE;
	} else {
		gboolean _tmp10_ = FALSE;
		if (self->priv->last_exit_code != 0) {
			gint _tmp11_;
			_tmp11_ = vtg_build_log_view_get_error_count (self->priv->_build_view);
			_tmp10_ = _tmp11_ > 0;
		} else {
			_tmp10_ = FALSE;
		}
		_tmp9_ = _tmp10_;
	}
	if (_tmp9_) {
		vtg_build_log_view_activate (self->priv->_build_view);
	}
	self->priv->_child_watch_id = (guint) 0;
	g_signal_emit_by_name (self, "build-exit", self->priv->last_exit_code);
	g_spawn_close_pid (pid);
	if (self->priv->last_exit_code == 0) {
		if (!self->priv->is_bottom_pane_visible) {
			GeditWindow* _tmp12_ = NULL;
			GeditPanel* _tmp13_ = NULL;
			_tmp12_ = vtg_plugin_instance_get_window (self->priv->_plugin_instance);
			_tmp13_ = gedit_window_get_bottom_panel (_tmp12_);
			gtk_widget_hide ((GtkWidget*) _tmp13_);
		}
	} else {
		gdk_beep ();
	}
	self->priv->_child_pid = (GPid) 0;
	_g_object_unref0 (log);
}


static gpointer _g_main_context_ref0 (gpointer self) {
	return self ? g_main_context_ref (self) : NULL;
}


void vtg_project_builder_stop_build (VtgProjectBuilder* self) {
	g_return_if_fail (self != NULL);
	if (((gint) self->priv->_child_pid) != 0) {
		gint _tmp0_;
		_tmp0_ = kill ((gint) self->priv->_child_pid, 9);
		if (_tmp0_ != 0) {
			g_warning ("vtgprojectbuilder.vala:301: stop build error: kill failed");
		} else {
			GMainContext* _tmp1_ = NULL;
			GMainContext* _tmp2_;
			GMainContext* ctx;
			_tmp1_ = g_main_context_default ();
			_tmp2_ = _g_main_context_ref0 (_tmp1_);
			ctx = _tmp2_;
			while (TRUE) {
				gboolean _tmp3_ = FALSE;
				if (self->priv->_child_watch_id != 0) {
					gboolean _tmp4_;
					_tmp4_ = g_main_context_pending (ctx);
					_tmp3_ = _tmp4_;
				} else {
					_tmp3_ = FALSE;
				}
				if (!_tmp3_) {
					break;
				}
				g_main_context_iteration (ctx, FALSE);
			}
			_g_main_context_unref0 (ctx);
		}
	}
}


VtgBuildLogView* vtg_project_builder_get_error_pane (VtgProjectBuilder* self) {
	VtgBuildLogView* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_build_view;
	return result;
}


gboolean vtg_project_builder_get_is_building (VtgProjectBuilder* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_child_watch_id != 0;
	return result;
}


static void vtg_project_builder_class_init (VtgProjectBuilderClass * klass) {
	vtg_project_builder_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (VtgProjectBuilderPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_vtg_project_builder_get_property;
	G_OBJECT_CLASS (klass)->finalize = vtg_project_builder_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_PROJECT_BUILDER_ERROR_PANE, g_param_spec_object ("error-pane", "error-pane", "error-pane", VTG_TYPE_BUILD_LOG_VIEW, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_PROJECT_BUILDER_IS_BUILDING, g_param_spec_boolean ("is-building", "is-building", "is-building", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("build_start", VTG_TYPE_PROJECT_BUILDER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("build_exit", VTG_TYPE_PROJECT_BUILDER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
}


static void vtg_project_builder_instance_init (VtgProjectBuilder * self) {
	self->priv = VTG_PROJECT_BUILDER_GET_PRIVATE (self);
	self->priv->_plugin_instance = NULL;
	self->priv->_build_view = NULL;
	self->priv->_child_watch_id = (guint) 0;
	self->priv->last_exit_code = 0;
	self->priv->_operation = NULL;
}


static void vtg_project_builder_finalize (GObject* obj) {
	VtgProjectBuilder * self;
	self = VTG_PROJECT_BUILDER (obj);
	vtg_utils_trace ("vtgprojectbuilder.vala:64: ProjectBuilder destroying");
	vtg_build_log_view_destroy (self->priv->_build_view);
	_g_object_unref0 (self->priv->_build_view);
	self->priv->_build_view = NULL;
	vtg_utils_trace ("vtgprojectbuilder.vala:67: ProjectBuilder destroyed");
	_g_object_unref0 (self->priv->_build_view);
	_g_free0 (self->priv->_operation);
	G_OBJECT_CLASS (vtg_project_builder_parent_class)->finalize (obj);
}


GType vtg_project_builder_get_type (void) {
	return vtg_project_builder_type_id;
}


GType vtg_project_builder_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (VtgProjectBuilderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vtg_project_builder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VtgProjectBuilder), 0, (GInstanceInitFunc) vtg_project_builder_instance_init, NULL };
	vtg_project_builder_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "VtgProjectBuilder", &g_define_type_info, 0);
	return vtg_project_builder_type_id;
}


static void _vala_vtg_project_builder_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	VtgProjectBuilder * self;
	self = VTG_PROJECT_BUILDER (object);
	switch (property_id) {
		case VTG_PROJECT_BUILDER_ERROR_PANE:
		g_value_set_object (value, vtg_project_builder_get_error_pane (self));
		break;
		case VTG_PROJECT_BUILDER_IS_BUILDING:
		g_value_set_boolean (value, vtg_project_builder_get_is_building (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



