/***************************************************************************
                          dchublistmanager.h  -  description
                             -------------------
    begin                : Mon Oct 1 2001
    copyright            : (C) 2001-2004 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DCHUBLISTMANAGER_H
#define DCHUBLISTMANAGER_H

/**
  *@author Mathias Kster
  */

#include <qtimer.h>

#include <DCDialogHubListManager.h>

#include <dcconfig.h>

#include <dclib/core/cbytearray.h>
#include <dclib/core/cstringlist.h>
#include <dclib/chublistmanager.h>

class DCClient;
class QStringList;
class QListView;
class QWorkspace;
class CHttp;

class DCHubListManager : public DCDialogHubListManager, public CHubListManager {
Q_OBJECT

public:
	/** construtor */
	DCHubListManager(QWidget* parent, const char *name, int wflags);
	/** destructor */
	virtual ~DCHubListManager();

	/** */
	void InitDocument();
	/** */
	void DeInitDocument();
	/** */
	void ShowPublicHubList();
	/** */
	void ShowBookmarkList();
	/** */
	void AddBookmark( QString hubname, QString hubhost, QString description );
	/** */
	void RemoveBookmark( QListViewItem * item );
	/** */
	void UpdateBookmark( QString hubname, QString hubhost, QString description );
	/** */
	CStringList * GetFilteredHubList();

	/** overridden so that the columns are resized on show() */
	virtual void show();

	/** callback function */
	virtual int DC_CallBack( CObject * );

protected:
	/** resize the ListView columns */
	void ResizeListViewColumn();

	/** event filter */
	virtual bool eventFilter( QObject * object, QEvent * event );
	/** close event handler */
	virtual void closeEvent( QCloseEvent * ) { };
	/** resize event handler */
	virtual void resizeEvent( QResizeEvent * );

private:
	/** */
	void SetToolBar( QFrame * frame1, QFrame * frame2, bool vis );
	/** */
	int selectedItems( QListView * list, QPtrList<QListViewItem> & lst );

	/** */
	CThread m_HLMThread;
	/** */
	CStringList m_HubFilterList;
	/** */
	QTimer m_Timer;
	/** */
	ulonglong m_nHubListLength;
	/** */
	ulonglong m_nHubListProgress;
	/** */
	CList<CObject> * m_pMessageList;
	/** */
	QWorkspace * m_pWorkspace;

private slots:
	/** reload public hub list */
	void slotReloadPublicHubList();
	/** update public hub list */
	void slotUpdatePublicHubList();
	/** */
	void slotDoubleClicked( QListViewItem * item );
	/** */
	void slotConnect();
	/** */
	void slotRightButtonClickedPublicList( QListViewItem *, const QPoint &, int );
	/** */
	void slotRightButtonClickedBookmarkList( QListViewItem *, const QPoint &, int );
	/** current tab widget change slot */
	void slotTabWidgetCurrentChange( QWidget * );
	/** */
	void slotAddFilter();
	/** */
	void slotEditFilter();
	/** */
	void slotDelFilter();
	/** */
	void slotFilterChange( const QString & );
	/** */
	void timerDone();
};

/** */
extern DCHubListManager * g_pHubListManager;

#endif
