/**********************************************************************
*
*    font0.h
*    =======
*
*    This file is part of the VARKON Graphics Library.
*    URL: http://www.varkon.com
*
*    This library is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Library General Public
*    License as published by the Free Software Foundation; either
*    version 2 of the License, or (at your option) any later version.
*
*    This library is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Library General Public License for more details.
*
*    You should have received a copy of the GNU Library General Public
*    License along with this library; if not, write to the Free
*    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*    (C)Microform AB 1984-1999, Johan Kjellander, johan@microform.se
*
*    24/3/86    Bytt vektab till uchar, J. Kjellander
*    5/5/90     Ny 6:a, J. Kjellander
*    10/10/91   8-bitars , J. Kjellander
*    24/9/92    Nytt W och <> mm. J. Kjellander
*    2/1/93     Fonter, J. Kjellander
*    11/4/95    Alla 256 med, J. Kjellander
*    1999-03-15 New symbols, R. Svedin
*    1999-06-04 Modified , R. Svedin
*
******************************************************!*/

/*
***This file includes the data for the default graphics
***font, ie. TFONT 0. It is a 8 bit font but all 256
***characters are not defined and it does not conform
***exactly to any standard characterset. It has been
***developed under many years to work with Swedish
***national characteris in 7 and 8 bit mode.
*/


/* antab[i] is the number of vectors in each character */

short anttab[]=
  {
     0,4,2,4,5,5,5,5,7,4,7,6,2,9,12,16,
     11,5,4,4,6,3,14,3,3,5,5,0,0,0,0,0,
     0,6,4,7,16,19,11,2,6,6,6,4,6,2,5,1,
     9,3,7,13,4,10,12,3,16,12,10,11,3,4,3,11,
     8,4,11,8,6,6,4,10,5,6,7,5,3,4,3,9,
     6,11,8,12,4,6,3,5,3,5,4,14,19,9,16,2,
     12,9,7,8,7,10,7,12,6,7,8,5,5,7,6,9,
     6,9,5,12,7,7,3,5,3,4,4,13,13,14,11,0,
     0,11,12,0,13,0,14,0,0,0,0,0,0,0,14,9,
     8,22,8,0,13,0,0,0,0,19,16,11,0,11,0,0,
     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, 
     0,6,0,0,0,9,0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,14,9,8,0,0,0,0,0,0,0,0,16,
     0,0,0,0,0,0,19,0,11,0,0,0,16,0,0,15,
     0,15,0,0,13,14,22,0,0,0,0,0,0,0,0,0,
     0,6,0,0,0,0,13,0,11,0,0,0,11,0,0,0
  };

/* pektab[i] holds the offset in vektab to the first vector of each character */

short pektab[]=
  {
     0,0,8,12,20,30,40,50,60,74,
     82,96,108,112,130,154,186,208,218,226,
     234,246,252,280,286,292,302,312,312,312,
     312,312,312,312,324,332,346,378,416,438,
     442,454,466,478,486,498,502,512,514,532,
     538,552,578,586,606,630,636,668,692,712,
     734,740,748,754,776,792,800,822,838,850,
     862,870,890,900,912,926,936,942,950,956,
     974,986,1008,1024,1048,1056,1068,1074,1084,1090,
     1100,1108,1136,1174,1192,1224,1228,1252,1270,1284,
     1300,1314,1334,1348,1372,1384,1398,1414,1424,1434,  
     1448,1460,1478,1490,1508,1518,1542,1556,1570,1576,
     1586,1592,1600,1608,1634,1660,1688,0,0,1688,
     1224,0,1608,0,1660,0,0,0,0,0,
     0,0,1108,1174,776,1710,1754,0,1634,0,
     0,0,0,1136,1192,186,0,1770,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,234,0,0,
     0,1792,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,1108,1174,1754,0,
     0,0,0,0,0,0,0,346,0,0,
     0,0,0,0,1136,0,1770,0,0,0,
     1192,0,0,1810,0,1810,0,0,1608,1660,
     1710,0,0,0,0,0,0,0,0,0,
     0,234,0,0,0,0,1634,0,186,0,
     0,0,1688,0,0,0
  };


/* vektab holds coordinates. X-coordinates >= 32768 = invisible
   move to X-32768. The maxwidth is at X=6000 and all characters
   are assumed to be defined with WIDTH=60%.
   The baseline is at Y=5000. Some caharcters go below this
   level but never lower than zero (unsigned short). The topline
   is at 15000 and some character may go over this but not over 17500. */

unsigned short vektab[]=
{
/* <0> */
/* <1>=[ 0 */
          35733,15000,
          0,15000,
          0,5000,
          2965,5000,
/* <2>=\ 8 */
          32768,15000,
          6000,5000,
/* <3>=] 12 */
          35733,15000,
          6000,15000,
          6000,5000,
          2965,5000,
/* <4>= 20 */
          34250,13289,
          2965,15000,
          4447,13289,
          35733,15000,
          2965,5000,
/* <5> 30 */
          35733,15000,
          2965,5000,
          34180,6711,
          2965,5000,
          4447,6711,
/* <6> 40 */
          34250,11579,
          0,10000,
          1482,8289,
          32768,10000,
          6000,10000,
/* <7> 50 */
          32768,10000,
          6000,10000,
          37215,11579,
          6000,10000,
          4447,8289,
/* <8>={ 60 */
          35733,15000,
          1482,13289,
          1482,11711,
          0,9868,
          1482,8289,
          1482,6579,
          2965,5000,
/* <9>=| 74 */
          35733,15000,
          2965,11579,
          35733,8289,
          2965,5000,
/* <10>=} 82 */
          35733,15000,
          4518,13289,
          4518,11711,
          5929,10000,
          4447,8289,
          4447,6711,
          2965,5000,
/* <11>=~ 96 */
          32768,8289,
          0,10000,
          1482,11711,
          4447,8289,
          6000,10000,
          6000,11711,
/* <12>=` 108 */
          34250,14868,
          4447,11711,
/* <13>= 112 */
          34250,11711,
          424,12105,
          0,13289,
          424,14342,
          1482,15000,
          2471,14342,
          2965,13289,
          2541,12105,
          1482,11711,
/* <14>=$ 130 */
          35733,5000,
          2965,15000,
          38697,11711,
          4447,13289,
          1482,13289,
          0,11711,
          1482,10000,
          4447,10000,
          5929,8421,
          4447,6711,
          1412,6711,
          0,8289,
/* <15>=@ 154 */
          37215,8289,
          2965,6711,
          1482,8289,
          1482,10000,
          2965,11579,
          4518,11579,
          4447,8289,
          6000,6711,
          4518,5000,
          1482,5000,
          0,6711,
          0,13289,
          1482,15000,
          4518,15000,
          6000,13289,
          6000,6711,
/* <16>= 186 */
          33262,6063,
          494,10405,
          1976,11589,
          3953,11589,
          5435,10405,
          5435,6063,
          3953,5000,
          1976,5000,
          494,6063,
          32768,3300,
          6000,13300,
/* <17> 208 */
          32768,6579,
          0,13289,
          6000,13289,
          6000,6579,
          0,6579,
/* <18> 218*/
          32768,13289,
          2965,7632,
          6000,13289,
          0,13289,
/* <19> 226 */
          0,15000,
          6000,15000,
          6000,5000,
          0,5000,
/* <20>= 234 */
          33262,6711,
          5435,6711,
          35733,8289,
          2965,14079,
          33262,11184,
          5435,11184,
/* <21> 246 */
          6000,4079,
          6000,5921,
          0,5000,
/* <22> 252 */
          565,5921,
          5435,5921,
          4871,6842,
          1059,6842,
          1553,7763,
          4376,7763,
          3882,8684,
          2047,8684,
          2471,9605,
          3388,9605,
          2965,10526,
          0,5000,
          6000,5000,
          2965,10526,
/* <23> 280 */
          6000,5000,
          2965,10526,
          0,5000,
/* <24> 286 */
          6000,5000,
          2965,5000,
          2965,17500,
/* <25> 292 */
          38768,13947,
          1482,10000,
          6000,6053,
          38768,5263,
          1482,5263,
/* <26> 302*/
          32768,13947,
          4447,10000,
          0,6053,
          32768,5263,
          4447,5263,
/* <27> 312 */
/* <28> 312 */
/* <29> 312 */
/* <30> 312 */
/* <31> 312 */
/* <32> 312 */
/* <33> 312 */
          35733,5000,
          2682,5526,
          3176,5526,
          2965,5000,
          35733,6711,
          2965,15000,
/* <34> 324 */
          35733,11711,
          2965,15000,
          37286,15000,
          4518,11711,
/* <35> 332 */
          2965,15000,
          38768,15000,
          2965,5000,
          38768,8289,
          0,8289,
          32768,11711,
          6000,11711,
/* <36>= 346 */
          1271,7237,
          37427,12763,
          6000,15000,
          32768,15000,
          1271,12763,
          494,12237,
          494,7763,
          1976,6711,
          3953,6711,
          5435,7763,
          5435,12237,
          3953,13289,
          1976,13289,
          1271,12763,
          37427,7237,
          6000,5000,
/* <37> 378 */
          6000,15000,
          34250,11579,
          424,12105,
          0,13289,
          424,14474,
          1482,15000,
          2471,14342,
          2965,13289,
          2541,12105,
          1482,11579,
          37215,5000,
          3388,5526,
          2965,6579,
          3459,7763,
          4447,8289,
          5506,7763,
          5929,6711,
          5506,5526,
          4447,5000,
/* <38> 416 */
          38768,8289,
          4447,5000,
          1482,5000,
          0,6711,
          0,8289,
          4447,11711,
          4447,13289,
          2965,15000,
          1482,13289,
          1482,11711,
          6000,5000,
/* <39> 438 */
          34250,11711,
          4447,15000,
/* <40> 442 */
          35733,15000,
          1482,15000,
          0,13289,
          0,6711,
          1482,5000,
          2965,5000,
/* <41> 454 */
          35733,15000,
          4447,15000,
          5929,13289,
          5929,6711,
          4447,5000,
          2965,5000,
/* <42> 466 */
          34250,6711,
          4447,13289,
          38697,10000,
          0,10000,
          34250,13289,
          4447,6711,
/* <43> 478 */
          32768,10000,
          5929,10000,
          35733,13289,
          2965,6711,
/* <44> 486 */
          35733,5000,
          1482,5000,
          1482,6579,
          2965,6579,
          2965,5000,
          1482,3289,
/* <45> 498 */
          32768,10000,
          6000,10000,
/* <46> 502 */
          35733,5000,
          1482,5000,
          1482,6711,
          2965,6711,
          2965,5000,
/* <47> 512 */
          6000,15000,
/* <48>=0 514 */
          34744,5000,
          494,6579,
          494,13289,
          2047,15000,
          3953,15000,
          5435,13289,
          5435,6711,
          3953,5000,
          1976,5000,
/* <49>=1 532 */
          32768,13289,
          2965,15000,
          2965,5000,
/* <50>=2 538 */
          32768,13289,
          1482,15000,
          4447,15000,
          6000,13289,
          6000,11711,
          0,5000,
          6000,5000,
/* <51>=3 552 */
          32768,6711,
          1482,5000,
          4447,5000,
          6000,6711,
          6000,8289,
          4447,10000,
          2965,10000,
          37215,10000,
          6000,11711,
          6000,13289,
          4447,15000,
          1482,15000,
          0,13289,
/* <52>=4 578 */
          37215,5000,
          4447,15000,
          0,8289,
          5929,8289,
/* <53>=5 586 */
          32768,6711,
          1482,5000,
          4447,5000,
          5929,6711,
          5929,10000,
          4447,11711,
          1482,11711,
          0,10000,
          0,15000,
          6000,15000,
/* <54>=6 606 */
          32768,8289,
          1482,10000,
          4447,10000,
          5929,8289,
          5929,6711,
          4447,5000,
          1482,5000,
          0,6711,
          0,13289,
          1482,15000,
          4447,15000,
          5929,13289,
/* <55>=7 630 */
          32768,15000,
          5929,15000,
          1482,5000,
/* <56>=8 636 */
          34250,10000,
          0,8289,
          0,6711,
          1482,5000,
          4447,5000,
          5929,6711,
          5929,8289,
          4447,10000,
          5929,11711,
          5929,13289,
          4447,15000,
          1482,15000,
          0,13289,
          0,11711,
          1482,10000,
          4447,10000,
/* <57>=9 668 */
          32768,6711,
          1482,5000,
          4447,5000,
          5929,6711,
          5929,13289,
          4447,15000,
          1482,15000,
          0,13289,
          0,11711,
          1482,10000,
          4447,10000,
          5929,11711,
/* <58>=: 692 */
          34250,5000,
          2965,5000,
          2965,6579,
          1482,6579,
          1482,5000,
          34250,11579,
          2965,11579,
          2965,13289,
          1482,13289,
          1482,11579,
/* <59>=; 712 */
          35733,5000,
          1482,5000,
          1482,6711,
          2965,6711,
          2965,5000,
          1482,3289,
          35733,11579,
          1482,11579,
          1482,13289,
          2965,13289,
          2965,11579,
/* <60>=< 734 */
          38768,13947,
          1482,10000,
          6000,6053,
/* <61>== 740 */
          32768,11711,
          6000,11711,
          32768,8289,
          6000,8289,
/* <62>=> 748 */
          32768,13947,
          4447,10000,
          0,6053,
/* <63>=? 754 */
          32768,13289,
          1482,15000,
          4447,15000,
          5929,13289,
          5929,11711,
          2965,8289,
          2965,6711,
          35944,5526,
          2682,5526,
          2965,5000,
          3176,5526,
/* <64>= 776 */
          0,15000,
          6000,15000,
          32768,10000,
          4447,10000,
          32768,5000,
          5929,5000,
          34956,15789,
          3741,17500,
/* <65>=A 792 */
          2965,15000,
          6000,5000,
          33756,8289,
          4941,8289,
/* <66>=B 800 */
          0,15000,
          4518,15000,
          6000,13289,
          6000,11711,
          4518,10000,
          0,10000,
          37286,10000,
          6000,8289,
          6000,6711,
          4447,5000,
          0,5000,
/* <67>=C 822 */
          38768,6711,
          4447,5000,
          1482,5000,
          0,6711,
          0,13289,
          1482,15000,
          4447,15000,
          6000,13289,
/* <68>=D 838 */
          0,15000,
          4447,15000,
          6000,13289,
          6000,6711,
          4447,5000,
          0,5000,
/* <69>=E 850 */
          0,15000,
          6000,15000,
          32768,10000,
          4447,10000,
          32768,5000,
          6000,5000,
/* <70>=F 862 */
          0,15000,
          6000,15000,
          32768,10000,
          4447,10000,
/* <71>=G 870 */
          38697,13289,
          4447,15000,
          1482,15000,
          0,13289,
          0,6711,
          1482,5000,
          4447,5000,
          5929,6711,
          5929,10000,
          4447,10000,
/* <72>=H 890 */
          0,15000,
          32768,10000,
          6000,10000,
          38768,15000,
          6000,5000,
/* <73>=I 900 */
          34250,15000,
          4447,15000,
          35733,15000,
          2965,5000,
          34250,5000,
          4447,5000,
/* <74>=J 912 */
          32768,6579,
          1482,5000,
          2965,5000,
          4447,6711,
          4447,15000,
          35733,15000,
          6000,15000,
/* <75>=K 926 */
          0,15000,
          38768,15000,
          0,8289,
          34250,10000,
          6000,5000,
/* <76>=L 936 */
          32768,15000,
          0,5000,
          6000,5000,
/* <77>=M 942 */
          0,15000,
          2965,8289,
          6000,15000,
          6000,5000,
/* <78>=N 950 */
          0,15000,
          6000,5000,
          6000,15000,
/* <79>=O 956 */
          34250,5000,
          0,6711,
          0,13289,
          1482,15000,
          4447,15000,
          6000,13289,
          6000,6711,
          4447,5000,
          1482,5000,
/* <80>=P 974 */
          0,15000,
          4447,15000,
          6000,13289,
          6000,11711,
          4447,10000,
          0,10000,
/* <81>=Q 986 */
          34250,5000,
          0,6711,
          0,13289,
          1482,15000,
          4447,15000,
          6000,13289,
          6000,6711,
          4447,5000,
          1482,5000,
          35733,6711,
          6000,5000,
/* <82>=R 1008 */
          0,15000,
          4518,15000,
          6000,13289,
          6000,11711,
          4518,10000,
          0,10000,
          35733,10000,
          6000,5000,
/* <83>=S 1024 */
          32768,6711,
          1482,5000,
          4447,5000,
          6000,6711,
          6000,8289,
          4447,10000,
          1482,10000,
          0,11711,
          0,13289,
          1482,15000,
          4447,15000,
          6000,13289,
/* <84>=T 1048 */
          32768,15000,
          6000,15000,
          35733,15000,
          2965,5000,
/* <85>=U 1056 */
          32768,15000,
          0,6711,
          1482,5000,
          4447,5000,
          6000,6711,
          6000,15000,
/* <86>=V 1068 */
          32768,15000,
          2965,5000,
          6000,15000,
/* <87>=W 1074 */
          32768,14868,
          1341,5000,
          2965,11316,
          4588,5000,
          6000,15000,
/* <88>=X 1084 */
          6000,15000,
          32768,15000,
          6000,5000,
/* <89>=Y 1090 */
          32768,15000,
          2965,10000,
          6000,15000,
          35733,10000,
          2965,5000,
/* <90>=Z 1100 */
          32768,15000,
          6000,15000,
          0,5000,
          6000,5000,
/* <91>= 1108 */
          2965,15000,
          6000,5000,
          33756,8289,
          4941,8289,
          33544,15789,
          776,17500,
          2188,17500,
          2188,15789,
          776,15789,
          36509,15789,
          3741,17500,
          5153,17500,
          5153,15789,
          3741,15789,
/* <92>= 1136 */
          34250,5000,
          0,6711,
          0,13289,
          1482,15000,
          4447,15000,
          5929,13289,
          5929,6711,
          4447,5000,
          1482,5000,
          34956,15789,
          776,15789,
          776,17500,
          2188,17500,
          2188,15789,
          36509,15789,
          3741,17500,
          5153,17500,
          5153,15789,
          3741,15789,
/* <93>= 1174 */
          2965,15000,
          6000,5000,
          33756,8289,
          4941,8289,
          34956,15789,
          2188,17500,
          3741,17500,
          3741,15789,
          2188,15789,
/* <94>= 1192 */
          32768,15000,
          0,6711,
          1482,5000,
          4447,5000,
          6000,6711,
          6000,15000,
          34956,15789,
          776,15789,
          776,17500,
          2188,17500,
          2188,15789,
          36509,15789,
          3741,17500,
          5153,17500,
          5153,15789,
          3741,15789,
/* <95>=_ 1224 */
          32768,4079,
          6000,4079,
/* <96>= 1228 */
          32768,7763,
          6000,7763,
          6000,9605,
          4024,10526,
          1976,10526,
          0,9605,
          0,5921,
          1976,5000,
          3953,5000,
          6000,5921,
          34744,12237,
          3953,14079,
/* <97>=a 1252 */
          38768,6842,
          4024,5000,
          988,5000,
          0,5921,
          0,8553,
          2047,10395,
          4024,10395,
          6000,9474,
          6000,5000,
/* <98>=b 1270 */
          0,14079,
          32768,10526,
          3953,10526,
          6000,8684,
          6000,6842,
          3953,5000,
          0,5000,
/* <99>=c 1284 */
          38768,5921,
          3953,5000,
          1976,5000,
          0,6842,
          0,8684,
          1976,10526,
          3953,10526,
          6000,9474,
/* <100>=d 1300 */
          38768,14079,
          6000,5000,
          1976,5000,
          0,6842,
          0,8684,
          1976,10526,
          6000,10526,
/* <101>=e 1314 */
          32768,7763,
          6000,7763,
          6000,9605,
          4024,10526,
          2047,10526,
          0,9605,
          0,5921,
          1976,5000,
          3953,5000,
          6000,5921,
/* <102>=f 1334 */
          32768,10395,
          3953,10395,
          38768,14079,
          4941,15000,
          2965,15000,
          1976,14079,
          1976,5000,
/* <103>=g 1348 */
          32768,3158,
          1976,1316,
          3953,1316,
          6000,3158,
          6000,10395,
          38768,8684,
          4024,10395,
          1976,10395,
          0,8684,
          0,6711,
          1976,5000,
          6000,5000,
/* <104>=h 1372 */
          0,14079,
          32768,8684,
          1976,10526,
          3953,10526,
          6000,8684,
          6000,5000,
/* <105>=i 1384 */
          33756,5000,
          5012,5000,
          35733,5000,
          2965,10395,
          988,10395,
          35733,12237,
          2965,14079,
/* <106>=j 1398 */
          32768,3158,
          1059,1316,
          2965,1316,
          3953,3158,
          3953,10395,
          2965,10395,
          36721,12237,
          3953,14079,
/* <107>=k 1414 */
          0,14079,
          32768,8684,
          6000,10526,
          35733,9474,
          6000,5000,
/* <108>=l 1424 */
          33756,5000,
          4941,5000,
          35733,5000,
          2965,15000,
          988,15000,
/* <109>=m 1434 */
          0,10526,
          32768,8684,
          2965,10526,
          2965,5000,
          35733,8684,
          6000,10526,
          6000,5000,
/* <110>=n 1448 */
          0,10526,
          32768,8684,
          1976,10526,
          3953,10526,
          6000,8684,
          6000,5000,
/* <111>=o 1460 */
          36721,5000,
          1976,5000,
          0,6842,
          0,8684,
          1976,10526,
          3953,10526,
          6000,8684,
          5929,6842,
          3953,5000,
/* <112>=p 1478 */
          3953,5000,
          6000,6842,
          6000,8684,
          3953,10526,
          0,10526,
          0,1316,
/* <113>=q 1490 */
          38768,5000,
          1976,5000,
          0,6842,
          0,8684,
          1976,10526,
          3953,10526,
          6000,8684,
          38768,10526,
          6000,1316,
/* <114>=r 1508 */
          0,10526,
          32768,8684,
          1976,10526,
          3953,10526,
          6000,8684,
/* <115>=s 1518 */
          32768,5921,
          1976,5000,
          3953,5000,
          5929,5921,
          5929,6842,
          3953,7763,
          1976,7763,
          0,8684,
          0,9474,
          1976,10395,
          4024,10395,
          6000,9605,
/* <116>=t 1542 */
          32768,10526,
          3953,10526,
          34744,14079,
          1976,5921,
          2965,5000,
          4941,5000,
          6000,5921,
/* <117>=u 1556 */
          32768,10526,
          0,6842,
          1976,5000,
          3953,5000,
          5929,6842,
          38697,10526,
          5929,5000,
/* <118>=v 1570 */
          32768,10395,
          2965,5000,
          6000,10395,
/* <119>=w 1576 */
          32768,10395,
          1482,5000,
          2965,10395,
          4447,5000,
          6000,10395,
/* <120>=x 1586 */
          6000,10395,
          32768,10395,
          6000,5000,
/* <121>=y 1592 */
          32768,10395,
          2965,5000,
          33756,1316,
          5929,10395,
/* <122>=z 1600 */
          32768,10395,
          5929,10395,
          0,5000,
          5929,5000,
/* <123>= 1608 */
          38697,6842,
          4024,5000,
          988,5000,
          0,5921,
          0,8553,
          2047,10395,
          4024,10395,
          5929,9474,
          5929,5000,
          34744,14079,
          1976,12237,
          36721,14079,
          3953,12237,
/* <124>= 1634 */
          32768,6842,
          0,8684,
          1976,10526,
          3953,10526,
          6000,8684,
          6000,6842,
          3953,5000,
          1976,5000,
          0,6842,
          34744,14079,
          1976,12237,
          36721,14079,
          3953,12237,
/* <125>= 1660 */
          38697,6842,
          4024,5000,
          988,5000,
          0,5921,
          0,8553,
          2047,10395,
          4024,10395,
          5929,9474,
          5929,5000,
          35027,12237,
          2259,13947,
          3741,13947,
          3741,12237,
          2259,12237,
/* <126>= 1688 */
          32768,10395,
          0,6842,
          1976,5000,
          3953,5000,
          5929,6842,
          38697,5000,
          5929,10395,
          34744,14079,
          1976,12237,
          36721,14079,
          3953,12237,
/* <145>= 1710 */
          35768,8316,
          494,7800,
          0,6815,
          0,6105,
          494,5000,
          2012,5000,
          3000,6105,
          3000,10526,
          2012,11600,
          1023,11600,
          0,10526,
          0,9916,
          35768,8316,
          6000,8316,
          6000,10526,
          5012,11600,
          4023,11600,
          3000,10526,
          35768,6105,
          3988,5000,
          4977,5000,
          6000,6105,
/* <146>= 1754 */
          32768,5000,
          1977,15000,
          6000,15000,
          35768,15000,
          3000,5000,
          6000,5000,
          33756,10000,
          5500,10000,
/* <157>= 1770 */
          34250,5000,
          0,6711,
          0,13289,
          1482,15000,
          4447,15000,
          6000,13289,
          6000,6711,
          4447,5000,
          1482,5000,
          32768,4000,
          6000,16000,
/* <181>=MY 1792 */
          32798,1250,
          30,10526,
          32798,6842,
          2006,5000,
          3983,5000,
          5959,6842,
          5959,10526,
          38727,6842,
          5959,5000,
/* <223>= 1810 */
          34085,5000,
          1317,14079,
          1976,15000,
          3295,15000,
          4400,14079,
          4400,12550,
          3200,11263,
          3200,10156,
          4123,8867,
          5044,8867,
          6000,7570,
          6000,6298,
          5039,5000,
          4117,5000,
          3198,6288
};
