/*
 file: progresswin.cc
*/
#include "progresswin.h"
/*
 */
DEFINE_SIGNAL_MAP(ProgressWin,VDKForm)
  ON_SIGNAL(timer,timer_tick_signal,OnTimer),
  ON_SIGNAL(start,clicked_signal,Start),
  ON_SIGNAL(stop,clicked_signal,Stop),
  ON_SIGNAL(quit,clicked_signal,Quit)
END_SIGNAL_MAP
  

const int maxTime = 20;    
static int timeElapsed = 0;
static char buff[64];
/*
 */
void
ProgressWin::Setup()
{
  timer = new VDKTimer(this,1000,false); // 1 second tick
  VDKBox* vbox = new VDKBox(this,v_box);
  vbox->Add( bar = new VDKProgressBar(this,0,20)); 
  bar->BarStyle = GTK_PROGRESS_DISCRETE;
  bar->BlockCount = 20;
  bar->NormalBackground = clWhite;
  bar->PrelightBackground = VDKRgb("dodger blue");
  vbox->Add( label = new VDKLabel(this,""));
  vbox->Add(new VDKSeparator(this));
  Add(vbox);  
  VDKBox* hbox = new VDKBox(this,h_box);
  hbox->Add(start = new VDKLabelButton(this,"Start"));
  hbox->Add(stop  = new VDKLabelButton(this,"Stop"));
  hbox->Add(quit  = new VDKLabelButton(this,"Quit"));
  Add(hbox);
  timeElapsed = 0;
}
/*
 */ 
bool ProgressWin::OnTimer(VDKObject*)
{
timeElapsed++;
bar->Value = double(timeElapsed);
sprintf(buff,"Time elapsed: %.0f - Remaining:%.0f",
	bar->Position(),
	maxTime - bar->Value);
label->Caption = buff;
if(timeElapsed >= maxTime)
  {
    timeElapsed = 0;
    Close();
  }
return true;
}  
 
/*
 */
bool ProgressWin::Start(VDKObject*)
{
sprintf(buff,"Time elapsed: %.0f - Remaining:%.0f",
	bar->Position(),
	maxTime - bar->Value);
label->Caption = buff;
timer->Start();
return true;
}
/*
 */ 
bool ProgressWin::Stop(VDKObject*)
{
timer->Stop();
return true;
}  
/*
 */
bool ProgressWin::CanClose()
{
timer->Stop();
return true;
}
/*
 */
void ProgressWin::OnShow(VDKForm*) 
{
quit->Cursor = curHandPtr;
start->Cursor = curHandPtr;
stop->Cursor = curHandPtr;
}
  
 
 
