/*
 * menu.h: A plugin for the Video Disk Recorder
 *
 * See the README file for copyright information and how to reach the author.
 *
 * $Id$
 */


#ifndef __CON_MENU_H_
#define __CON_MENU_H_



#include <vdr/font.h>
#include <vdr/menu.h>
#include <vdr/menuitems.h>

#include "config.h"
#include "virtualconsole.h"



#ifndef assert
#define assert(a...)
#endif





// --- cMenuEditComboItem ----------------------------------------------------

struct sMenuEditComboItemData {
  int Key;
  const char* Value;
};



class cMenuEditComboItem : public cMenuEditIntItem {
protected:
  sMenuEditComboItemData *_data;
  int _dataCount;
  int _index;
  int* _pValue;
  virtual void Set(void);

public:
  cMenuEditComboItem(const char *Name, int *pValue, sMenuEditComboItemData *data, int dataCount);
  ~cMenuEditComboItem();
};





// --- cMenuSetup ---------------------------------------------------------------

class cMenuConsoleSetup : public cMenuSetupPage {
private:
  sConsoleConfig data;

protected:
  void AddNewCategory( const char* title );
  virtual void Store(void);

public:
  cMenuConsoleSetup();
};





// --- cMenuConsole -------------------------------------------------------------

#define INPUT_BUFSIZE 1024

class cMenuConsole : public cOsdObject {
private:
  int _pixelW, _pixelH, _charsW, _charsH, _charW, _charH;

  int _consoleNr;
  int _selectedFont;
  const cFont* _pFont;
  cBitmap *_pBitmap;
  cOsd* _pOsd;

  cConsVirtualConsole* _pConsole;
  bool _inputActivated;

  bool _blink, _blinkOld;
  int _inputState;
  bool _needClear;
  int _toRing;

  cOsdObject* _pSubMenu;
  int _nextBlinkTime;
  int _timeReleaseCapture;

private:
  void CaptureKeyboard();
  void ReleaseKeyboard();
  void WriteToConsole(const uint64& code);
  bool TerminateConsole();

  void AddSubMenu(cOsdObject* pSubMenu);
  eOSState CloseSubMenu();

  void DisplayStateInfo(bool autoClose = false);
  void Status(const char* message);
  bool Confirm(const char* message);

public:
  cMenuConsole(int consoleNr);
  void Open(int consoleNr);
  ~cMenuConsole();
  virtual void Show();
  void Display(bool flush);
  virtual eOSState ProcessKey(eKeys Key);

  const char* getTitle() { return _pConsole->getTitle(); }
  bool getCaptured() { return _inputActivated; }
  bool getToRing() { return _toRing; }
};





// --- cMenuConsoleList ---------------------------------------------------------

class cMenuConsoleList : public cOsdMenu {
private:
  void UpdateHelp();
  virtual void Set();
  bool TerminateConsole();

public:
  cMenuConsoleList();
  ~cMenuConsoleList();
  virtual eOSState ProcessKey(eKeys Key);
};





// --- cMenuCommands ---------------------------------------------------------

class cMenuConsoleCommands : public cOsdMenu {
private:
  int nrConsole;
private:
  eOSState Execute(void);
public:
  cMenuConsoleCommands(void);
  virtual eOSState ProcessKey(eKeys Key);
};



#endif // __CON_MENU_H_


