/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.fop.apps.Driver;
import org.apache.fop.apps.Version;
import org.apache.fop.configuration.Configuration;
import org.apache.fop.messaging.MessageHandler;
import org.apache.fop.tools.xslt.XSLTransform;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XalanCommandLine {
    private String foFile = null;
    private String pdfFile = null;
    private String xsltFile = null;
    private String userConfigFile = null;
    private String baseDir = null;
    private boolean dumpConfiguration = false;
    private static boolean errorDump = false;

    public XalanCommandLine(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-d") || stringArray[n].equals("--full-error-dump")) {
                errorDump = true;
            } else if (stringArray[n].equals("-x")) {
                this.dumpConfiguration = true;
            } else if (stringArray[n].charAt(0) == '-' && stringArray[n].charAt(1) == 'c') {
                this.userConfigFile = stringArray[n].substring(2);
            } else if (stringArray[n].charAt(0) == '-') {
                this.printUsage(stringArray[n]);
            } else if (this.foFile == null) {
                this.foFile = stringArray[n];
            } else if (this.xsltFile == null) {
                this.xsltFile = stringArray[n];
            } else if (this.pdfFile == null) {
                this.pdfFile = stringArray[n];
            } else {
                this.printUsage(stringArray[n]);
            }
            ++n;
        }
        if (this.foFile == null || this.pdfFile == null || this.xsltFile == null) {
            this.printUsage(null);
        }
    }

    static XMLReader createParser() {
        String string = System.getProperty("org.xml.sax.parser");
        if (string == null) {
            string = "org.apache.xerces.parsers.SAXParser";
        }
        MessageHandler.logln("using SAX parser " + string);
        try {
            return (XMLReader)Class.forName(string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            MessageHandler.errorln("Could not find " + string);
        }
        catch (InstantiationException instantiationException) {
            MessageHandler.errorln("Could not instantiate " + string);
        }
        catch (IllegalAccessException illegalAccessException) {
            MessageHandler.errorln("Could not access " + string);
        }
        catch (ClassCastException classCastException) {
            MessageHandler.errorln(String.valueOf(string) + " is not a SAX driver");
        }
        return null;
    }

    protected static InputSource fileInputSource(String string) {
        File file = new File(string);
        String string2 = file.getAbsolutePath();
        String string3 = System.getProperty("file.separator");
        if (string3 != null && string3.length() == 1) {
            string2 = string2.replace(string3.charAt(0), '/');
        }
        if (string2.length() > 0 && string2.charAt(0) != '/') {
            string2 = String.valueOf('/') + string2;
        }
        try {
            return new InputSource(new URL("file", null, string2).toString());
        }
        catch (MalformedURLException malformedURLException) {
            throw new Error("unexpected MalformedURLException");
        }
    }

    public static void main(String[] stringArray) {
        XalanCommandLine xalanCommandLine = new XalanCommandLine(stringArray);
        xalanCommandLine.run();
    }

    public void printUsage(String string) {
        if (string != null) {
            MessageHandler.errorln("Unkown argument: '" + string + "'");
        }
        MessageHandler.errorln("Usage: java [-d] [-x][-cMyConfigFile] org.apache.fop.apps.XalanCommandLine xml-file xslt-file pdf-file");
        MessageHandler.errorln("Options:\n  -d or --full-error-dump    Show stack traces upon error");
        MessageHandler.errorln("  -x                           dump configuration information");
        MessageHandler.errorln("-cMyConfigFile use values in configuration file MyConfigFile instead of/additional to default");
        System.exit(1);
    }

    public void run() {
        Driver driver = new Driver();
        if (errorDump) {
            driver.setErrorDump(true);
        }
        if (this.userConfigFile != null) {
            driver.loadUserconfiguration(this.userConfigFile);
        }
        if (this.dumpConfiguration) {
            Configuration.dumpConfiguration();
            System.exit(0);
        }
        driver.setBaseDir(this.foFile);
        String string = Version.getVersion();
        MessageHandler.logln(string);
        XMLReader xMLReader = XalanCommandLine.createParser();
        if (xMLReader == null) {
            MessageHandler.errorln("ERROR: Unable to create SAX parser");
            System.exit(1);
        }
        try {
            xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        }
        catch (SAXException sAXException) {
            MessageHandler.errorln("Error in setting up parser feature namespace-prefixes");
            MessageHandler.errorln("You need a parser which supports SAX version 2");
            System.exit(1);
        }
        try {
            Writer writer;
            boolean bl = false;
            MessageHandler.logln("transforming to xsl:fo markup");
            if (new File(this.foFile).length() > 500000L) {
                writer = new FileWriter(String.valueOf(this.pdfFile) + ".tmp");
                bl = true;
            } else {
                writer = new StringWriter();
            }
            XSLTransform.transform(this.foFile, this.xsltFile, writer);
            Reader reader = bl ? new FileReader(String.valueOf(this.pdfFile) + ".tmp") : new StringReader(writer.toString());
            writer.flush();
            writer.close();
            driver.setRenderer("org.apache.fop.render.pdf.PDFRenderer", string);
            driver.addElementMapping("org.apache.fop.fo.StandardElementMapping");
            driver.addElementMapping("org.apache.fop.svg.SVGElementMapping");
            driver.addElementMapping("org.apache.fop.extensions.ExtensionElementMapping");
            driver.addPropertyList("org.apache.fop.fo.StandardPropertyListMapping");
            driver.addPropertyList("org.apache.fop.svg.SVGPropertyListMapping");
            driver.addPropertyList("org.apache.fop.extensions.ExtensionPropertyListMapping");
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.pdfFile));
            driver.setOutputStream(bufferedOutputStream);
            driver.buildFOTree(xMLReader, new InputSource(reader));
            reader.close();
            driver.format();
            driver.render();
            if (bl) {
                new File(String.valueOf(this.pdfFile) + ".tmp").delete();
            }
            ((OutputStream)bufferedOutputStream).flush();
            ((OutputStream)bufferedOutputStream).close();
        }
        catch (Exception exception) {
            MessageHandler.errorln("FATAL ERROR: " + exception.getMessage());
            if (errorDump) {
                exception.printStackTrace();
            }
            System.exit(1);
        }
    }
}

