/*
                  VMA Editor - Drag and Drop Callbacks
 */

#ifndef EDITORDND_H
#define EDITORDND_H


#include <gtk/gtk.h>
#include "editor.h"
#include "vma.h"

/*
 *	Drag and drop type strings, these are passed as the dnd type and
 *	as such specifiy the dnd command string format.
 */
/* Move/copy primitive(s). */
#define EDITOR_DND_TYPE_PRIMITIVES_CMD	"VMA_V3D_PRIMITIVES_CMD"
/* Move/copy model(s). */
#define EDITOR_DND_TYPE_MODELS_CMD	"VMA_V3D_MODELS_CMD"
/* Create new model. */
#define EDITOR_DND_TYPE_MODEL_CREATE_CMD	"VMA_V3D_MODEL_CREATE_CMD"
/* Create new primitive. */
#define EDITOR_DND_TYPE_PRIMITIVE_CREATE_CMD	"VMA_V3D_PRIMITIVE_CREATE_CMD"
/* Set values list vertex. */
#define EDITOR_DND_TYPE_VALUES_SET_CMD		"VMA_V3D_VALUES_SET_CMD"


/* Values set parsing (external functions need this). */
void EditorDNDParseValuesSetCmd(
        const char *string,
        vma_core_struct **core_ptr,
        ma_editor_struct **editor_ptr, int *editor_num,
        int *value_num,
        mp_vertex_struct **v, mp_vertex_struct **n, mp_vertex_struct **tc
);


/* DND handling for the models list. */
extern void EditorDNDModelsListSetIcon(
        ma_editor_struct *editor, int x, int y
);
extern void EditorDNDModelsListDataRequestCB(
        GtkWidget *widget, GdkDragContext *dc,
        GtkSelectionData *selection_data, guint info, guint t,
        gpointer data
);
extern void EditorDNDModelsListDataRecievedCB(
        GtkWidget *widget,
        GdkDragContext *dc,
        gint x, gint y,
        GtkSelectionData *selection_data,
        guint info, guint t,
        gpointer data
);
extern void EditorDNDModelsListDataDeleteCB(
        GtkWidget *widget, GdkDragContext *dc, gpointer data
);

/* DND handling for the primitives list. */
extern void EditorDNDPrimitivesListSetIcon(
        ma_editor_struct *editor, int x, int y
);
extern void EditorDNDPrimitivesListDataRequestCB(
        GtkWidget *widget, GdkDragContext *dc,
        GtkSelectionData *selection_data, guint info, guint t,
        gpointer data
);
extern void EditorDNDPrimitivesListDataRecievedCB(
        GtkWidget *widget,
        GdkDragContext *dc,
        gint x, gint y,
        GtkSelectionData *selection_data,
        guint info, guint t,
        gpointer data
);
extern void EditorDNDPrimitivesListDataDeleteCB(
	GtkWidget *widget, GdkDragContext *dc, gpointer data
);

/* DND handling for the values list. */
extern void EditorDNDValuesListSetIcon(
	ma_editor_struct *editor, int x, int y
);
extern void EditorDNDValuesListDataRequestCB(
        GtkWidget *widget, GdkDragContext *dc,
        GtkSelectionData *selection_data, guint info, guint t,
        gpointer data
);
extern void EditorDNDValuesListDataRecievedCB(
        GtkWidget *widget,
        GdkDragContext *dc,
        gint x, gint y,
        GtkSelectionData *selection_data,
        guint info, guint t,
        gpointer data
);
extern void EditorDNDValuesListDataDeleteCB(
        GtkWidget *widget, GdkDragContext *dc, gpointer data
);


#endif	/* EDITORDND_H */
