/*
               Model Viewport Display Windows Callbacks
 */


#ifndef VIEWCB_H
#define VIEWCB_H

#include <gtk/gtk.h>
#include "view.h"



extern void View2DRecordPositionsCB(vma_view2d_struct *v);
extern void View3DRecordPositionsCB(vma_view3d_struct *v);

extern gint View2DViewEventCB(
	GtkWidget *widget, gpointer event, gpointer data
);
extern gint View3DViewEventCB(
	GtkWidget *widget, gpointer event, gpointer data
);

extern void View2DTextEnterCB(GtkWidget *widget, gpointer data);
extern void View3DTextEnterCB(GtkWidget *widget, gpointer data);

extern void View2DSpinChangeCB(GtkWidget *widget, gpointer data);
extern void View3DSpinChangeCB(GtkWidget *widget, gpointer data);

extern gint View2DEnabledDACB(
	GtkWidget *widget, GdkEvent *event, gpointer data
);
extern gint View3DEnabledDACB(
	GtkWidget *widget, GdkEvent *event, gpointer data
);

extern void View2DEnabledCB(GtkWidget *widget, gpointer data);
extern void View3DEnabledCB(GtkWidget *widget, gpointer data);

extern gint View2DMenuMapCB(
	GtkWidget *widget, gpointer event, gpointer data
);
extern gint View3DMenuMapCB(
	GtkWidget *widget, gpointer event, gpointer data
);

extern void View2DButtonMenuMapCB(GtkButton *button, gpointer data);
extern void View2DMenuHideCB(GtkWidget *widget, gpointer data);
extern void View3DButtonMenuMapCB(GtkButton *button, gpointer data);
extern void View3DMenuHideCB(GtkWidget *widget, gpointer data);

extern void View2DUndoCB(GtkWidget *widget, gpointer data);
extern void View2DRedoCB(GtkWidget *widget, gpointer data);
extern void View2DJumpToVertexCB(GtkWidget *widget, gpointer data);
extern void View2DSetToCursorCB(GtkWidget *widget, gpointer data);
extern void View2DSetBGImageCB(GtkWidget *widget, gpointer data);
extern void View2DClearBGImageCB(GtkWidget *widget, gpointer data);

extern void View2DTranslateCB(vma_view2d_struct *v);
extern void View2DZoomCB(vma_view2d_struct *v);
extern void View2DGridCB(vma_view2d_struct *v);
extern void View2DSelectRectangleCB(vma_view2d_struct *v, gbool report_event);
extern void View2DSetCursorCB(
        vma_view2d_struct *v, gbool report_event,
        gbool is_initial, gbool is_final
);
extern void View2DSetVertexCB(
	vma_view2d_struct *v, gint view_type, gbool report_event,
	gbool is_initial, gbool is_final
);

extern void View2DTranslateToW(vma_view2d_struct *v, gint wi, gint wj);
extern void View2DZoomToW(vma_view2d_struct *v, gint wi, gint wj);


extern void View3DMoveTurnCB(vma_view3d_struct *v);
extern void View3DMoveStrafeCB(vma_view3d_struct *v);
extern void View3DTurnCB(vma_view3d_struct *v);
extern void View3DMoveVerticalCB(vma_view3d_struct *v);
extern void View3DGridCB(vma_view3d_struct *v);
extern void View3DMoveRateCB(vma_view3d_struct *v);

extern void View3DMoveTurnToW(vma_view3d_struct *v, gint wi, gint wj);
extern void View3DMoveStrafeToW(vma_view3d_struct *v, gint wi, gint wj);
extern void View3DTurnToW(vma_view3d_struct *v, gint wi, gint wj);
extern void View3DMoveVerticalToW(vma_view3d_struct *v, gint wi, gint wj);


extern void View2DMaximizeCB(GtkWidget *widget, gpointer data);
extern void View2DRestoreCB(GtkWidget *widget, gpointer data);
extern void View2DMaximizeRestoreMCB(GtkWidget *widget, gpointer data);

extern void View3DMaximizeCB(GtkWidget *widget, gpointer data);
extern void View3DRestoreCB(GtkWidget *widget, gpointer data);
extern void View3DMaximizeRestoreMCB(GtkWidget *widget, gpointer data);

extern void View3DUndoCB(GtkWidget *widget, gpointer data);
extern void View3DRedoCB(GtkWidget *widget, gpointer data);
extern void View3DRenderActualToggleCB(GtkWidget *widget, gpointer data);
extern void View3DCullToggleCB(GtkWidget *widget, gpointer data);
extern void View3DTranslationsToggleCB(GtkWidget *widget, gpointer data);
extern void View3DEnableAlphaChannelToggleCB(GtkWidget *widget, gpointer data);
extern void View3DSetBGImageCB(GtkWidget *widget, gpointer data);
extern void View3DClearBGImageCB(GtkWidget *widget, gpointer data);

extern void View3DCameraPropertiesMapCB(GtkWidget *widget, gpointer data);
extern void View3DCameraPropertiesOKCB(void *idialog, void *data);
extern void View3DCameraPropertiesApplyCB(void *idialog, void *data);
extern void View3DCameraPropertiesCancelCB(void *idialog, void *data);


#endif	/* VIEWCB_H */
