/*******************************************************************************
*                                                                              *
*                                   Viewmol                                    *
*                                                                              *
*                            R E A D F R A M E . C                             *
*                                                                              *
*                 Copyright (c) Joerg-R. Hill, December 2000                   *
*                                                                              *
********************************************************************************
*
* $Id: readframe.c,v 1.4 2000/12/10 15:15:02 jrh Exp $
* $Log: readframe.c,v $
* Revision 1.4  2000/12/10 15:15:02  jrh
* Release 2.3
*
* Revision 1.3  1999/05/24 01:27:10  jrh
* Release 2.2.1
*
* Revision 1.2  1999/02/07 21:55:39  jrh
* Release 2.2
*
* Revision 1.1  1998/01/26 00:35:17  jrh
* Initial revision
*
*/
#include<ctype.h>
#include<stdio.h>
#include<stdlib.h>
#include<string.h>

#define MAXLENLINE 82
#define FALSE 0
#define TRUE  1

int readFrame(FILE *mainfile, int pbc, int first, double conv, int version)
{
  double energy;
  static int cycle=0;
  int realEnd=FALSE, na=0;
  char line[MAXLENLINE], *word, *w;

  fgets(line, MAXLENLINE, mainfile);
  if (first)
  {
    printf("$title\n");
    word=&line[0];
    while (*word == ' ') word++;
    printf("%s", word);
    fgets(line, MAXLENLINE, mainfile);
  }
  else
  {
    word=line+64;
    energy=atof(word);
    cycle++;
    printf("  cycle = %d    SCF energy = %17.10f   |dE/dxyz| =  0.000000\n", cycle, energy);
  }
  if (pbc)
  {
    fgets(line, MAXLENLINE, mainfile);
    if (first)
      printf("$unitcell %s\n", strtok(line, "(")+3);
    else
      printf("  unitcell %s\n", strtok(line, "(")+3);
  }
  if (first)
  {
    printf("$coord %12.8f\n", conv);
    conv=(double)1.0/conv;
  }
  while (fgets(line, MAXLENLINE, mainfile) != NULL)
  {
    if (strstr(line, "end") == NULL)
    {
      word=strtok(line+6, " \t");
      printf("%22.14f ", conv*atof(word));
      if (strlen(word) > 15)
      {
        if ((w=strchr(word, '.')) != NULL) word=w+10;
        else word+=16;
      }
      else
        word=strtok(NULL, " \t");
      printf("%22.14f ", conv*atof(word));
      if (strlen(word) > 15)
      {

        if ((w=strchr(word, '.')) != NULL) word=w+10;
        else word+=16;
      }
      else
        word=strtok(NULL, " \t");
      printf("%22.14f ", conv*atof(word));    
      word=strtok(NULL, " \t");
      word=strtok(NULL, " \t");
      word=strtok(NULL, " \t");
	if (version < 2)
        printf("%s\n", word);
	else
	{
        word=strtok(NULL, " \t");
        printf("%s\n", word);
	}
      if (realEnd) realEnd=FALSE;
      na++;
    }
    else
    {
      if (realEnd)
      {
        if (!first)
        {
          while (na--) printf("%22.14e%22.14e%22.14e\n", 0.0, 0.0, 0.0);
        }
        if (fgets(line, MAXLENLINE, mainfile) != NULL)
          return(TRUE);
        else
          return(FALSE);
      }
      else
        realEnd=TRUE;
    }
  }
  return(TRUE);
}
