MODULE VOMenuPrefs;

(*
    Copyright (C) 1999  Tim Teulings (rael@edge.ping.de)

    This module is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.

    This module is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with VisualOberon. If not, write to the Free Software Foundation,
    59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

IMPORT B   := VOButton,
       BG  := VOBackground,
       F   := VOFrame,
       FG  := VOFrameGroup,
       FSD := VOFrmSelDlg,
       G   := VOGUIObject,
       L   := VOLabel,
       M   := VOMenu,
       O   := VOObject,
       PG  := VOPrefsGUI,
       PP  := VOPrefsParser;

TYPE
  Item*     = POINTER TO ItemDesc;
  ItemDesc* = RECORD (PG.PrefsItemDesc)
                prefs        : M.PrefsDesc;
                mnuFrmSelDlg,
                stpFrmSelDlg : FSD.FrmSelDlg;
                menuFrame,
                stripFrame   : F.Frame;
              END;

VAR
  prefs : Item;

  PROCEDURE (d : Item) Init*;

  BEGIN
    d.Init^;
    d.name:="Menu";
    PG.settings.AddItem(d);

    NEW(d.mnuFrmSelDlg);
    d.mnuFrmSelDlg.Init;
    NEW(d.stpFrmSelDlg);
    d.stpFrmSelDlg.Init;
  END Init;

  PROCEDURE (d : Item) Refresh*;

  BEGIN
    d.prefs:=M.prefs^;

    d.menuFrame.SetInternalFrame(d.prefs.menuFrame);
    d.mnuFrmSelDlg.SetFrame(d.prefs.menuFrame);
    d.stripFrame.SetInternalFrame(d.prefs.stripFrame);
    d.stpFrmSelDlg.SetFrame(d.prefs.stripFrame);
  END Refresh;

  PROCEDURE (d : Item) GetObject*():G.Object;

  VAR
    button    : B.Button;
    frame     : FG.FrameGroup;
    label     : L.Label;

  BEGIN
    d.mnuFrmSelDlg.SetDisplay(d.display);
    d.mnuFrmSelDlg.Forward(FSD.setMsg,d);
    d.stpFrmSelDlg.SetDisplay(d.display);
    d.stpFrmSelDlg.Forward(FSD.setMsg,d);

    NEW(frame);
    frame.Init;
    frame.SetTextLabel("Frames");

      NEW(label);
      label.Init;

        button:=PG.CreateFrameButton(d.prefs.menuFrame,d.menuFrame,d.display,d.mnuFrmSelDlg,
                                     d.window.keyHandler,"Select menu frame");
      label.AddTextLabel("Menu",button);

        button:=PG.CreateFrameButton(d.prefs.stripFrame,d.stripFrame,d.display,d.stpFrmSelDlg,
                                     d.window.keyHandler,"Select menustrip frame");
      label.AddTextLabel("Menustrip",button);
    frame.Add(label);

    RETURN frame;
  END GetObject;

  PROCEDURE (p : Item) LoadPrefs*(appName : ARRAY OF CHAR);

  VAR
    buffer   : ARRAY 256 OF CHAR;
    pos      : LONGINT;
    top      : PP.Item;


  BEGIN
    p.LoadPrefs^(appName);

    top:=p.LoadPrefsFile("Menu",appName);
    IF top=NIL THEN
      RETURN;
    END;
    top:=top.GetEntry("MENU");
    IF top=NIL THEN
      RETURN;
    END;

    IF top.GetStringEntry("menuFrame",buffer) THEN
      pos:=F.GetFrameEntry(buffer);
      IF pos>=0 THEN
        M.prefs.menuFrame:=pos;
      ELSE
        p.ErrorWrongData("MENU/menuFrame",buffer);
      END;
    END;

    IF top.GetStringEntry("stripFrame",buffer) THEN
      pos:=F.GetFrameEntry(buffer);
      IF pos>=0 THEN
        M.prefs.stripFrame:=pos;
      ELSE
        p.ErrorWrongData("MENU/stripFrame",buffer);
      END;
    END;

    M.prefs.background:=BG.LoadBackground(top);
  END LoadPrefs;

  PROCEDURE (p : Item) Apply*;

  BEGIN
    M.prefs^:=p.prefs;
  END Apply;

  PROCEDURE (p : Item) Save*;

  VAR
    block    : PP.BlockItem;
    value    : PP.ValueItem;

  BEGIN
    NEW(block);
    block.Init;
    block.SetName("MENU");
      NEW(value);
      value.Init;
      value.SetValue("menuFrame",F.internalFrames[p.prefs.menuFrame]);
    block.AddItem(value);

      NEW(value);
      value.Init;
      value.SetValue("stripFrame",F.internalFrames[p.prefs.stripFrame]);
    block.AddItem(value);

    BG.SaveBackground(block,p.prefs.background);

    p.SaveItems("Menu",block);
  END Save;

  PROCEDURE (p : Item) Receive*(message : O.Message);

  BEGIN
    WITH
      message : FSD.SetMsg DO
        IF message.source=p.mnuFrmSelDlg THEN
          p.menuFrame.SetInternalFrame(message.frame);
          p.prefs.menuFrame:=message.frame;
        ELSIF message.source=p.stpFrmSelDlg THEN
          p.stripFrame.SetInternalFrame(message.frame);
          p.prefs.stripFrame:=message.frame;
        END;
    ELSE
      p.Receive^(message);
    END;
  END Receive;

BEGIN
  NEW(prefs);
  prefs.Init;

END VOMenuPrefs.