/*
 * Video tool
 *
 * Philippe Dax
 * Nov 1997
 */

#ifndef VRENGD

#include "global.h"
#include "video.h"

#include "channel.h"	/* getvrgroup */


/* global variable */
int videotool = VIC_TOOL;

static int videopid = -1;


static
char * getvideomc(const char *mc)
{
  u_int16 port;
  char group[GROUP_LEN];
  static char videomc[CHAN_LEN];

  port = getvrport(mc);
  port += 4;
  if (port % 1)
    port++; /* even port for RTP */
  strncpy(group, getvrgroup(mc), sizeof(group));
  strncpy(videomc, createmc(group, port, getCurrentTtl()), sizeof(videomc));
  trace(DBG_TOOL, "videomc=%s", videomc);
  return(videomc);
}

void startvideo(const char *mc)
{
  char videomc[CHAN_LEN];

  strncpy(videomc, getvideomc(mc), sizeof(videomc));

#if defined(WIN32) && !defined(CYGWIN32) /* _spawn */
  videopid = _spawnlp(_P_NOWAIT, "vic", "vic", "-A", "rtp", "-B", "20", "-D",
                     VIDEODEVICE, "-f", "h261", "-C", "VREng-vic", videomc,
                     (char *) NULL);
#else /* WIN32 */
  switch (videopid = fork()) {
  case -1:
    trace(DBG_TOOL, "can't fork for video");
    break;
  case 0:
    execlp("vic", "vic", "-A", "rtp", "-B", "20", "-D", VIDEODEVICE,
         "-f", "h261", "-C", "VREng-vic", videomc, (char *) NULL);
    trace(DBG_TOOL, "can't exec vic");
    exit(1);
  default:
    break;
  }
#endif /* WIN32 */
}

void quitvideo(void)
{
#ifndef WIN32
  if (videopid > 0)
    kill(videopid, SIGKILL);
#endif /* !WIN32 */
}

#endif /* !VRENGD */
