#ifndef VNCCLIENT_H
#define VNCCLIENT_H

#include "rfbproto.h"

/*
   class VNCRGB
   this is what our framebuffer is made of
   24 bits per pixel
   8bits for Red, 8 for Green, 8 for Blue
*/

class VNCRGB {

 public:

  VNCRGB();
  // this constructor is only used to handle faster 32bits pixels we get from the server
  VNCRGB(const CARD32 &pixel);
  VNCRGB(CARD8 red, CARD8 green, CARD8 blue);
  
  CARD8 Red;
  CARD8 Green;
  CARD8 Blue;
};

/*
  class VNCClient
  object will be used in VReng:
  - to connect to the VNC server
  - to handle its messages
  - to forward pointer and keyboard events to the server
  FrameBuffer is public
*/

class VNCClient {
 
 private:

  // this buffer is used to get Server MSGs
  static const unsigned int BUFFER_SIZE = 640*480;
  char buffer[BUFFER_SIZE];

  // do we want to forward events? (no if true)
  bool ViewOnly;
  
  // handling Rectangles we got from server
  void FillRect(int rx, int ry, int rw, int rh, VNCRGB pixel);
  CARD8 RescalePixValue(CARD32 Pix, CARD8 Shift, CARD16 Max);
  VNCRGB CardToVNCRGB(CARD32 Pixel);

  bool HandleRAW8(int rx, int ry, int rw, int rh);
  bool HandleRAW16(int rx, int ry, int rw, int rh);
  bool HandleRAW32(int rx, int ry, int rw, int rh);
  bool HandleCR(int srcx, int srcy, int rx, int ry, int rw, int rh);
  bool HandleRRE8(int rx, int ry, int rw, int rh);
  bool HandleRRE16(int rx, int ry, int rw, int rh);
  bool HandleRRE32(int rx, int ry, int rw, int rh);
  bool HandleCoRRE8(int rx, int ry, int rw, int rh);
  bool HandleCoRRE16(int rx, int ry, int rw, int rh);
  bool HandleCoRRE32(int rx, int ry, int rw, int rh);
  bool HandleHextile8(int rx, int ry, int rw, int rh);
  bool HandleHextile16(int rx, int ry, int rw, int rh);
  bool HandleHextile32(int rx, int ry, int rw, int rh);

 protected:
  
  // the VNCRFBproto object implements all we need to to send and receive
  // messages specified in the RFB protocol
  VNCRFBproto RFB_proto;

 public:

  // for now, public attributes we keep to handle server cut texts
  char *serverCutText;
  bool newServerCutText;

  // here is our FrameBuffer
  VNCRGB *FrameBuffer;
  CARD16 framebufferWidth;
  CARD16 framebufferHeight;

  // constructor
  VNCClient(char *server, int port, char *passFile);

  // we might want to get the socket descriptor to listen to it
  int getSock();

  // set of functions to initialize the connection
  // VNCInit has to allocate memory for the framebuffer if everything goes fine
  // VNCClose has to free it
  // flag can be BPP8, BPP16 or BPP16 to indicate how many bits per pixel we want
  enum {BPP8, BPP16, BPP32};
  bool VNCInit();
  bool VNCInit(int flag);
  bool VNCClose();

  /* Remote Frame Buffer Protocol v3.3 */
  
  // messages from client to server
  void SendRFBEvent(char **params, Cardinal *num_params) ;
  bool SendIncrementalFramebufferUpdateRequest();
  bool SendFramebufferUpdateRequest(int x, int y, int w, int h, bool incremental);
  
  // handle the messages from the server
  bool HandleRFBServerMessage();
    
};

/*
  class VNCClientTextured
  inherits everything from VNCClient
  the FrameBuffer allocated is bigger than the real VNC server screen size
  and has dimensions that are a power of 2
  needed by OpenGL to map the texture
*/

class VNCClientTextured : public VNCClient {

 public:

  // here we keep what the real server screen size is
  CARD16 realScreenWidth;
  CARD16 realScreenHeight;

  VNCClientTextured(char *server, int port, char *pass);

  bool VNCInit();
  bool VNCInit(int flag);

};

#endif // VNCCLIENT_H
