#ifndef VRENGD

#include "global.h"
#include "net.h"
#include "wobject.h"
#include "wmgt.h"
#include "parse.h"
#include "col.h"
#include "moon.h"

#include "zv.h"		/* parseGeometry */


const WClass Moon::wclass(MOON_TYPE, "Moon", Moon::creator);

static float x0x0y0y0, maxx, maxy, minx, miny;


/* create from a fileline */
void Moon::creator(char *l)
{
  new Moon(l);
}

Moon::Moon(char *l)
{
  l = parseName(l, this);
  l = parsePosition(l, this);
  soh = parseGeometry(l);

  initializeObject(this, MOON_TYPE, VR_MOBILE);
  nature.collision = COL_NEVER;

  move.perm_sec = 1;
  x0x0y0y0 = pos.x*pos.x + pos.y*pos.y;
  maxx = maxy = (float) sqrt((double) x0x0y0y0);
  minx = miny = -maxx;
}

/* system of equations handling permanent motion */
void Moon::changePermanent(float lasting)
{
  float sx, sy, dx, dy;

  if (pos.x >= maxx || pos.y <= miny) {
    trace(DBG_WMGT, "pi/2, 2pi");
    sx = +1; sy = +1;
  }
  else if (pos.y >= maxy || pos.x <= minx) {
    trace(DBG_WMGT, "pi, 3pi/2");
    sx = -1; sy = -1;
  }
  else if ((pos.y >= 0 && pos.x <= 0) || (pos.y <= 0 && pos.x <= 0)) {
    trace(DBG_WMGT, "pi -> 3pi/2, 3pi/2 -> 2pi");
    sx = -1; sy = -1;
  }
  else {
    trace(DBG_WMGT, "pi/2 -> pi, 2pi -> pi/2");
    sx = +1; sy = +1;
  }
  dy = (float) sy * MOON_INCR;
  pos.y += (float) dy;
  dx = (float) sqrt(fabs((double) (x0x0y0y0 - (pos.y)*(pos.y))));
  pos.x = (float) (sx * dx);
  trace(DBG_WMGT, "x=%.1f y=%.1f dx=%.1f dy=%.1f %.0f", pos.x, pos.y, dx, dy, (float) sqrt((double) ((pos.x)*(pos.x) + (pos.y)*(pos.y))));

  updateObjectIn3D(this);
  updateBB(this);
}

void moonInitFuncList(void) { }

#endif /* !VRENGD */
