/*
 * tkIntDecls.h --
 *
 *  This file contains the declarations for all unsupported
 *  functions that are exported by the Tk library.  These
 *  interfaces are not guaranteed to remain the same between
 *  versions.  Use at your own risk.
 *
 * Copyright (c) 1998-1999 by Scriptics Corporation.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * RCS: @(#) $Id: tkIntDecls.h,v 1.2 2006-05-06 19:46:28 barre Exp $
 */

#ifndef _TKINTDECLS
#define _TKINTDECLS

#ifdef BUILD_tk
#undef TCL_STORAGE_CLASS
#define TCL_STORAGE_CLASS DLLEXPORT
#endif

/*
 * WARNING: This file is automatically generated by the tools/genStubs.tcl
 * script.  Any modifications to the function declarations below should be made
 * in the generic/tkInt.decls script.
 */

/* !BEGIN!: Do not edit below this line. */

/*
 * Exported function declarations:
 */

/* 0 */
EXTERN TkWindow *  TkAllocWindow _ANSI_ARGS_((TkDisplay * dispPtr, 
        int screenNum, TkWindow * parentPtr));
/* 1 */
EXTERN void    TkBezierPoints _ANSI_ARGS_((double control[], 
        int numSteps, double * coordPtr));
/* 2 */
EXTERN void    TkBezierScreenPoints _ANSI_ARGS_((Tk_Canvas canvas, 
        double control[], int numSteps, 
        XPoint * xPointPtr));
/* 3 */
EXTERN void    TkBindDeadWindow _ANSI_ARGS_((TkWindow * winPtr));
/* 4 */
EXTERN void    TkBindEventProc _ANSI_ARGS_((TkWindow * winPtr, 
        XEvent * eventPtr));
/* 5 */
EXTERN void    TkBindFree _ANSI_ARGS_((TkMainInfo * mainPtr));
/* 6 */
EXTERN void    TkBindInit _ANSI_ARGS_((TkMainInfo * mainPtr));
/* 7 */
EXTERN void    TkChangeEventWindow _ANSI_ARGS_((XEvent * eventPtr, 
        TkWindow * winPtr));
/* 8 */
EXTERN int    TkClipInit _ANSI_ARGS_((Tcl_Interp * interp, 
        TkDisplay * dispPtr));
/* 9 */
EXTERN void    TkComputeAnchor _ANSI_ARGS_((Tk_Anchor anchor, 
        Tk_Window tkwin, int padX, int padY, 
        int innerWidth, int innerHeight, int * xPtr, 
        int * yPtr));
/* 10 */
EXTERN int    TkCopyAndGlobalEval _ANSI_ARGS_((Tcl_Interp * interp, 
        char * script));
/* 11 */
EXTERN unsigned long  TkCreateBindingProcedure _ANSI_ARGS_((
        Tcl_Interp * interp, 
        Tk_BindingTable bindingTable, 
        ClientData object, CONST char * eventString, 
        TkBindEvalProc * evalProc, 
        TkBindFreeProc * freeProc, 
        ClientData clientData));
/* 12 */
EXTERN TkCursor *  TkCreateCursorFromData _ANSI_ARGS_((Tk_Window tkwin, 
        CONST char * source, CONST char * mask, 
        int width, int height, int xHot, int yHot, 
        XColor fg, XColor bg));
/* 13 */
EXTERN int    TkCreateFrame _ANSI_ARGS_((ClientData clientData, 
        Tcl_Interp * interp, int argc, char ** argv, 
        int toplevel, char * appName));
/* 14 */
EXTERN Tk_Window  TkCreateMainWindow _ANSI_ARGS_((Tcl_Interp * interp, 
        CONST char * screenName, char * baseName));
/* 15 */
EXTERN Time    TkCurrentTime _ANSI_ARGS_((TkDisplay * dispPtr));
/* 16 */
EXTERN void    TkDeleteAllImages _ANSI_ARGS_((TkMainInfo * mainPtr));
/* 17 */
EXTERN void    TkDoConfigureNotify _ANSI_ARGS_((TkWindow * winPtr));
/* 18 */
EXTERN void    TkDrawInsetFocusHighlight _ANSI_ARGS_((
        Tk_Window tkwin, GC gc, int width, 
        Drawable drawable, int padding));
/* 19 */
EXTERN void    TkEventDeadWindow _ANSI_ARGS_((TkWindow * winPtr));
/* 20 */
EXTERN void    TkFillPolygon _ANSI_ARGS_((Tk_Canvas canvas, 
        double * coordPtr, int numPoints, 
        Display * display, Drawable drawable, GC gc, 
        GC outlineGC));
/* 21 */
EXTERN int    TkFindStateNum _ANSI_ARGS_((Tcl_Interp * interp, 
        CONST char * option, 
        CONST TkStateMap * mapPtr, 
        CONST char * strKey));
/* 22 */
EXTERN char *    TkFindStateString _ANSI_ARGS_((
        CONST TkStateMap * mapPtr, int numKey));
/* 23 */
EXTERN void    TkFocusDeadWindow _ANSI_ARGS_((TkWindow * winPtr));
/* 24 */
EXTERN int    TkFocusFilterEvent _ANSI_ARGS_((TkWindow * winPtr, 
        XEvent * eventPtr));
/* 25 */
EXTERN TkWindow *  TkFocusKeyEvent _ANSI_ARGS_((TkWindow * winPtr, 
        XEvent * eventPtr));
/* 26 */
EXTERN void    TkFontPkgInit _ANSI_ARGS_((TkMainInfo * mainPtr));
/* 27 */
EXTERN void    TkFontPkgFree _ANSI_ARGS_((TkMainInfo * mainPtr));
/* 28 */
EXTERN void    TkFreeBindingTags _ANSI_ARGS_((TkWindow * winPtr));
/* 29 */
EXTERN void    TkpFreeCursor _ANSI_ARGS_((TkCursor * cursorPtr));
/* 30 */
EXTERN char *    TkGetBitmapData _ANSI_ARGS_((Tcl_Interp * interp, 
        char * string, char * fileName, 
        int * widthPtr, int * heightPtr, 
        int * hotXPtr, int * hotYPtr));
/* 31 */
EXTERN void    TkGetButtPoints _ANSI_ARGS_((double p1[], 
        double p2[], double width, int project, 
        double m1[], double m2[]));
/* 32 */
EXTERN TkCursor *  TkGetCursorByName _ANSI_ARGS_((Tcl_Interp * interp, 
        Tk_Window tkwin, Tk_Uid string));
/* 33 */
EXTERN CONST84_RETURN char * TkGetDefaultScreenName _ANSI_ARGS_((
        Tcl_Interp * interp, CONST char * screenName));
/* 34 */
EXTERN TkDisplay *  TkGetDisplay _ANSI_ARGS_((Display * display));
/* 35 */
EXTERN int    TkGetDisplayOf _ANSI_ARGS_((Tcl_Interp * interp, 
        int objc, Tcl_Obj *CONST objv[], 
        Tk_Window * tkwinPtr));
/* 36 */
EXTERN TkWindow *  TkGetFocusWin _ANSI_ARGS_((TkWindow * winPtr));
/* 37 */
EXTERN int    TkGetInterpNames _ANSI_ARGS_((Tcl_Interp * interp, 
        Tk_Window tkwin));
/* 38 */
EXTERN int    TkGetMiterPoints _ANSI_ARGS_((double p1[], 
        double p2[], double p3[], double width, 
        double m1[], double m2[]));
/* 39 */
EXTERN void    TkGetPointerCoords _ANSI_ARGS_((Tk_Window tkwin, 
        int * xPtr, int * yPtr));
/* 40 */
EXTERN void    TkGetServerInfo _ANSI_ARGS_((Tcl_Interp * interp, 
        Tk_Window tkwin));
/* 41 */
EXTERN void    TkGrabDeadWindow _ANSI_ARGS_((TkWindow * winPtr));
/* 42 */
EXTERN int    TkGrabState _ANSI_ARGS_((TkWindow * winPtr));
/* 43 */
EXTERN void    TkIncludePoint _ANSI_ARGS_((Tk_Item * itemPtr, 
        double * pointPtr));
/* 44 */
EXTERN void    TkInOutEvents _ANSI_ARGS_((XEvent * eventPtr, 
        TkWindow * sourcePtr, TkWindow * destPtr, 
        int leaveType, int enterType, 
        Tcl_QueuePosition position));
/* 45 */
EXTERN void    TkInstallFrameMenu _ANSI_ARGS_((Tk_Window tkwin));
/* 46 */
EXTERN char *    TkKeysymToString _ANSI_ARGS_((KeySym keysym));
/* 47 */
EXTERN int    TkLineToArea _ANSI_ARGS_((double end1Ptr[], 
        double end2Ptr[], double rectPtr[]));
/* 48 */
EXTERN double    TkLineToPoint _ANSI_ARGS_((double end1Ptr[], 
        double end2Ptr[], double pointPtr[]));
/* 49 */
EXTERN int    TkMakeBezierCurve _ANSI_ARGS_((Tk_Canvas canvas, 
        double * pointPtr, int numPoints, 
        int numSteps, XPoint xPoints[], 
        double dblPoints[]));
/* 50 */
EXTERN void    TkMakeBezierPostscript _ANSI_ARGS_((
        Tcl_Interp * interp, Tk_Canvas canvas, 
        double * pointPtr, int numPoints));
/* 51 */
EXTERN void    TkOptionClassChanged _ANSI_ARGS_((TkWindow * winPtr));
/* 52 */
EXTERN void    TkOptionDeadWindow _ANSI_ARGS_((TkWindow * winPtr));
/* 53 */
EXTERN int    TkOvalToArea _ANSI_ARGS_((double * ovalPtr, 
        double * rectPtr));
/* 54 */
EXTERN double    TkOvalToPoint _ANSI_ARGS_((double ovalPtr[], 
        double width, int filled, double pointPtr[]));
/* 55 */
EXTERN int    TkpChangeFocus _ANSI_ARGS_((TkWindow * winPtr, 
        int force));
/* 56 */
EXTERN void    TkpCloseDisplay _ANSI_ARGS_((TkDisplay * dispPtr));
/* 57 */
EXTERN void    TkpClaimFocus _ANSI_ARGS_((TkWindow * topLevelPtr, 
        int force));
/* 58 */
EXTERN void    TkpDisplayWarning _ANSI_ARGS_((CONST char * msg, 
        CONST char * title));
/* 59 */
EXTERN void    TkpGetAppName _ANSI_ARGS_((Tcl_Interp * interp, 
        Tcl_DString * name));
/* 60 */
EXTERN TkWindow *  TkpGetOtherWindow _ANSI_ARGS_((TkWindow * winPtr));
/* 61 */
EXTERN TkWindow *  TkpGetWrapperWindow _ANSI_ARGS_((TkWindow * winPtr));
/* 62 */
EXTERN int    TkpInit _ANSI_ARGS_((Tcl_Interp * interp));
/* 63 */
EXTERN void    TkpInitializeMenuBindings _ANSI_ARGS_((
        Tcl_Interp * interp, 
        Tk_BindingTable bindingTable));
/* 64 */
EXTERN void    TkpMakeContainer _ANSI_ARGS_((Tk_Window tkwin));
/* 65 */
EXTERN void    TkpMakeMenuWindow _ANSI_ARGS_((Tk_Window tkwin, 
        int transient));
/* 66 */
EXTERN Window    TkpMakeWindow _ANSI_ARGS_((TkWindow * winPtr, 
        Window parent));
/* 67 */
EXTERN void    TkpMenuNotifyToplevelCreate _ANSI_ARGS_((
        Tcl_Interp * interp1, char * menuName));
/* 68 */
EXTERN TkDisplay *  TkpOpenDisplay _ANSI_ARGS_((
        CONST char * display_name));
/* 69 */
EXTERN int    TkPointerEvent _ANSI_ARGS_((XEvent * eventPtr, 
        TkWindow * winPtr));
/* 70 */
EXTERN int    TkPolygonToArea _ANSI_ARGS_((double * polyPtr, 
        int numPoints, double * rectPtr));
/* 71 */
EXTERN double    TkPolygonToPoint _ANSI_ARGS_((double * polyPtr, 
        int numPoints, double * pointPtr));
/* 72 */
EXTERN int    TkPositionInTree _ANSI_ARGS_((TkWindow * winPtr, 
        TkWindow * treePtr));
/* 73 */
EXTERN void    TkpRedirectKeyEvent _ANSI_ARGS_((TkWindow * winPtr, 
        XEvent * eventPtr));
/* 74 */
EXTERN void    TkpSetMainMenubar _ANSI_ARGS_((Tcl_Interp * interp, 
        Tk_Window tkwin, char * menuName));
/* 75 */
EXTERN int    TkpUseWindow _ANSI_ARGS_((Tcl_Interp * interp, 
        Tk_Window tkwin, CONST char * string));
/* 76 */
EXTERN int    TkpWindowWasRecentlyDeleted _ANSI_ARGS_((Window win, 
        TkDisplay * dispPtr));
/* 77 */
EXTERN void    TkQueueEventForAllChildren _ANSI_ARGS_((
        TkWindow * winPtr, XEvent * eventPtr));
/* 78 */
EXTERN int    TkReadBitmapFile _ANSI_ARGS_((Display* display, 
        Drawable d, CONST char* filename, 
        unsigned int* width_return, 
        unsigned int* height_return, 
        Pixmap* bitmap_return, int* x_hot_return, 
        int* y_hot_return));
/* 79 */
EXTERN int    TkScrollWindow _ANSI_ARGS_((Tk_Window tkwin, GC gc, 
        int x, int y, int width, int height, int dx, 
        int dy, TkRegion damageRgn));
/* 80 */
EXTERN void    TkSelDeadWindow _ANSI_ARGS_((TkWindow * winPtr));
/* 81 */
EXTERN void    TkSelEventProc _ANSI_ARGS_((Tk_Window tkwin, 
        XEvent * eventPtr));
/* 82 */
EXTERN void    TkSelInit _ANSI_ARGS_((Tk_Window tkwin));
/* 83 */
EXTERN void    TkSelPropProc _ANSI_ARGS_((XEvent * eventPtr));
/* Slot 84 is reserved */
/* 85 */
EXTERN void    TkSetWindowMenuBar _ANSI_ARGS_((Tcl_Interp * interp, 
        Tk_Window tkwin, char * oldMenuName, 
        char * menuName));
/* 86 */
EXTERN KeySym    TkStringToKeysym _ANSI_ARGS_((char * name));
/* 87 */
EXTERN int    TkThickPolyLineToArea _ANSI_ARGS_((double * coordPtr, 
        int numPoints, double width, int capStyle, 
        int joinStyle, double * rectPtr));
/* 88 */
EXTERN void    TkWmAddToColormapWindows _ANSI_ARGS_((
        TkWindow * winPtr));
/* 89 */
EXTERN void    TkWmDeadWindow _ANSI_ARGS_((TkWindow * winPtr));
/* 90 */
EXTERN TkWindow *  TkWmFocusToplevel _ANSI_ARGS_((TkWindow * winPtr));
/* 91 */
EXTERN void    TkWmMapWindow _ANSI_ARGS_((TkWindow * winPtr));
/* 92 */
EXTERN void    TkWmNewWindow _ANSI_ARGS_((TkWindow * winPtr));
/* 93 */
EXTERN void    TkWmProtocolEventProc _ANSI_ARGS_((TkWindow * winPtr, 
        XEvent * evenvPtr));
/* 94 */
EXTERN void    TkWmRemoveFromColormapWindows _ANSI_ARGS_((
        TkWindow * winPtr));
/* 95 */
EXTERN void    TkWmRestackToplevel _ANSI_ARGS_((TkWindow * winPtr, 
        int aboveBelow, TkWindow * otherPtr));
/* 96 */
EXTERN void    TkWmSetClass _ANSI_ARGS_((TkWindow * winPtr));
/* 97 */
EXTERN void    TkWmUnmapWindow _ANSI_ARGS_((TkWindow * winPtr));
/* 98 */
EXTERN Tcl_Obj *  TkDebugBitmap _ANSI_ARGS_((Tk_Window tkwin, 
        char * name));
/* 99 */
EXTERN Tcl_Obj *  TkDebugBorder _ANSI_ARGS_((Tk_Window tkwin, 
        char * name));
/* 100 */
EXTERN Tcl_Obj *  TkDebugCursor _ANSI_ARGS_((Tk_Window tkwin, 
        char * name));
/* 101 */
EXTERN Tcl_Obj *  TkDebugColor _ANSI_ARGS_((Tk_Window tkwin, 
        char * name));
/* 102 */
EXTERN Tcl_Obj *  TkDebugConfig _ANSI_ARGS_((Tcl_Interp * interp, 
        Tk_OptionTable table));
/* 103 */
EXTERN Tcl_Obj *  TkDebugFont _ANSI_ARGS_((Tk_Window tkwin, 
        char * name));
/* 104 */
EXTERN int    TkFindStateNumObj _ANSI_ARGS_((Tcl_Interp * interp, 
        Tcl_Obj * optionPtr, 
        CONST TkStateMap * mapPtr, Tcl_Obj * keyPtr));
/* 105 */
EXTERN Tcl_HashTable *  TkGetBitmapPredefTable _ANSI_ARGS_((void));
/* 106 */
EXTERN TkDisplay *  TkGetDisplayList _ANSI_ARGS_((void));
/* 107 */
EXTERN TkMainInfo *  TkGetMainInfoList _ANSI_ARGS_((void));
/* 108 */
EXTERN int    TkGetWindowFromObj _ANSI_ARGS_((Tcl_Interp * interp, 
        Tk_Window tkwin, Tcl_Obj * objPtr, 
        Tk_Window * windowPtr));
/* 109 */
EXTERN char *    TkpGetString _ANSI_ARGS_((TkWindow * winPtr, 
        XEvent * eventPtr, Tcl_DString * dsPtr));
/* 110 */
EXTERN void    TkpGetSubFonts _ANSI_ARGS_((Tcl_Interp * interp, 
        Tk_Font tkfont));
/* 111 */
EXTERN Tcl_Obj *  TkpGetSystemDefault _ANSI_ARGS_((Tk_Window tkwin, 
        CONST char * dbName, CONST char * className));
/* 112 */
EXTERN void    TkpMenuThreadInit _ANSI_ARGS_((void));
#ifdef __WIN32__
/* 113 */
EXTERN void    TkClipBox _ANSI_ARGS_((TkRegion rgn, 
        XRectangle* rect_return));
#endif /* __WIN32__ */
#ifdef MAC_TCL
/* 113 */
EXTERN void    TkClipBox _ANSI_ARGS_((TkRegion rgn, 
        XRectangle* rect_return));
#endif /* MAC_TCL */
#ifdef MAC_OSX_TK
/* 113 */
EXTERN void    TkClipBox _ANSI_ARGS_((TkRegion rgn, 
        XRectangle* rect_return));
#endif /* MAC_OSX_TK */
#ifdef __WIN32__
/* 114 */
EXTERN TkRegion    TkCreateRegion _ANSI_ARGS_((void));
#endif /* __WIN32__ */
#ifdef MAC_TCL
/* 114 */
EXTERN TkRegion    TkCreateRegion _ANSI_ARGS_((void));
#endif /* MAC_TCL */
#ifdef MAC_OSX_TK
/* 114 */
EXTERN TkRegion    TkCreateRegion _ANSI_ARGS_((void));
#endif /* MAC_OSX_TK */
#ifdef __WIN32__
/* 115 */
EXTERN void    TkDestroyRegion _ANSI_ARGS_((TkRegion rgn));
#endif /* __WIN32__ */
#ifdef MAC_TCL
/* 115 */
EXTERN void    TkDestroyRegion _ANSI_ARGS_((TkRegion rgn));
#endif /* MAC_TCL */
#ifdef MAC_OSX_TK
/* 115 */
EXTERN void    TkDestroyRegion _ANSI_ARGS_((TkRegion rgn));
#endif /* MAC_OSX_TK */
#ifdef __WIN32__
/* 116 */
EXTERN void    TkIntersectRegion _ANSI_ARGS_((TkRegion sra, 
        TkRegion srcb, TkRegion dr_return));
#endif /* __WIN32__ */
#ifdef MAC_TCL
/* 116 */
EXTERN void    TkIntersectRegion _ANSI_ARGS_((TkRegion sra, 
        TkRegion srcb, TkRegion dr_return));
#endif /* MAC_TCL */
#ifdef MAC_OSX_TK
/* 116 */
EXTERN void    TkIntersectRegion _ANSI_ARGS_((TkRegion sra, 
        TkRegion srcb, TkRegion dr_return));
#endif /* MAC_OSX_TK */
#ifdef __WIN32__
/* 117 */
EXTERN int    TkRectInRegion _ANSI_ARGS_((TkRegion rgn, int x, 
        int y, unsigned int width, 
        unsigned int height));
#endif /* __WIN32__ */
#ifdef MAC_TCL
/* 117 */
EXTERN int    TkRectInRegion _ANSI_ARGS_((TkRegion rgn, int x, 
        int y, unsigned int width, 
        unsigned int height));
#endif /* MAC_TCL */
#ifdef MAC_OSX_TK
/* 117 */
EXTERN int    TkRectInRegion _ANSI_ARGS_((TkRegion rgn, int x, 
        int y, unsigned int width, 
        unsigned int height));
#endif /* MAC_OSX_TK */
#ifdef __WIN32__
/* 118 */
EXTERN void    TkSetRegion _ANSI_ARGS_((Display* display, GC gc, 
        TkRegion rgn));
#endif /* __WIN32__ */
#ifdef MAC_TCL
/* 118 */
EXTERN void    TkSetRegion _ANSI_ARGS_((Display* display, GC gc, 
        TkRegion rgn));
#endif /* MAC_TCL */
#ifdef MAC_OSX_TK
/* 118 */
EXTERN void    TkSetRegion _ANSI_ARGS_((Display* display, GC gc, 
        TkRegion rgn));
#endif /* MAC_OSX_TK */
#ifdef __WIN32__
/* 119 */
EXTERN void    TkUnionRectWithRegion _ANSI_ARGS_((XRectangle* rect, 
        TkRegion src, TkRegion dr_return));
#endif /* __WIN32__ */
#ifdef MAC_TCL
/* 119 */
EXTERN void    TkUnionRectWithRegion _ANSI_ARGS_((XRectangle* rect, 
        TkRegion src, TkRegion dr_return));
#endif /* MAC_TCL */
#ifdef MAC_OSX_TK
/* 119 */
EXTERN void    TkUnionRectWithRegion _ANSI_ARGS_((XRectangle* rect, 
        TkRegion src, TkRegion dr_return));
#endif /* MAC_OSX_TK */
/* Slot 120 is reserved */
#ifdef MAC_TCL
/* 121 */
EXTERN Pixmap    TkpCreateNativeBitmap _ANSI_ARGS_((Display * display, 
        CONST char * source));
#endif /* MAC_TCL */
#ifdef MAC_OSX_TK
/* 121 */
EXTERN Pixmap    TkpCreateNativeBitmap _ANSI_ARGS_((Display * display, 
        CONST char * source));
#endif /* MAC_OSX_TK */
#ifdef MAC_TCL
/* 122 */
EXTERN void    TkpDefineNativeBitmaps _ANSI_ARGS_((void));
#endif /* MAC_TCL */
#ifdef MAC_OSX_TK
/* 122 */
EXTERN void    TkpDefineNativeBitmaps _ANSI_ARGS_((void));
#endif /* MAC_OSX_TK */
/* Slot 123 is reserved */
#ifdef MAC_TCL
/* 124 */
EXTERN Pixmap    TkpGetNativeAppBitmap _ANSI_ARGS_((Display * display, 
        CONST char * name, int * width, int * height));
#endif /* MAC_TCL */
#ifdef MAC_OSX_TK
/* 124 */
EXTERN Pixmap    TkpGetNativeAppBitmap _ANSI_ARGS_((Display * display, 
        CONST char * name, int * width, int * height));
#endif /* MAC_OSX_TK */
/* Slot 125 is reserved */
/* Slot 126 is reserved */
/* Slot 127 is reserved */
/* Slot 128 is reserved */
/* Slot 129 is reserved */
/* Slot 130 is reserved */
/* Slot 131 is reserved */
/* Slot 132 is reserved */
/* Slot 133 is reserved */
/* Slot 134 is reserved */
/* 135 */
EXTERN void    TkpDrawHighlightBorder _ANSI_ARGS_((Tk_Window tkwin, 
        GC fgGC, GC bgGC, int highlightWidth, 
        Drawable drawable));
/* 136 */
EXTERN void    TkSetFocusWin _ANSI_ARGS_((TkWindow * winPtr, 
        int force));
/* 137 */
EXTERN void    TkpSetKeycodeAndState _ANSI_ARGS_((Tk_Window tkwin, 
        KeySym keySym, XEvent * eventPtr));
/* 138 */
EXTERN KeySym    TkpGetKeySym _ANSI_ARGS_((TkDisplay * dispPtr, 
        XEvent * eventPtr));
/* 139 */
EXTERN void    TkpInitKeymapInfo _ANSI_ARGS_((TkDisplay * dispPtr));
/* 140 */
EXTERN TkRegion    TkPhotoGetValidRegion _ANSI_ARGS_((
        Tk_PhotoHandle handle));
/* 141 */
EXTERN TkWindow **  TkWmStackorderToplevel _ANSI_ARGS_((
        TkWindow * parentPtr));
/* 142 */
EXTERN void    TkFocusFree _ANSI_ARGS_((TkMainInfo * mainPtr));
/* 143 */
EXTERN void    TkClipCleanup _ANSI_ARGS_((TkDisplay * dispPtr));
/* 144 */
EXTERN void    TkGCCleanup _ANSI_ARGS_((TkDisplay * dispPtr));
#ifdef __WIN32__
/* 145 */
EXTERN void    TkSubtractRegion _ANSI_ARGS_((TkRegion sra, 
        TkRegion srcb, TkRegion dr_return));
#endif /* __WIN32__ */
#ifdef MAC_TCL
/* 145 */
EXTERN void    TkSubtractRegion _ANSI_ARGS_((TkRegion sra, 
        TkRegion srcb, TkRegion dr_return));
#endif /* MAC_TCL */
#ifdef MAC_OSX_TK
/* 145 */
EXTERN void    TkSubtractRegion _ANSI_ARGS_((TkRegion sra, 
        TkRegion srcb, TkRegion dr_return));
#endif /* MAC_OSX_TK */
/* 146 */
EXTERN void    TkStylePkgInit _ANSI_ARGS_((TkMainInfo * mainPtr));
/* 147 */
EXTERN void    TkStylePkgFree _ANSI_ARGS_((TkMainInfo * mainPtr));
/* 148 */
EXTERN Tk_Window  TkToplevelWindowForCommand _ANSI_ARGS_((
        Tcl_Interp * interp, CONST char * cmdName));
/* 149 */
EXTERN CONST Tk_OptionSpec * TkGetOptionSpec _ANSI_ARGS_((CONST char * name, 
        Tk_OptionTable optionTable));
/* Slot 150 is reserved */
/* Slot 151 is reserved */
/* 152 */
EXTERN void    TkpDrawFrame _ANSI_ARGS_((Tk_Window tkwin, 
        Tk_3DBorder border, int highlightWidth, 
        int borderWidth, int relief));

typedef struct TkIntStubs {
    int magic;
    struct TkIntStubHooks *hooks;

    TkWindow * (*tkAllocWindow) _ANSI_ARGS_((TkDisplay * dispPtr, int screenNum, TkWindow * parentPtr)); /* 0 */
    void (*tkBezierPoints) _ANSI_ARGS_((double control[], int numSteps, double * coordPtr)); /* 1 */
    void (*tkBezierScreenPoints) _ANSI_ARGS_((Tk_Canvas canvas, double control[], int numSteps, XPoint * xPointPtr)); /* 2 */
    void (*tkBindDeadWindow) _ANSI_ARGS_((TkWindow * winPtr)); /* 3 */
    void (*tkBindEventProc) _ANSI_ARGS_((TkWindow * winPtr, XEvent * eventPtr)); /* 4 */
    void (*tkBindFree) _ANSI_ARGS_((TkMainInfo * mainPtr)); /* 5 */
    void (*tkBindInit) _ANSI_ARGS_((TkMainInfo * mainPtr)); /* 6 */
    void (*tkChangeEventWindow) _ANSI_ARGS_((XEvent * eventPtr, TkWindow * winPtr)); /* 7 */
    int (*tkClipInit) _ANSI_ARGS_((Tcl_Interp * interp, TkDisplay * dispPtr)); /* 8 */
    void (*tkComputeAnchor) _ANSI_ARGS_((Tk_Anchor anchor, Tk_Window tkwin, int padX, int padY, int innerWidth, int innerHeight, int * xPtr, int * yPtr)); /* 9 */
    int (*tkCopyAndGlobalEval) _ANSI_ARGS_((Tcl_Interp * interp, char * script)); /* 10 */
    unsigned long (*tkCreateBindingProcedure) _ANSI_ARGS_((Tcl_Interp * interp, Tk_BindingTable bindingTable, ClientData object, CONST char * eventString, TkBindEvalProc * evalProc, TkBindFreeProc * freeProc, ClientData clientData)); /* 11 */
    TkCursor * (*tkCreateCursorFromData) _ANSI_ARGS_((Tk_Window tkwin, CONST char * source, CONST char * mask, int width, int height, int xHot, int yHot, XColor fg, XColor bg)); /* 12 */
    int (*tkCreateFrame) _ANSI_ARGS_((ClientData clientData, Tcl_Interp * interp, int argc, char ** argv, int toplevel, char * appName)); /* 13 */
    Tk_Window (*tkCreateMainWindow) _ANSI_ARGS_((Tcl_Interp * interp, CONST char * screenName, char * baseName)); /* 14 */
    Time (*tkCurrentTime) _ANSI_ARGS_((TkDisplay * dispPtr)); /* 15 */
    void (*tkDeleteAllImages) _ANSI_ARGS_((TkMainInfo * mainPtr)); /* 16 */
    void (*tkDoConfigureNotify) _ANSI_ARGS_((TkWindow * winPtr)); /* 17 */
    void (*tkDrawInsetFocusHighlight) _ANSI_ARGS_((Tk_Window tkwin, GC gc, int width, Drawable drawable, int padding)); /* 18 */
    void (*tkEventDeadWindow) _ANSI_ARGS_((TkWindow * winPtr)); /* 19 */
    void (*tkFillPolygon) _ANSI_ARGS_((Tk_Canvas canvas, double * coordPtr, int numPoints, Display * display, Drawable drawable, GC gc, GC outlineGC)); /* 20 */
    int (*tkFindStateNum) _ANSI_ARGS_((Tcl_Interp * interp, CONST char * option, CONST TkStateMap * mapPtr, CONST char * strKey)); /* 21 */
    char * (*tkFindStateString) _ANSI_ARGS_((CONST TkStateMap * mapPtr, int numKey)); /* 22 */
    void (*tkFocusDeadWindow) _ANSI_ARGS_((TkWindow * winPtr)); /* 23 */
    int (*tkFocusFilterEvent) _ANSI_ARGS_((TkWindow * winPtr, XEvent * eventPtr)); /* 24 */
    TkWindow * (*tkFocusKeyEvent) _ANSI_ARGS_((TkWindow * winPtr, XEvent * eventPtr)); /* 25 */
    void (*tkFontPkgInit) _ANSI_ARGS_((TkMainInfo * mainPtr)); /* 26 */
    void (*tkFontPkgFree) _ANSI_ARGS_((TkMainInfo * mainPtr)); /* 27 */
    void (*tkFreeBindingTags) _ANSI_ARGS_((TkWindow * winPtr)); /* 28 */
    void (*tkpFreeCursor) _ANSI_ARGS_((TkCursor * cursorPtr)); /* 29 */
    char * (*tkGetBitmapData) _ANSI_ARGS_((Tcl_Interp * interp, char * string, char * fileName, int * widthPtr, int * heightPtr, int * hotXPtr, int * hotYPtr)); /* 30 */
    void (*tkGetButtPoints) _ANSI_ARGS_((double p1[], double p2[], double width, int project, double m1[], double m2[])); /* 31 */
    TkCursor * (*tkGetCursorByName) _ANSI_ARGS_((Tcl_Interp * interp, Tk_Window tkwin, Tk_Uid string)); /* 32 */
    CONST84_RETURN char * (*tkGetDefaultScreenName) _ANSI_ARGS_((Tcl_Interp * interp, CONST char * screenName)); /* 33 */
    TkDisplay * (*tkGetDisplay) _ANSI_ARGS_((Display * display)); /* 34 */
    int (*tkGetDisplayOf) _ANSI_ARGS_((Tcl_Interp * interp, int objc, Tcl_Obj *CONST objv[], Tk_Window * tkwinPtr)); /* 35 */
    TkWindow * (*tkGetFocusWin) _ANSI_ARGS_((TkWindow * winPtr)); /* 36 */
    int (*tkGetInterpNames) _ANSI_ARGS_((Tcl_Interp * interp, Tk_Window tkwin)); /* 37 */
    int (*tkGetMiterPoints) _ANSI_ARGS_((double p1[], double p2[], double p3[], double width, double m1[], double m2[])); /* 38 */
    void (*tkGetPointerCoords) _ANSI_ARGS_((Tk_Window tkwin, int * xPtr, int * yPtr)); /* 39 */
    void (*tkGetServerInfo) _ANSI_ARGS_((Tcl_Interp * interp, Tk_Window tkwin)); /* 40 */
    void (*tkGrabDeadWindow) _ANSI_ARGS_((TkWindow * winPtr)); /* 41 */
    int (*tkGrabState) _ANSI_ARGS_((TkWindow * winPtr)); /* 42 */
    void (*tkIncludePoint) _ANSI_ARGS_((Tk_Item * itemPtr, double * pointPtr)); /* 43 */
    void (*tkInOutEvents) _ANSI_ARGS_((XEvent * eventPtr, TkWindow * sourcePtr, TkWindow * destPtr, int leaveType, int enterType, Tcl_QueuePosition position)); /* 44 */
    void (*tkInstallFrameMenu) _ANSI_ARGS_((Tk_Window tkwin)); /* 45 */
    char * (*tkKeysymToString) _ANSI_ARGS_((KeySym keysym)); /* 46 */
    int (*tkLineToArea) _ANSI_ARGS_((double end1Ptr[], double end2Ptr[], double rectPtr[])); /* 47 */
    double (*tkLineToPoint) _ANSI_ARGS_((double end1Ptr[], double end2Ptr[], double pointPtr[])); /* 48 */
    int (*tkMakeBezierCurve) _ANSI_ARGS_((Tk_Canvas canvas, double * pointPtr, int numPoints, int numSteps, XPoint xPoints[], double dblPoints[])); /* 49 */
    void (*tkMakeBezierPostscript) _ANSI_ARGS_((Tcl_Interp * interp, Tk_Canvas canvas, double * pointPtr, int numPoints)); /* 50 */
    void (*tkOptionClassChanged) _ANSI_ARGS_((TkWindow * winPtr)); /* 51 */
    void (*tkOptionDeadWindow) _ANSI_ARGS_((TkWindow * winPtr)); /* 52 */
    int (*tkOvalToArea) _ANSI_ARGS_((double * ovalPtr, double * rectPtr)); /* 53 */
    double (*tkOvalToPoint) _ANSI_ARGS_((double ovalPtr[], double width, int filled, double pointPtr[])); /* 54 */
    int (*tkpChangeFocus) _ANSI_ARGS_((TkWindow * winPtr, int force)); /* 55 */
    void (*tkpCloseDisplay) _ANSI_ARGS_((TkDisplay * dispPtr)); /* 56 */
    void (*tkpClaimFocus) _ANSI_ARGS_((TkWindow * topLevelPtr, int force)); /* 57 */
    void (*tkpDisplayWarning) _ANSI_ARGS_((CONST char * msg, CONST char * title)); /* 58 */
    void (*tkpGetAppName) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_DString * name)); /* 59 */
    TkWindow * (*tkpGetOtherWindow) _ANSI_ARGS_((TkWindow * winPtr)); /* 60 */
    TkWindow * (*tkpGetWrapperWindow) _ANSI_ARGS_((TkWindow * winPtr)); /* 61 */
    int (*tkpInit) _ANSI_ARGS_((Tcl_Interp * interp)); /* 62 */
    void (*tkpInitializeMenuBindings) _ANSI_ARGS_((Tcl_Interp * interp, Tk_BindingTable bindingTable)); /* 63 */
    void (*tkpMakeContainer) _ANSI_ARGS_((Tk_Window tkwin)); /* 64 */
    void (*tkpMakeMenuWindow) _ANSI_ARGS_((Tk_Window tkwin, int transient)); /* 65 */
    Window (*tkpMakeWindow) _ANSI_ARGS_((TkWindow * winPtr, Window parent)); /* 66 */
    void (*tkpMenuNotifyToplevelCreate) _ANSI_ARGS_((Tcl_Interp * interp1, char * menuName)); /* 67 */
    TkDisplay * (*tkpOpenDisplay) _ANSI_ARGS_((CONST char * display_name)); /* 68 */
    int (*tkPointerEvent) _ANSI_ARGS_((XEvent * eventPtr, TkWindow * winPtr)); /* 69 */
    int (*tkPolygonToArea) _ANSI_ARGS_((double * polyPtr, int numPoints, double * rectPtr)); /* 70 */
    double (*tkPolygonToPoint) _ANSI_ARGS_((double * polyPtr, int numPoints, double * pointPtr)); /* 71 */
    int (*tkPositionInTree) _ANSI_ARGS_((TkWindow * winPtr, TkWindow * treePtr)); /* 72 */
    void (*tkpRedirectKeyEvent) _ANSI_ARGS_((TkWindow * winPtr, XEvent * eventPtr)); /* 73 */
    void (*tkpSetMainMenubar) _ANSI_ARGS_((Tcl_Interp * interp, Tk_Window tkwin, char * menuName)); /* 74 */
    int (*tkpUseWindow) _ANSI_ARGS_((Tcl_Interp * interp, Tk_Window tkwin, CONST char * string)); /* 75 */
    int (*tkpWindowWasRecentlyDeleted) _ANSI_ARGS_((Window win, TkDisplay * dispPtr)); /* 76 */
    void (*tkQueueEventForAllChildren) _ANSI_ARGS_((TkWindow * winPtr, XEvent * eventPtr)); /* 77 */
    int (*tkReadBitmapFile) _ANSI_ARGS_((Display* display, Drawable d, CONST char* filename, unsigned int* width_return, unsigned int* height_return, Pixmap* bitmap_return, int* x_hot_return, int* y_hot_return)); /* 78 */
    int (*tkScrollWindow) _ANSI_ARGS_((Tk_Window tkwin, GC gc, int x, int y, int width, int height, int dx, int dy, TkRegion damageRgn)); /* 79 */
    void (*tkSelDeadWindow) _ANSI_ARGS_((TkWindow * winPtr)); /* 80 */
    void (*tkSelEventProc) _ANSI_ARGS_((Tk_Window tkwin, XEvent * eventPtr)); /* 81 */
    void (*tkSelInit) _ANSI_ARGS_((Tk_Window tkwin)); /* 82 */
    void (*tkSelPropProc) _ANSI_ARGS_((XEvent * eventPtr)); /* 83 */
    void *reserved84;
    void (*tkSetWindowMenuBar) _ANSI_ARGS_((Tcl_Interp * interp, Tk_Window tkwin, char * oldMenuName, char * menuName)); /* 85 */
    KeySym (*tkStringToKeysym) _ANSI_ARGS_((char * name)); /* 86 */
    int (*tkThickPolyLineToArea) _ANSI_ARGS_((double * coordPtr, int numPoints, double width, int capStyle, int joinStyle, double * rectPtr)); /* 87 */
    void (*tkWmAddToColormapWindows) _ANSI_ARGS_((TkWindow * winPtr)); /* 88 */
    void (*tkWmDeadWindow) _ANSI_ARGS_((TkWindow * winPtr)); /* 89 */
    TkWindow * (*tkWmFocusToplevel) _ANSI_ARGS_((TkWindow * winPtr)); /* 90 */
    void (*tkWmMapWindow) _ANSI_ARGS_((TkWindow * winPtr)); /* 91 */
    void (*tkWmNewWindow) _ANSI_ARGS_((TkWindow * winPtr)); /* 92 */
    void (*tkWmProtocolEventProc) _ANSI_ARGS_((TkWindow * winPtr, XEvent * evenvPtr)); /* 93 */
    void (*tkWmRemoveFromColormapWindows) _ANSI_ARGS_((TkWindow * winPtr)); /* 94 */
    void (*tkWmRestackToplevel) _ANSI_ARGS_((TkWindow * winPtr, int aboveBelow, TkWindow * otherPtr)); /* 95 */
    void (*tkWmSetClass) _ANSI_ARGS_((TkWindow * winPtr)); /* 96 */
    void (*tkWmUnmapWindow) _ANSI_ARGS_((TkWindow * winPtr)); /* 97 */
    Tcl_Obj * (*tkDebugBitmap) _ANSI_ARGS_((Tk_Window tkwin, char * name)); /* 98 */
    Tcl_Obj * (*tkDebugBorder) _ANSI_ARGS_((Tk_Window tkwin, char * name)); /* 99 */
    Tcl_Obj * (*tkDebugCursor) _ANSI_ARGS_((Tk_Window tkwin, char * name)); /* 100 */
    Tcl_Obj * (*tkDebugColor) _ANSI_ARGS_((Tk_Window tkwin, char * name)); /* 101 */
    Tcl_Obj * (*tkDebugConfig) _ANSI_ARGS_((Tcl_Interp * interp, Tk_OptionTable table)); /* 102 */
    Tcl_Obj * (*tkDebugFont) _ANSI_ARGS_((Tk_Window tkwin, char * name)); /* 103 */
    int (*tkFindStateNumObj) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_Obj * optionPtr, CONST TkStateMap * mapPtr, Tcl_Obj * keyPtr)); /* 104 */
    Tcl_HashTable * (*tkGetBitmapPredefTable) _ANSI_ARGS_((void)); /* 105 */
    TkDisplay * (*tkGetDisplayList) _ANSI_ARGS_((void)); /* 106 */
    TkMainInfo * (*tkGetMainInfoList) _ANSI_ARGS_((void)); /* 107 */
    int (*tkGetWindowFromObj) _ANSI_ARGS_((Tcl_Interp * interp, Tk_Window tkwin, Tcl_Obj * objPtr, Tk_Window * windowPtr)); /* 108 */
    char * (*tkpGetString) _ANSI_ARGS_((TkWindow * winPtr, XEvent * eventPtr, Tcl_DString * dsPtr)); /* 109 */
    void (*tkpGetSubFonts) _ANSI_ARGS_((Tcl_Interp * interp, Tk_Font tkfont)); /* 110 */
    Tcl_Obj * (*tkpGetSystemDefault) _ANSI_ARGS_((Tk_Window tkwin, CONST char * dbName, CONST char * className)); /* 111 */
    void (*tkpMenuThreadInit) _ANSI_ARGS_((void)); /* 112 */
#if !defined(__WIN32__) && !defined(MAC_TCL) /* UNIX */
    void *reserved113;
#endif /* UNIX */
#ifdef __WIN32__
    void (*tkClipBox) _ANSI_ARGS_((TkRegion rgn, XRectangle* rect_return)); /* 113 */
#endif /* __WIN32__ */
#ifdef MAC_TCL
    void (*tkClipBox) _ANSI_ARGS_((TkRegion rgn, XRectangle* rect_return)); /* 113 */
#endif /* MAC_TCL */
#ifdef MAC_OSX_TK
    void (*tkClipBox) _ANSI_ARGS_((TkRegion rgn, XRectangle* rect_return)); /* 113 */
#endif /* MAC_OSX_TK */
#if !defined(__WIN32__) && !defined(MAC_TCL) /* UNIX */
    void *reserved114;
#endif /* UNIX */
#ifdef __WIN32__
    TkRegion (*tkCreateRegion) _ANSI_ARGS_((void)); /* 114 */
#endif /* __WIN32__ */
#ifdef MAC_TCL
    TkRegion (*tkCreateRegion) _ANSI_ARGS_((void)); /* 114 */
#endif /* MAC_TCL */
#ifdef MAC_OSX_TK
    TkRegion (*tkCreateRegion) _ANSI_ARGS_((void)); /* 114 */
#endif /* MAC_OSX_TK */
#if !defined(__WIN32__) && !defined(MAC_TCL) /* UNIX */
    void *reserved115;
#endif /* UNIX */
#ifdef __WIN32__
    void (*tkDestroyRegion) _ANSI_ARGS_((TkRegion rgn)); /* 115 */
#endif /* __WIN32__ */
#ifdef MAC_TCL
    void (*tkDestroyRegion) _ANSI_ARGS_((TkRegion rgn)); /* 115 */
#endif /* MAC_TCL */
#ifdef MAC_OSX_TK
    void (*tkDestroyRegion) _ANSI_ARGS_((TkRegion rgn)); /* 115 */
#endif /* MAC_OSX_TK */
#if !defined(__WIN32__) && !defined(MAC_TCL) /* UNIX */
    void *reserved116;
#endif /* UNIX */
#ifdef __WIN32__
    void (*tkIntersectRegion) _ANSI_ARGS_((TkRegion sra, TkRegion srcb, TkRegion dr_return)); /* 116 */
#endif /* __WIN32__ */
#ifdef MAC_TCL
    void (*tkIntersectRegion) _ANSI_ARGS_((TkRegion sra, TkRegion srcb, TkRegion dr_return)); /* 116 */
#endif /* MAC_TCL */
#ifdef MAC_OSX_TK
    void (*tkIntersectRegion) _ANSI_ARGS_((TkRegion sra, TkRegion srcb, TkRegion dr_return)); /* 116 */
#endif /* MAC_OSX_TK */
#if !defined(__WIN32__) && !defined(MAC_TCL) /* UNIX */
    void *reserved117;
#endif /* UNIX */
#ifdef __WIN32__
    int (*tkRectInRegion) _ANSI_ARGS_((TkRegion rgn, int x, int y, unsigned int width, unsigned int height)); /* 117 */
#endif /* __WIN32__ */
#ifdef MAC_TCL
    int (*tkRectInRegion) _ANSI_ARGS_((TkRegion rgn, int x, int y, unsigned int width, unsigned int height)); /* 117 */
#endif /* MAC_TCL */
#ifdef MAC_OSX_TK
    int (*tkRectInRegion) _ANSI_ARGS_((TkRegion rgn, int x, int y, unsigned int width, unsigned int height)); /* 117 */
#endif /* MAC_OSX_TK */
#if !defined(__WIN32__) && !defined(MAC_TCL) /* UNIX */
    void *reserved118;
#endif /* UNIX */
#ifdef __WIN32__
    void (*tkSetRegion) _ANSI_ARGS_((Display* display, GC gc, TkRegion rgn)); /* 118 */
#endif /* __WIN32__ */
#ifdef MAC_TCL
    void (*tkSetRegion) _ANSI_ARGS_((Display* display, GC gc, TkRegion rgn)); /* 118 */
#endif /* MAC_TCL */
#ifdef MAC_OSX_TK
    void (*tkSetRegion) _ANSI_ARGS_((Display* display, GC gc, TkRegion rgn)); /* 118 */
#endif /* MAC_OSX_TK */
#if !defined(__WIN32__) && !defined(MAC_TCL) /* UNIX */
    void *reserved119;
#endif /* UNIX */
#ifdef __WIN32__
    void (*tkUnionRectWithRegion) _ANSI_ARGS_((XRectangle* rect, TkRegion src, TkRegion dr_return)); /* 119 */
#endif /* __WIN32__ */
#ifdef MAC_TCL
    void (*tkUnionRectWithRegion) _ANSI_ARGS_((XRectangle* rect, TkRegion src, TkRegion dr_return)); /* 119 */
#endif /* MAC_TCL */
#ifdef MAC_OSX_TK
    void (*tkUnionRectWithRegion) _ANSI_ARGS_((XRectangle* rect, TkRegion src, TkRegion dr_return)); /* 119 */
#endif /* MAC_OSX_TK */
    void *reserved120;
#if !defined(__WIN32__) && !defined(MAC_TCL) /* UNIX */
    void *reserved121;
#endif /* UNIX */
#ifdef __WIN32__
    void *reserved121;
#endif /* __WIN32__ */
#ifdef MAC_TCL
    Pixmap (*tkpCreateNativeBitmap) _ANSI_ARGS_((Display * display, CONST char * source)); /* 121 */
#endif /* MAC_TCL */
#ifdef MAC_OSX_TK
    Pixmap (*tkpCreateNativeBitmap) _ANSI_ARGS_((Display * display, CONST char * source)); /* 121 */
#endif /* MAC_OSX_TK */
#if !defined(__WIN32__) && !defined(MAC_TCL) /* UNIX */
    void *reserved122;
#endif /* UNIX */
#ifdef __WIN32__
    void *reserved122;
#endif /* __WIN32__ */
#ifdef MAC_TCL
    void (*tkpDefineNativeBitmaps) _ANSI_ARGS_((void)); /* 122 */
#endif /* MAC_TCL */
#ifdef MAC_OSX_TK
    void (*tkpDefineNativeBitmaps) _ANSI_ARGS_((void)); /* 122 */
#endif /* MAC_OSX_TK */
    void *reserved123;
#if !defined(__WIN32__) && !defined(MAC_TCL) /* UNIX */
    void *reserved124;
#endif /* UNIX */
#ifdef __WIN32__
    void *reserved124;
#endif /* __WIN32__ */
#ifdef MAC_TCL
    Pixmap (*tkpGetNativeAppBitmap) _ANSI_ARGS_((Display * display, CONST char * name, int * width, int * height)); /* 124 */
#endif /* MAC_TCL */
#ifdef MAC_OSX_TK
    Pixmap (*tkpGetNativeAppBitmap) _ANSI_ARGS_((Display * display, CONST char * name, int * width, int * height)); /* 124 */
#endif /* MAC_OSX_TK */
    void *reserved125;
    void *reserved126;
    void *reserved127;
    void *reserved128;
    void *reserved129;
    void *reserved130;
    void *reserved131;
    void *reserved132;
    void *reserved133;
    void *reserved134;
    void (*tkpDrawHighlightBorder) _ANSI_ARGS_((Tk_Window tkwin, GC fgGC, GC bgGC, int highlightWidth, Drawable drawable)); /* 135 */
    void (*tkSetFocusWin) _ANSI_ARGS_((TkWindow * winPtr, int force)); /* 136 */
    void (*tkpSetKeycodeAndState) _ANSI_ARGS_((Tk_Window tkwin, KeySym keySym, XEvent * eventPtr)); /* 137 */
    KeySym (*tkpGetKeySym) _ANSI_ARGS_((TkDisplay * dispPtr, XEvent * eventPtr)); /* 138 */
    void (*tkpInitKeymapInfo) _ANSI_ARGS_((TkDisplay * dispPtr)); /* 139 */
    TkRegion (*tkPhotoGetValidRegion) _ANSI_ARGS_((Tk_PhotoHandle handle)); /* 140 */
    TkWindow ** (*tkWmStackorderToplevel) _ANSI_ARGS_((TkWindow * parentPtr)); /* 141 */
    void (*tkFocusFree) _ANSI_ARGS_((TkMainInfo * mainPtr)); /* 142 */
    void (*tkClipCleanup) _ANSI_ARGS_((TkDisplay * dispPtr)); /* 143 */
    void (*tkGCCleanup) _ANSI_ARGS_((TkDisplay * dispPtr)); /* 144 */
#if !defined(__WIN32__) && !defined(MAC_TCL) /* UNIX */
    void *reserved145;
#endif /* UNIX */
#ifdef __WIN32__
    void (*tkSubtractRegion) _ANSI_ARGS_((TkRegion sra, TkRegion srcb, TkRegion dr_return)); /* 145 */
#endif /* __WIN32__ */
#ifdef MAC_TCL
    void (*tkSubtractRegion) _ANSI_ARGS_((TkRegion sra, TkRegion srcb, TkRegion dr_return)); /* 145 */
#endif /* MAC_TCL */
#ifdef MAC_OSX_TK
    void (*tkSubtractRegion) _ANSI_ARGS_((TkRegion sra, TkRegion srcb, TkRegion dr_return)); /* 145 */
#endif /* MAC_OSX_TK */
    void (*tkStylePkgInit) _ANSI_ARGS_((TkMainInfo * mainPtr)); /* 146 */
    void (*tkStylePkgFree) _ANSI_ARGS_((TkMainInfo * mainPtr)); /* 147 */
    Tk_Window (*tkToplevelWindowForCommand) _ANSI_ARGS_((Tcl_Interp * interp, CONST char * cmdName)); /* 148 */
    CONST Tk_OptionSpec * (*tkGetOptionSpec) _ANSI_ARGS_((CONST char * name, Tk_OptionTable optionTable)); /* 149 */
    void *reserved150;
    void *reserved151;
    void (*tkpDrawFrame) _ANSI_ARGS_((Tk_Window tkwin, Tk_3DBorder border, int highlightWidth, int borderWidth, int relief)); /* 152 */
} TkIntStubs;

#ifdef __cplusplus
extern "C" {
#endif
extern TkIntStubs *tkIntStubsPtr;
#ifdef __cplusplus
}
#endif

#if defined(USE_TK_STUBS) && !defined(USE_TK_STUB_PROCS)

/*
 * Inline function declarations:
 */

#ifndef TkAllocWindow
#define TkAllocWindow \
  (tkIntStubsPtr->tkAllocWindow) /* 0 */
#endif
#ifndef TkBezierPoints
#define TkBezierPoints \
  (tkIntStubsPtr->tkBezierPoints) /* 1 */
#endif
#ifndef TkBezierScreenPoints
#define TkBezierScreenPoints \
  (tkIntStubsPtr->tkBezierScreenPoints) /* 2 */
#endif
#ifndef TkBindDeadWindow
#define TkBindDeadWindow \
  (tkIntStubsPtr->tkBindDeadWindow) /* 3 */
#endif
#ifndef TkBindEventProc
#define TkBindEventProc \
  (tkIntStubsPtr->tkBindEventProc) /* 4 */
#endif
#ifndef TkBindFree
#define TkBindFree \
  (tkIntStubsPtr->tkBindFree) /* 5 */
#endif
#ifndef TkBindInit
#define TkBindInit \
  (tkIntStubsPtr->tkBindInit) /* 6 */
#endif
#ifndef TkChangeEventWindow
#define TkChangeEventWindow \
  (tkIntStubsPtr->tkChangeEventWindow) /* 7 */
#endif
#ifndef TkClipInit
#define TkClipInit \
  (tkIntStubsPtr->tkClipInit) /* 8 */
#endif
#ifndef TkComputeAnchor
#define TkComputeAnchor \
  (tkIntStubsPtr->tkComputeAnchor) /* 9 */
#endif
#ifndef TkCopyAndGlobalEval
#define TkCopyAndGlobalEval \
  (tkIntStubsPtr->tkCopyAndGlobalEval) /* 10 */
#endif
#ifndef TkCreateBindingProcedure
#define TkCreateBindingProcedure \
  (tkIntStubsPtr->tkCreateBindingProcedure) /* 11 */
#endif
#ifndef TkCreateCursorFromData
#define TkCreateCursorFromData \
  (tkIntStubsPtr->tkCreateCursorFromData) /* 12 */
#endif
#ifndef TkCreateFrame
#define TkCreateFrame \
  (tkIntStubsPtr->tkCreateFrame) /* 13 */
#endif
#ifndef TkCreateMainWindow
#define TkCreateMainWindow \
  (tkIntStubsPtr->tkCreateMainWindow) /* 14 */
#endif
#ifndef TkCurrentTime
#define TkCurrentTime \
  (tkIntStubsPtr->tkCurrentTime) /* 15 */
#endif
#ifndef TkDeleteAllImages
#define TkDeleteAllImages \
  (tkIntStubsPtr->tkDeleteAllImages) /* 16 */
#endif
#ifndef TkDoConfigureNotify
#define TkDoConfigureNotify \
  (tkIntStubsPtr->tkDoConfigureNotify) /* 17 */
#endif
#ifndef TkDrawInsetFocusHighlight
#define TkDrawInsetFocusHighlight \
  (tkIntStubsPtr->tkDrawInsetFocusHighlight) /* 18 */
#endif
#ifndef TkEventDeadWindow
#define TkEventDeadWindow \
  (tkIntStubsPtr->tkEventDeadWindow) /* 19 */
#endif
#ifndef TkFillPolygon
#define TkFillPolygon \
  (tkIntStubsPtr->tkFillPolygon) /* 20 */
#endif
#ifndef TkFindStateNum
#define TkFindStateNum \
  (tkIntStubsPtr->tkFindStateNum) /* 21 */
#endif
#ifndef TkFindStateString
#define TkFindStateString \
  (tkIntStubsPtr->tkFindStateString) /* 22 */
#endif
#ifndef TkFocusDeadWindow
#define TkFocusDeadWindow \
  (tkIntStubsPtr->tkFocusDeadWindow) /* 23 */
#endif
#ifndef TkFocusFilterEvent
#define TkFocusFilterEvent \
  (tkIntStubsPtr->tkFocusFilterEvent) /* 24 */
#endif
#ifndef TkFocusKeyEvent
#define TkFocusKeyEvent \
  (tkIntStubsPtr->tkFocusKeyEvent) /* 25 */
#endif
#ifndef TkFontPkgInit
#define TkFontPkgInit \
  (tkIntStubsPtr->tkFontPkgInit) /* 26 */
#endif
#ifndef TkFontPkgFree
#define TkFontPkgFree \
  (tkIntStubsPtr->tkFontPkgFree) /* 27 */
#endif
#ifndef TkFreeBindingTags
#define TkFreeBindingTags \
  (tkIntStubsPtr->tkFreeBindingTags) /* 28 */
#endif
#ifndef TkpFreeCursor
#define TkpFreeCursor \
  (tkIntStubsPtr->tkpFreeCursor) /* 29 */
#endif
#ifndef TkGetBitmapData
#define TkGetBitmapData \
  (tkIntStubsPtr->tkGetBitmapData) /* 30 */
#endif
#ifndef TkGetButtPoints
#define TkGetButtPoints \
  (tkIntStubsPtr->tkGetButtPoints) /* 31 */
#endif
#ifndef TkGetCursorByName
#define TkGetCursorByName \
  (tkIntStubsPtr->tkGetCursorByName) /* 32 */
#endif
#ifndef TkGetDefaultScreenName
#define TkGetDefaultScreenName \
  (tkIntStubsPtr->tkGetDefaultScreenName) /* 33 */
#endif
#ifndef TkGetDisplay
#define TkGetDisplay \
  (tkIntStubsPtr->tkGetDisplay) /* 34 */
#endif
#ifndef TkGetDisplayOf
#define TkGetDisplayOf \
  (tkIntStubsPtr->tkGetDisplayOf) /* 35 */
#endif
#ifndef TkGetFocusWin
#define TkGetFocusWin \
  (tkIntStubsPtr->tkGetFocusWin) /* 36 */
#endif
#ifndef TkGetInterpNames
#define TkGetInterpNames \
  (tkIntStubsPtr->tkGetInterpNames) /* 37 */
#endif
#ifndef TkGetMiterPoints
#define TkGetMiterPoints \
  (tkIntStubsPtr->tkGetMiterPoints) /* 38 */
#endif
#ifndef TkGetPointerCoords
#define TkGetPointerCoords \
  (tkIntStubsPtr->tkGetPointerCoords) /* 39 */
#endif
#ifndef TkGetServerInfo
#define TkGetServerInfo \
  (tkIntStubsPtr->tkGetServerInfo) /* 40 */
#endif
#ifndef TkGrabDeadWindow
#define TkGrabDeadWindow \
  (tkIntStubsPtr->tkGrabDeadWindow) /* 41 */
#endif
#ifndef TkGrabState
#define TkGrabState \
  (tkIntStubsPtr->tkGrabState) /* 42 */
#endif
#ifndef TkIncludePoint
#define TkIncludePoint \
  (tkIntStubsPtr->tkIncludePoint) /* 43 */
#endif
#ifndef TkInOutEvents
#define TkInOutEvents \
  (tkIntStubsPtr->tkInOutEvents) /* 44 */
#endif
#ifndef TkInstallFrameMenu
#define TkInstallFrameMenu \
  (tkIntStubsPtr->tkInstallFrameMenu) /* 45 */
#endif
#ifndef TkKeysymToString
#define TkKeysymToString \
  (tkIntStubsPtr->tkKeysymToString) /* 46 */
#endif
#ifndef TkLineToArea
#define TkLineToArea \
  (tkIntStubsPtr->tkLineToArea) /* 47 */
#endif
#ifndef TkLineToPoint
#define TkLineToPoint \
  (tkIntStubsPtr->tkLineToPoint) /* 48 */
#endif
#ifndef TkMakeBezierCurve
#define TkMakeBezierCurve \
  (tkIntStubsPtr->tkMakeBezierCurve) /* 49 */
#endif
#ifndef TkMakeBezierPostscript
#define TkMakeBezierPostscript \
  (tkIntStubsPtr->tkMakeBezierPostscript) /* 50 */
#endif
#ifndef TkOptionClassChanged
#define TkOptionClassChanged \
  (tkIntStubsPtr->tkOptionClassChanged) /* 51 */
#endif
#ifndef TkOptionDeadWindow
#define TkOptionDeadWindow \
  (tkIntStubsPtr->tkOptionDeadWindow) /* 52 */
#endif
#ifndef TkOvalToArea
#define TkOvalToArea \
  (tkIntStubsPtr->tkOvalToArea) /* 53 */
#endif
#ifndef TkOvalToPoint
#define TkOvalToPoint \
  (tkIntStubsPtr->tkOvalToPoint) /* 54 */
#endif
#ifndef TkpChangeFocus
#define TkpChangeFocus \
  (tkIntStubsPtr->tkpChangeFocus) /* 55 */
#endif
#ifndef TkpCloseDisplay
#define TkpCloseDisplay \
  (tkIntStubsPtr->tkpCloseDisplay) /* 56 */
#endif
#ifndef TkpClaimFocus
#define TkpClaimFocus \
  (tkIntStubsPtr->tkpClaimFocus) /* 57 */
#endif
#ifndef TkpDisplayWarning
#define TkpDisplayWarning \
  (tkIntStubsPtr->tkpDisplayWarning) /* 58 */
#endif
#ifndef TkpGetAppName
#define TkpGetAppName \
  (tkIntStubsPtr->tkpGetAppName) /* 59 */
#endif
#ifndef TkpGetOtherWindow
#define TkpGetOtherWindow \
  (tkIntStubsPtr->tkpGetOtherWindow) /* 60 */
#endif
#ifndef TkpGetWrapperWindow
#define TkpGetWrapperWindow \
  (tkIntStubsPtr->tkpGetWrapperWindow) /* 61 */
#endif
#ifndef TkpInit
#define TkpInit \
  (tkIntStubsPtr->tkpInit) /* 62 */
#endif
#ifndef TkpInitializeMenuBindings
#define TkpInitializeMenuBindings \
  (tkIntStubsPtr->tkpInitializeMenuBindings) /* 63 */
#endif
#ifndef TkpMakeContainer
#define TkpMakeContainer \
  (tkIntStubsPtr->tkpMakeContainer) /* 64 */
#endif
#ifndef TkpMakeMenuWindow
#define TkpMakeMenuWindow \
  (tkIntStubsPtr->tkpMakeMenuWindow) /* 65 */
#endif
#ifndef TkpMakeWindow
#define TkpMakeWindow \
  (tkIntStubsPtr->tkpMakeWindow) /* 66 */
#endif
#ifndef TkpMenuNotifyToplevelCreate
#define TkpMenuNotifyToplevelCreate \
  (tkIntStubsPtr->tkpMenuNotifyToplevelCreate) /* 67 */
#endif
#ifndef TkpOpenDisplay
#define TkpOpenDisplay \
  (tkIntStubsPtr->tkpOpenDisplay) /* 68 */
#endif
#ifndef TkPointerEvent
#define TkPointerEvent \
  (tkIntStubsPtr->tkPointerEvent) /* 69 */
#endif
#ifndef TkPolygonToArea
#define TkPolygonToArea \
  (tkIntStubsPtr->tkPolygonToArea) /* 70 */
#endif
#ifndef TkPolygonToPoint
#define TkPolygonToPoint \
  (tkIntStubsPtr->tkPolygonToPoint) /* 71 */
#endif
#ifndef TkPositionInTree
#define TkPositionInTree \
  (tkIntStubsPtr->tkPositionInTree) /* 72 */
#endif
#ifndef TkpRedirectKeyEvent
#define TkpRedirectKeyEvent \
  (tkIntStubsPtr->tkpRedirectKeyEvent) /* 73 */
#endif
#ifndef TkpSetMainMenubar
#define TkpSetMainMenubar \
  (tkIntStubsPtr->tkpSetMainMenubar) /* 74 */
#endif
#ifndef TkpUseWindow
#define TkpUseWindow \
  (tkIntStubsPtr->tkpUseWindow) /* 75 */
#endif
#ifndef TkpWindowWasRecentlyDeleted
#define TkpWindowWasRecentlyDeleted \
  (tkIntStubsPtr->tkpWindowWasRecentlyDeleted) /* 76 */
#endif
#ifndef TkQueueEventForAllChildren
#define TkQueueEventForAllChildren \
  (tkIntStubsPtr->tkQueueEventForAllChildren) /* 77 */
#endif
#ifndef TkReadBitmapFile
#define TkReadBitmapFile \
  (tkIntStubsPtr->tkReadBitmapFile) /* 78 */
#endif
#ifndef TkScrollWindow
#define TkScrollWindow \
  (tkIntStubsPtr->tkScrollWindow) /* 79 */
#endif
#ifndef TkSelDeadWindow
#define TkSelDeadWindow \
  (tkIntStubsPtr->tkSelDeadWindow) /* 80 */
#endif
#ifndef TkSelEventProc
#define TkSelEventProc \
  (tkIntStubsPtr->tkSelEventProc) /* 81 */
#endif
#ifndef TkSelInit
#define TkSelInit \
  (tkIntStubsPtr->tkSelInit) /* 82 */
#endif
#ifndef TkSelPropProc
#define TkSelPropProc \
  (tkIntStubsPtr->tkSelPropProc) /* 83 */
#endif
/* Slot 84 is reserved */
#ifndef TkSetWindowMenuBar
#define TkSetWindowMenuBar \
  (tkIntStubsPtr->tkSetWindowMenuBar) /* 85 */
#endif
#ifndef TkStringToKeysym
#define TkStringToKeysym \
  (tkIntStubsPtr->tkStringToKeysym) /* 86 */
#endif
#ifndef TkThickPolyLineToArea
#define TkThickPolyLineToArea \
  (tkIntStubsPtr->tkThickPolyLineToArea) /* 87 */
#endif
#ifndef TkWmAddToColormapWindows
#define TkWmAddToColormapWindows \
  (tkIntStubsPtr->tkWmAddToColormapWindows) /* 88 */
#endif
#ifndef TkWmDeadWindow
#define TkWmDeadWindow \
  (tkIntStubsPtr->tkWmDeadWindow) /* 89 */
#endif
#ifndef TkWmFocusToplevel
#define TkWmFocusToplevel \
  (tkIntStubsPtr->tkWmFocusToplevel) /* 90 */
#endif
#ifndef TkWmMapWindow
#define TkWmMapWindow \
  (tkIntStubsPtr->tkWmMapWindow) /* 91 */
#endif
#ifndef TkWmNewWindow
#define TkWmNewWindow \
  (tkIntStubsPtr->tkWmNewWindow) /* 92 */
#endif
#ifndef TkWmProtocolEventProc
#define TkWmProtocolEventProc \
  (tkIntStubsPtr->tkWmProtocolEventProc) /* 93 */
#endif
#ifndef TkWmRemoveFromColormapWindows
#define TkWmRemoveFromColormapWindows \
  (tkIntStubsPtr->tkWmRemoveFromColormapWindows) /* 94 */
#endif
#ifndef TkWmRestackToplevel
#define TkWmRestackToplevel \
  (tkIntStubsPtr->tkWmRestackToplevel) /* 95 */
#endif
#ifndef TkWmSetClass
#define TkWmSetClass \
  (tkIntStubsPtr->tkWmSetClass) /* 96 */
#endif
#ifndef TkWmUnmapWindow
#define TkWmUnmapWindow \
  (tkIntStubsPtr->tkWmUnmapWindow) /* 97 */
#endif
#ifndef TkDebugBitmap
#define TkDebugBitmap \
  (tkIntStubsPtr->tkDebugBitmap) /* 98 */
#endif
#ifndef TkDebugBorder
#define TkDebugBorder \
  (tkIntStubsPtr->tkDebugBorder) /* 99 */
#endif
#ifndef TkDebugCursor
#define TkDebugCursor \
  (tkIntStubsPtr->tkDebugCursor) /* 100 */
#endif
#ifndef TkDebugColor
#define TkDebugColor \
  (tkIntStubsPtr->tkDebugColor) /* 101 */
#endif
#ifndef TkDebugConfig
#define TkDebugConfig \
  (tkIntStubsPtr->tkDebugConfig) /* 102 */
#endif
#ifndef TkDebugFont
#define TkDebugFont \
  (tkIntStubsPtr->tkDebugFont) /* 103 */
#endif
#ifndef TkFindStateNumObj
#define TkFindStateNumObj \
  (tkIntStubsPtr->tkFindStateNumObj) /* 104 */
#endif
#ifndef TkGetBitmapPredefTable
#define TkGetBitmapPredefTable \
  (tkIntStubsPtr->tkGetBitmapPredefTable) /* 105 */
#endif
#ifndef TkGetDisplayList
#define TkGetDisplayList \
  (tkIntStubsPtr->tkGetDisplayList) /* 106 */
#endif
#ifndef TkGetMainInfoList
#define TkGetMainInfoList \
  (tkIntStubsPtr->tkGetMainInfoList) /* 107 */
#endif
#ifndef TkGetWindowFromObj
#define TkGetWindowFromObj \
  (tkIntStubsPtr->tkGetWindowFromObj) /* 108 */
#endif
#ifndef TkpGetString
#define TkpGetString \
  (tkIntStubsPtr->tkpGetString) /* 109 */
#endif
#ifndef TkpGetSubFonts
#define TkpGetSubFonts \
  (tkIntStubsPtr->tkpGetSubFonts) /* 110 */
#endif
#ifndef TkpGetSystemDefault
#define TkpGetSystemDefault \
  (tkIntStubsPtr->tkpGetSystemDefault) /* 111 */
#endif
#ifndef TkpMenuThreadInit
#define TkpMenuThreadInit \
  (tkIntStubsPtr->tkpMenuThreadInit) /* 112 */
#endif
#ifdef __WIN32__
#ifndef TkClipBox
#define TkClipBox \
  (tkIntStubsPtr->tkClipBox) /* 113 */
#endif
#endif /* __WIN32__ */
#ifdef MAC_TCL
#ifndef TkClipBox
#define TkClipBox \
  (tkIntStubsPtr->tkClipBox) /* 113 */
#endif
#endif /* MAC_TCL */
#ifdef MAC_OSX_TK
#ifndef TkClipBox
#define TkClipBox \
  (tkIntStubsPtr->tkClipBox) /* 113 */
#endif
#endif /* MAC_OSX_TK */
#ifdef __WIN32__
#ifndef TkCreateRegion
#define TkCreateRegion \
  (tkIntStubsPtr->tkCreateRegion) /* 114 */
#endif
#endif /* __WIN32__ */
#ifdef MAC_TCL
#ifndef TkCreateRegion
#define TkCreateRegion \
  (tkIntStubsPtr->tkCreateRegion) /* 114 */
#endif
#endif /* MAC_TCL */
#ifdef MAC_OSX_TK
#ifndef TkCreateRegion
#define TkCreateRegion \
  (tkIntStubsPtr->tkCreateRegion) /* 114 */
#endif
#endif /* MAC_OSX_TK */
#ifdef __WIN32__
#ifndef TkDestroyRegion
#define TkDestroyRegion \
  (tkIntStubsPtr->tkDestroyRegion) /* 115 */
#endif
#endif /* __WIN32__ */
#ifdef MAC_TCL
#ifndef TkDestroyRegion
#define TkDestroyRegion \
  (tkIntStubsPtr->tkDestroyRegion) /* 115 */
#endif
#endif /* MAC_TCL */
#ifdef MAC_OSX_TK
#ifndef TkDestroyRegion
#define TkDestroyRegion \
  (tkIntStubsPtr->tkDestroyRegion) /* 115 */
#endif
#endif /* MAC_OSX_TK */
#ifdef __WIN32__
#ifndef TkIntersectRegion
#define TkIntersectRegion \
  (tkIntStubsPtr->tkIntersectRegion) /* 116 */
#endif
#endif /* __WIN32__ */
#ifdef MAC_TCL
#ifndef TkIntersectRegion
#define TkIntersectRegion \
  (tkIntStubsPtr->tkIntersectRegion) /* 116 */
#endif
#endif /* MAC_TCL */
#ifdef MAC_OSX_TK
#ifndef TkIntersectRegion
#define TkIntersectRegion \
  (tkIntStubsPtr->tkIntersectRegion) /* 116 */
#endif
#endif /* MAC_OSX_TK */
#ifdef __WIN32__
#ifndef TkRectInRegion
#define TkRectInRegion \
  (tkIntStubsPtr->tkRectInRegion) /* 117 */
#endif
#endif /* __WIN32__ */
#ifdef MAC_TCL
#ifndef TkRectInRegion
#define TkRectInRegion \
  (tkIntStubsPtr->tkRectInRegion) /* 117 */
#endif
#endif /* MAC_TCL */
#ifdef MAC_OSX_TK
#ifndef TkRectInRegion
#define TkRectInRegion \
  (tkIntStubsPtr->tkRectInRegion) /* 117 */
#endif
#endif /* MAC_OSX_TK */
#ifdef __WIN32__
#ifndef TkSetRegion
#define TkSetRegion \
  (tkIntStubsPtr->tkSetRegion) /* 118 */
#endif
#endif /* __WIN32__ */
#ifdef MAC_TCL
#ifndef TkSetRegion
#define TkSetRegion \
  (tkIntStubsPtr->tkSetRegion) /* 118 */
#endif
#endif /* MAC_TCL */
#ifdef MAC_OSX_TK
#ifndef TkSetRegion
#define TkSetRegion \
  (tkIntStubsPtr->tkSetRegion) /* 118 */
#endif
#endif /* MAC_OSX_TK */
#ifdef __WIN32__
#ifndef TkUnionRectWithRegion
#define TkUnionRectWithRegion \
  (tkIntStubsPtr->tkUnionRectWithRegion) /* 119 */
#endif
#endif /* __WIN32__ */
#ifdef MAC_TCL
#ifndef TkUnionRectWithRegion
#define TkUnionRectWithRegion \
  (tkIntStubsPtr->tkUnionRectWithRegion) /* 119 */
#endif
#endif /* MAC_TCL */
#ifdef MAC_OSX_TK
#ifndef TkUnionRectWithRegion
#define TkUnionRectWithRegion \
  (tkIntStubsPtr->tkUnionRectWithRegion) /* 119 */
#endif
#endif /* MAC_OSX_TK */
/* Slot 120 is reserved */
#ifdef MAC_TCL
#ifndef TkpCreateNativeBitmap
#define TkpCreateNativeBitmap \
  (tkIntStubsPtr->tkpCreateNativeBitmap) /* 121 */
#endif
#endif /* MAC_TCL */
#ifdef MAC_OSX_TK
#ifndef TkpCreateNativeBitmap
#define TkpCreateNativeBitmap \
  (tkIntStubsPtr->tkpCreateNativeBitmap) /* 121 */
#endif
#endif /* MAC_OSX_TK */
#ifdef MAC_TCL
#ifndef TkpDefineNativeBitmaps
#define TkpDefineNativeBitmaps \
  (tkIntStubsPtr->tkpDefineNativeBitmaps) /* 122 */
#endif
#endif /* MAC_TCL */
#ifdef MAC_OSX_TK
#ifndef TkpDefineNativeBitmaps
#define TkpDefineNativeBitmaps \
  (tkIntStubsPtr->tkpDefineNativeBitmaps) /* 122 */
#endif
#endif /* MAC_OSX_TK */
/* Slot 123 is reserved */
#ifdef MAC_TCL
#ifndef TkpGetNativeAppBitmap
#define TkpGetNativeAppBitmap \
  (tkIntStubsPtr->tkpGetNativeAppBitmap) /* 124 */
#endif
#endif /* MAC_TCL */
#ifdef MAC_OSX_TK
#ifndef TkpGetNativeAppBitmap
#define TkpGetNativeAppBitmap \
  (tkIntStubsPtr->tkpGetNativeAppBitmap) /* 124 */
#endif
#endif /* MAC_OSX_TK */
/* Slot 125 is reserved */
/* Slot 126 is reserved */
/* Slot 127 is reserved */
/* Slot 128 is reserved */
/* Slot 129 is reserved */
/* Slot 130 is reserved */
/* Slot 131 is reserved */
/* Slot 132 is reserved */
/* Slot 133 is reserved */
/* Slot 134 is reserved */
#ifndef TkpDrawHighlightBorder
#define TkpDrawHighlightBorder \
  (tkIntStubsPtr->tkpDrawHighlightBorder) /* 135 */
#endif
#ifndef TkSetFocusWin
#define TkSetFocusWin \
  (tkIntStubsPtr->tkSetFocusWin) /* 136 */
#endif
#ifndef TkpSetKeycodeAndState
#define TkpSetKeycodeAndState \
  (tkIntStubsPtr->tkpSetKeycodeAndState) /* 137 */
#endif
#ifndef TkpGetKeySym
#define TkpGetKeySym \
  (tkIntStubsPtr->tkpGetKeySym) /* 138 */
#endif
#ifndef TkpInitKeymapInfo
#define TkpInitKeymapInfo \
  (tkIntStubsPtr->tkpInitKeymapInfo) /* 139 */
#endif
#ifndef TkPhotoGetValidRegion
#define TkPhotoGetValidRegion \
  (tkIntStubsPtr->tkPhotoGetValidRegion) /* 140 */
#endif
#ifndef TkWmStackorderToplevel
#define TkWmStackorderToplevel \
  (tkIntStubsPtr->tkWmStackorderToplevel) /* 141 */
#endif
#ifndef TkFocusFree
#define TkFocusFree \
  (tkIntStubsPtr->tkFocusFree) /* 142 */
#endif
#ifndef TkClipCleanup
#define TkClipCleanup \
  (tkIntStubsPtr->tkClipCleanup) /* 143 */
#endif
#ifndef TkGCCleanup
#define TkGCCleanup \
  (tkIntStubsPtr->tkGCCleanup) /* 144 */
#endif
#ifdef __WIN32__
#ifndef TkSubtractRegion
#define TkSubtractRegion \
  (tkIntStubsPtr->tkSubtractRegion) /* 145 */
#endif
#endif /* __WIN32__ */
#ifdef MAC_TCL
#ifndef TkSubtractRegion
#define TkSubtractRegion \
  (tkIntStubsPtr->tkSubtractRegion) /* 145 */
#endif
#endif /* MAC_TCL */
#ifdef MAC_OSX_TK
#ifndef TkSubtractRegion
#define TkSubtractRegion \
  (tkIntStubsPtr->tkSubtractRegion) /* 145 */
#endif
#endif /* MAC_OSX_TK */
#ifndef TkStylePkgInit
#define TkStylePkgInit \
  (tkIntStubsPtr->tkStylePkgInit) /* 146 */
#endif
#ifndef TkStylePkgFree
#define TkStylePkgFree \
  (tkIntStubsPtr->tkStylePkgFree) /* 147 */
#endif
#ifndef TkToplevelWindowForCommand
#define TkToplevelWindowForCommand \
  (tkIntStubsPtr->tkToplevelWindowForCommand) /* 148 */
#endif
#ifndef TkGetOptionSpec
#define TkGetOptionSpec \
  (tkIntStubsPtr->tkGetOptionSpec) /* 149 */
#endif
/* Slot 150 is reserved */
/* Slot 151 is reserved */
#ifndef TkpDrawFrame
#define TkpDrawFrame \
  (tkIntStubsPtr->tkpDrawFrame) /* 152 */
#endif

#endif /* defined(USE_TK_STUBS) && !defined(USE_TK_STUB_PROCS) */

/* !END!: Do not edit above this line. */

#undef TCL_STORAGE_CLASS
#define TCL_STORAGE_CLASS DLLIMPORT

#endif /* _TKINTDECLS */

