;;; sb-cnet.el --- shimbun backend for cnet

;; Copyright (C) 2001 Yuuichi Teranishi <teranisi@gohome.org>

;; Author: TSUCHIYA Masatoshi <tsuchiya@namazu.org>,
;;         Yuuichi Teranishi  <teranisi@gohome.org>
;; Keywords: news

;; This file is a part of shimbun.

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; if not, you can either send email to this
;; program's maintainer or write to: The Free Software Foundation,
;; Inc.; 59 Temple Place, Suite 330; Boston, MA 02111-1307, USA.

;;; Commentary:

;; Original code was nnshimbun.el written by
;; TSUCHIYA Masatoshi <tsuchiya@namazu.org>.

;;; Code:

(require 'shimbun)

(luna-define-class shimbun-cnet (shimbun) ())

(defvar shimbun-cnet-url "http://cnet.sphere.ne.jp/")
(defvar shimbun-cnet-groups '("comp"))
(defvar shimbun-cnet-from-address  "cnet@sphere.ad.jp")
(defvar shimbun-cnet-content-start "\n<!--KIJI-->\n")
(defvar shimbun-cnet-content-end "\n<!--/KIJI-->\n")
(defvar shimbun-cnet-x-face-alist
  '(("default" . "X-Face: 0p7.+XId>z%:!$ahe?x%+AEm37Abvn]n\
*GGh+>v=;[3`a{1lqO[$,~3C3xU_ri>[JwJ!9l0\n ~Y`b*eXAQ:*q=bBI\
_=ro*?]4:|n>]ZiLZ2LEo^2nr('C<+`lO~/!R[lH'N'4X&%\\I}8T!wt")))
(defvar shimbun-cnet-expiration-days 7)

(luna-define-method shimbun-index-url ((shimbun shimbun-cnet))
  (format "%s/News/Oneweek/" (shimbun-url-internal shimbun)))

(luna-define-method shimbun-get-headers ((shimbun shimbun-cnet)
					 &optional range)
  (let ((case-fold-search t) headers)
    (while (search-forward "\n<!--*****$B8+=P$7(B*****-->\n" nil t)
      (let ((subject (buffer-substring (point) (point-at-eol)))
	    (point (point)))
	(forward-line -2)
	(when (looking-at "<a href=\"/\\(News/\\([0-9][0-9][0-9][0-9]\\)/Item/\\([0-9][0-9]\\([0-9][0-9]\\)\\([0-9][0-9]\\)-[0-9]+\\).html\\)\">")
	  (let ((url (match-string 1))
		(id  (format "<%s%s%%%s>"
			     (match-string 2)
			     (match-string 3)
			     (shimbun-current-group-internal shimbun)))
		(date (shimbun-make-date-string
		       (string-to-number (match-string 2))
		       (string-to-number (match-string 4))
		       (string-to-number (match-string 5)))))
	    (push (shimbun-make-header
		   0
		   (shimbun-mime-encode-string subject)
		   (shimbun-from-address-internal shimbun)
		   date id "" 0 0 (concat (shimbun-url-internal shimbun) url))
		  headers)))
	(goto-char point)))
    headers))

(provide 'sb-cnet)

;;; sb-cnet.el ends here
