// Copyright (c) The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors: Malolan Chetlur             mal@ececs.uc.edu
//          Jorgen Dahl                 dahlj@ececs.uc.edu
//          Dale E. Martin              dmartin@cliftonlabs.com
//          Radharamanan Radhakrishnan  ramanan@ececs.uc.edu
//          Dhananjai Madhava Rao       dmadhava@ececs.uc.edu
//          Philip A. Wilsey            phil.wilsey@uc.edu

//---------------------------------------------------------------------------
// 
// $Id: OutputManagerImplementationBase.cpp
// 
//---------------------------------------------------------------------------

#include "OutputEvents.h"
#include "OutputManagerImplementationBase.h"
#include "TimeWarpSimulationManager.h"
#include "Event.h"
#include <clutils/StringHashMap.h>

using std::cout;
using std::cerr;
using std::endl;

OutputManagerImplementationBase::OutputManagerImplementationBase( TimeWarpSimulationManager *simMgr) :
  mySimulationManager(simMgr){
}

OutputManagerImplementationBase::~OutputManagerImplementationBase(){}

OutputEvents &
OutputManagerImplementationBase::getOutputEventsFor( const string &objectName ){
  OutputEvents *retval = myOutputEvents.find( objectName);
  if( retval == 0 ){
    retval = new OutputEvents();
    myOutputEvents.insert( objectName, retval );
  }
  return *retval;
}


void
OutputManagerImplementationBase::insert( const Event *event ){
  getOutputEventsFor( event->getSender() ).insert( event );
}

void
OutputManagerImplementationBase::garbageCollect(const VTime &garbageCollectTime, 
						SimulationObject *object){
  ASSERT(object != NULL);
  clutils::debug << "OutputManager garbage collecting " << object->getName() << " for events "
		 << "prior to time " << garbageCollectTime << endl;
  getOutputEventsFor( object->getName() ).garbageCollect( garbageCollectTime );
}
