#ifndef VTIME_H
#define VTIME_H

#include <warped/Serializable.h>
#include <iostream>
#include <sstream>
#include <string>


class VTime : public Serializable {
public:
  /// Destructor.
  virtual ~VTime();

  virtual VTime *clone () const = 0;

  virtual const VTime &operator=( const VTime &from ) = 0;
  virtual bool operator< (const VTime &right) const = 0;
  virtual bool operator> (const VTime &right) const = 0;
  virtual bool operator== (const VTime &right) const = 0;
  virtual bool operator!= (const VTime &right) const = 0;
  virtual bool operator<= (const VTime &right) const = 0;
  virtual bool operator>= (const VTime &right) const = 0;

  virtual const VTime &getPositiveInfinity() const = 0;
  virtual const VTime &getZero() const = 0;

  /**
     Return this VTime in a string representation.
  */
  virtual const string toString() const = 0;

};


inline
std::ostream &operator<< (std::ostream &os, const VTime& time) {
  os << time.toString();
  return os;
}


#endif
