/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2009 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef DASHBOARDVIEW_H
#define DASHBOARDVIEW_H

#include "view.h"

class QTreeWidget;
class QModelIndex;

class FolderWatchProvider;

/**
* View showing the status of folder watches.
*/
class DashboardView : public View
{
    Q_OBJECT
public:
    /**
    * Constructor.
    *
    * @param parent The parent object.
    *
    * @param parentWidget The parent widget of the view's main widget.
    */
    DashboardView( QObject* parent, QWidget* parentWidget );

    /**
    * Destructor.
    */
    ~DashboardView();

public:
    void setSelectedWatch( int folderId, const QString& filter );

    int selectedFolderId() const { return m_selectedFolderId; }

    QString selectedFilter() const { return m_selectedFilter; }

public: // overrides
    void initialUpdate();

    bool eventFilter( QObject* obj, QEvent* e );

signals:
    /**
    * Emitted when a watch is selected by the user.
    */
    void selectedWatchChanged( int folderId, const QString& filter );

protected: // overrides
    void updateEvent( UpdateEvent* e );

    void viewEvent( ViewEvent* e );

private slots:
    void selectionChanged();
    void activated( const QModelIndex& index );

private:
    void updateWatchedFolders();
    void updateWatchedFolder( int folderId );

    void populateDashboard();

private:
    QTreeWidget* m_tree;

    FolderWatchProvider* m_provider;

    int m_selectedFolderId;
    QString m_selectedFilter;

    bool m_supressSelection;

    int m_activateReason;
};

#endif
