/*
 * WallFire -- a comprehensive firewall administration tool.
 * 
 * Copyright (C) 2001 Herv Eychenne <rv@wallfire.org>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

using namespace std;

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include "netfilter.h"
#include "conf.h"


wf_outmodule_netfilter::wf_outmodule_netfilter() :
  wf_outmodule()
{
  conf = new wf_outmodule_netfilter_conf();
}


bool
wf_outmodule_netfilter::print(const wf_logentry* entry, ostream& os) {
  char datestr[32];
  strftime(datestr, sizeof(datestr), "%b %d %H:%M:%S ",
	   localtime(&(entry->start_time)));

  os << datestr << entry->hostname << " kernel: " <<
    entry->chainlabel <<
    "IN=" << entry->input_iface <<
    " OUT=" << entry->output_iface <<
    " MAC=";
  if (entry->smacaddr.isdefined() && entry->dmacaddr.isdefined())
    os << entry->dmacaddr << ':' << entry->smacaddr << ":08:00";

  os << " SRC=" << entry->sipaddr <<
    " DST=" << entry->dipaddr <<
    " LEN=" << entry->datalen << " TOS=0x00 PREC=0x00 TTL=1 ID=1" <<
    " PROTO=";
  switch (entry->protocol) {
  case IPPROTO_UDP:
    /* We don't store enough data for this length. So we assume it is
       datalen - 20, but it is a hack. ALL@@5 */
    os << "UDP SPT=" << entry->sport << " "  "DPT=" << entry->dport <<
      " LEN=" << entry->datalen - 20;
    break;
  case IPPROTO_TCP:
    os << "TCP SPT=" << entry->sport << " "  "DPT=" << entry->dport;
    if (entry->tcpflags != 0)
      os << entry->tcpflags_tostr();
    break;
  case IPPROTO_ICMP:
    os << "ICMP TYPE=" << entry->sport << " CODE=" << entry->dport;
    break;
  default:
    os << entry->protocol;
  }

  return true;
}

/*
bool
wf_outmodule_netfilter::print(const wf_logentries& logentries,
			      ostream& os) const;

  Here we use native (herited) outmodule method.
*/

extern "C" wf_outmodule*
wf_outmodule_netfilter_init() {
  return new wf_outmodule_netfilter();
}
