/*
 * WallFire -- a comprehensive firewall administration tool.
 * 
 * Copyright (C) 2001 Herv Eychenne <rv@wallfire.org>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

using namespace std;

#include "wfnetobjs.h"


void
metahost_test(void) {
  wf_metahost metahost;
  wf_metahost_elem elem1, elem2, elem3;
  wf_ipaddr ipaddr;
  wf_network network;

  ipaddr.set("10.0.17.6");
  elem1.set(ipaddr);
  metahost.add(elem1);

  network.network_set("10.0.18.0/24");
  elem2.set(network);
  metahost.add(elem2);

  wf_ipaddr_range ipaddr_range("10.0.17.1", "10.0.17.5");
  elem3.set(ipaddr_range);
  metahost.add(elem3);

  metahost.debugprint(cout);
}

void
metaport_test(void) {
  wf_port port(25);
  wf_port_range port_range(30, 50);
  wf_metaport metaport;
  wf_metaport_elem elem1, elem2;

  elem1.set(port);
  metaport.add(elem1);

  elem2.set(port_range);
  metaport.add(elem2);

  metaport.debugprint(cout);
}

int
main(int argc, char *argv[]) {
  metahost_test();
  cout << endl;
  metaport_test();

  exit(0);
}
