#include <iostream>
#include <typeinfo>
#include <assert.h>

// try to pull in a few headers that will pull in the rest

#include "togglebutton.h"
#include "slider.h"
#include "terminal.h"
#include "messagebox.h"
#include "questionbox.h"
#include "rootwindow.h"
#include "listbox.h"
#include "movie.h"
#include "mixer.h"
#include "painter.h"
#include "music.h"
#include "sample.h"
#include "application.h"
#include "screensurface.h"

template<class C>
void StructSize(const C& c)
{
  std::cout << typeid(c).name() << " size is " << sizeof(C) << std::endl;
}

template<class C>
void WidgetSize(const C& c)
{
  std::cout << c.name() << " size is " << sizeof(C) << std::endl;
}

using namespace wftk;

int main(int argc, char **argv)
{
  Application app(argc, argv);

  assert(Application::instance());

  Font::registry.load("text_font","wf_opal.ttf, 17, 0xF0F0F0FF, 0x707070FF");

  new RootWindow(50, 50);

  StructSize(Point());
  StructSize(Rect());
  StructSize(Region());

  StructSize(Color());

  StructSize(Surface());
  StructSize(*RootWindow::instance()->screen()); // ScreenSurface
  StructSize(Font());
  StructSize(Pixelformat());
  StructSize(Painter());

  StructSize(*Application::instance());
  StructSize(Timer(0));

  StructSize(*Focus::instance());
  StructSize(*Mouse::instance());

  StructSize(*Mixer::instance());
  StructSize(Music());
  StructSize(Sample());

  WidgetSize(ScreenArea());
  WidgetSize(*RootWindow::instance());
  WidgetSize(Widget());
  WidgetSize(Label());
  WidgetSize(Button());
  WidgetSize(PushButton());
  WidgetSize(ToggleButton());
  WidgetSize(LineEdit());
  WidgetSize(MultiLineEdit());
  WidgetSize(Terminal());
  WidgetSize(Slider(Slider::HORIZONTAL));
  WidgetSize(ListBox());
  WidgetSize(Movie());
  WidgetSize(Dialog());
//  WidgetSize(ProgressDialog());
//  WidgetSize(wfDialogBox());
//  WidgetSize(MessageDialog(""));
//  WidgetSize(QuestionBox(""));

  return 0;
}
