target=intinj

#include "header.inc"

\title{Intervalle injectif}

#include "values.inc"
#include "tablegen.inc"
#include "common.inc"

\text{size=70x30x1}
\integer{sh=random(1,2,3,4)}
\text{xint=\xmiddles[;1],\xmiddles[\sh;2]}
\text{xint=wims(makelist \(x) for x in \xint)}
\text{yint=1,2,3,4,\sh}
\text{gooddir=\arrows[\sh] issametext ne?croissante:dcroissante}
\text{baddir=\arrows[\sh] issametext se?croissante:dcroissante}

\text{test1=0}
\text{nstep=r1,r2}
\nextstep{\nstep}

\statement{\intro
\if{debug iswordof \oefenv}{
 (DEBUG : \(\xmiddles[\sh;1],\xmiddles[\sh;2]). \gooddir.)
}

#include "table.inc"

\if{\step=1}{
Utilisez les valeurs proposes ci-dessous pour construire un intervalle
ouvert \(I) tel que la restriction de \(f) sur \(I) soit injective.
<p><center>
     \(I) = \rightbrack \embed{reply 1,\size} ,
     \embed{reply 2,\size} \leftbrack
</center><p>
\exit{}
}
\if{\step=2 and \test1<1}{
  Vous avez rpondu : la restriction de \(f) sur l&#39;intervalle
  \(I) = \rightbrack\reply1 , \reply2\leftbrack est injective.
  \exit{}
}
Soit \(f_I) la restriction de \(f) sur l&#39;intervalle \(I) =
  \rightbrack\reply1 , \reply2\leftbrack.
  <p>
  Justifiez : \(f_I) est injective parce qu&#39;elle est <br>
  \embed{reply 3,120x30x5}.
}

\answer{Debut de \(I) vaut}{\rep1;\xint}{type=dragfill}
\answer{Fin de \(I) vaut}{\rep2}{type=dragfill}

\text{rr1=wims(replace internal \ by in \rep1)}
\text{rr2=wims(replace internal \ by in \rep2)}

\text{nstep=}
\text{rleft=position(\rep1,\xint)}
\text{rright=position(\rep2,\xint)}
\if{\rr1<\rr2}{
 \text{rl=\rleft}\text{rr=\rright}
}{
 \text{rl=\rright}\text{rr=\rleft}
}
\text{Rleft=\yint[\rl]}\text{Rright=\yint[\rr]}
\text{test1=items(\rleft)=1 and items(\rright)=1 and \rr1<\rr2 and
      \Rleft=\Rright?1:0}

\text{nstep=\test1>0 and \step=2?r3}
\condition{L&#39;intervalle est bonne}{\test1>0}

\feedback{\rr1 > \rr2}{Vous avez crit l&#39;intervalle  l&#39;envers !
Il faut placer le plus petit nombre  gauche.}

\feedback{\Rleft<\Rright}{
 D&#39;aprs le tableau de variation, \(f_I) n&#39;est pas monotone. Et une 
 fonction continue et non monotone ne peut pas tre injective&nbsp;!
}

\answer{Raison pour l&#39;injectivit}
{strictement,\gooddir;\baddir,continue,et,drivable}{type=clickfill}

\feedback{\test1>0 and \gooddir isitemof \reply3 and
	(continue isitemof \reply3 or drivable isitemof \reply3)}{
 Pour qu&#39;une fonction soit injective, il suffit qu&#39;elle soit
 strictement monotone. Ni la continuit ni la drivabilit n&#39;est
 ncessaire pour assurer l&#39;injectivit.
}

\feedback{\test1>0 and \reply3 issametext \gooddir}{
 Une fonction \gooddir mais pas strictement \gooddir n&#39;est pas
 injective&nbsp;! Pensez  une fonction constante. Elle
 est  la fois croissante et dcroissante, mais videmment pas
 injective.
}

