/*
 * Decompiled with CFR 0.152.
 */
package WIMSchem.ds;

import WIMSchem.Molecule;
import WIMSchem.MoleculeStream;
import WIMSchem.Utils;
import WIMSchem.ds.DataSheet;
import WIMSchem.ds.TrivialDOM;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;

public class DataSheetStream {
    public static boolean ExamineIsXMLDS(FileInputStream istr) {
        boolean ret = false;
        try {
            long lastpos = istr.getChannel().position();
            BufferedReader rdr = new BufferedReader(new InputStreamReader(istr));
            ret = DataSheetStream.ExamineIsXMLDS(rdr);
            istr.getChannel().position(lastpos);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ret;
    }

    public static boolean ExamineIsXMLDS(BufferedReader rdr) {
        try {
            String str;
            for (int n = 0; n < 2 && (str = rdr.readLine()) != null; ++n) {
                if (!str.startsWith("<DataSheet>")) continue;
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public static boolean ExamineIsMDLSDF(FileInputStream istr) {
        boolean ret = false;
        try {
            long lastpos = istr.getChannel().position();
            BufferedReader rdr = new BufferedReader(new InputStreamReader(istr));
            ret = DataSheetStream.ExamineIsMDLSDF(rdr);
            istr.getChannel().position(lastpos);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ret;
    }

    public static boolean ExamineIsMDLSDF(BufferedReader rdr) {
        try {
            String str;
            for (int n = 0; n < 3000 && (str = rdr.readLine()) != null; ++n) {
                if (str.compareTo("$$$$") != 0 && str.compareTo("M  END") != 0) continue;
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public static DataSheet ReadXML(InputStream istr) throws IOException {
        return DataSheetStream.ReadXML(new BufferedReader(new InputStreamReader(istr)));
    }

    public static DataSheet ReadXML(BufferedReader in) throws IOException {
        int n;
        TrivialDOM xml = TrivialDOM.ReadXML(in);
        if (xml.Document().NodeName().compareTo("DataSheet") != 0) {
            throw new IOException("Input stream is XML, but the root node is not <DataSheet>.");
        }
        DataSheet ds = new DataSheet();
        TrivialDOM.Node doc = xml.Document();
        TrivialDOM.Node header = null;
        TrivialDOM.Node content = null;
        for (int n2 = 0; n2 < doc.NumChildren(); ++n2) {
            if (doc.ChildType(n2) != 1) continue;
            TrivialDOM.Node node = doc.GetChildNode(n2);
            if (node.NodeName().compareTo("Header") == 0) {
                header = node;
            }
            if (node.NodeName().compareTo("Content") != 0) continue;
            content = node;
        }
        if (header == null) {
            throw new IOException("XML document lacks a <Header> element.");
        }
        if (content == null) {
            throw new IOException("XML document lacks a <Content> element.");
        }
        int ncols = Utils.safeInt(header.Attribute("ncols"), -1);
        int nrows = Utils.safeInt(header.Attribute("nrows"), -1);
        if (ncols < 0 || ncols > 5000) {
            throw new IOException("Header@ncols attribute absent or improperly specified.");
        }
        if (nrows < 0) {
            throw new IOException("Header@nrows attribute absent or improperly specified.");
        }
        String[] colName = new String[ncols];
        String[] colDescr = new String[ncols];
        int[] colType = new int[ncols];
        for (n = 0; n < ncols; ++n) {
            colName[n] = null;
        }
        for (n = 0; n < header.NumChildren(); ++n) {
            TrivialDOM.Node node;
            if (header.ChildType(n) != 1 || (node = header.GetChildNode(n)).NodeName().compareTo("Column") != 0) continue;
            int id = Utils.safeInt(node.Attribute("id"), 0);
            if (id < 1 || id > ncols) {
                throw new IOException("Column@id out of range.");
            }
            String strName = node.Attribute("name");
            String strType = node.Attribute("type");
            if (strName == null) {
                throw new IOException("Column name not specified.");
            }
            if (strType == null) {
                throw new IOException("Column type not specified.");
            }
            int type = 0;
            if (strType.compareTo("molecule") == 0) {
                type = 1;
            } else if (strType.compareTo("string") == 0) {
                type = 2;
            } else if (strType.compareTo("integer") == 0) {
                type = 3;
            } else if (strType.compareTo("real") == 0) {
                type = 4;
            } else if (strType.compareTo("boolean") == 0) {
                type = 5;
            } else {
                throw new IOException("Coltype type [" + strType + "] not recognised.");
            }
            colName[id - 1] = strName;
            colType[id - 1] = type;
            colDescr[id - 1] = node.GetText();
        }
        for (n = 0; n < ncols; ++n) {
            if (colName[n] != null) continue;
            throw new IOException("Column id#" + (n + 1) + " is not defined.");
        }
        for (n = 0; n < ncols; ++n) {
            ds.AppendColumn(colName[n], colType[n], colDescr[n]);
        }
        for (n = 0; n < nrows; ++n) {
            ds.AppendRow();
        }
        for (int i = 0; i < content.NumChildren(); ++i) {
            TrivialDOM.Node row;
            if (content.ChildType(i) != 1 || (row = content.GetChildNode(i)).NodeName().compareTo("Row") != 0) continue;
            int rid = Utils.safeInt(row.Attribute("id"), 0);
            if (rid < 1 || rid > nrows) {
                throw new IOException("Row@id out of range.");
            }
            for (int j = 0; j < row.NumChildren(); ++j) {
                TrivialDOM.Node cell;
                if (row.ChildType(j) != 1 || (cell = row.GetChildNode(j)).NodeName().compareTo("Cell") != 0) continue;
                int cid = Utils.safeInt(cell.Attribute("id"), 0);
                if (cid < 1 || cid > ncols) {
                    throw new IOException("Cell@id out of range.");
                }
                String data = cell.GetText();
                int type = colType[cid - 1];
                if (type == 1) {
                    Molecule mol = null;
                    try {
                        mol = MoleculeStream.ReadUnknown(new BufferedReader(new StringReader(data)));
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    ds.SetMolecule(rid - 1, cid - 1, mol);
                    continue;
                }
                if (type == 2) {
                    ds.SetString(rid - 1, cid - 1, data);
                    continue;
                }
                if (type == 3) {
                    try {
                        int v = new Integer(data);
                        ds.SetInteger(rid - 1, cid - 1, v);
                    }
                    catch (NumberFormatException e) {
                        ds.SetToNull(rid - 1, cid - 1);
                    }
                    continue;
                }
                if (type == 4) {
                    try {
                        double v = new Double(data);
                        ds.SetReal(rid - 1, cid - 1, v);
                    }
                    catch (NumberFormatException e) {
                        ds.SetToNull(rid - 1, cid - 1);
                    }
                    continue;
                }
                if (type != 5) continue;
                ds.SetBoolean(rid - 1, cid - 1, data.toLowerCase().compareTo("true") == 0);
            }
        }
        return ds;
    }

    public static DataSheet ReadSDF(InputStream istr) throws IOException {
        return DataSheetStream.ReadSDF(new BufferedReader(new InputStreamReader(istr)));
    }

    public static DataSheet ReadSDF(BufferedReader in) throws IOException {
        String line;
        DataSheet ds = new DataSheet();
        ds.AppendColumn("mol", 1, "Molecule");
        ArrayList<String> entry = new ArrayList<String>();
        while ((line = in.readLine()) != null) {
            int pos;
            if (!line.startsWith("$$$$")) {
                entry.add(line);
                continue;
            }
            int rn = ds.AppendRow();
            StringBuffer sb = new StringBuffer();
            for (pos = 0; pos < entry.size() && !(line = (String)entry.get(pos)).startsWith("> "); ++pos) {
                sb.append(line + "\n");
                if (!line.startsWith("M  END")) continue;
            }
            Molecule mol = null;
            try {
                mol = MoleculeStream.ReadMDLMOL(new BufferedReader(new StringReader(sb.toString())));
            }
            catch (IOException e) {
                // empty catch block
            }
            if (mol != null) {
                ds.SetMolecule(rn, 0, mol);
            }
            while (pos + 2 < entry.size()) {
                int z;
                String key = (String)entry.get(pos);
                String val = (String)entry.get(pos + 1);
                if (key.startsWith(">") && (z = key.indexOf("<")) >= 0 && (z = (key = key.substring(z + 1)).indexOf(">")) >= 0 && (key = key.substring(0, z)).length() != 0) {
                    int type = val.length() > 0 ? 2 : 3;
                    double dval = 0.0;
                    int ival = 0;
                    try {
                        dval = Double.parseDouble(val);
                        ival = (int)Math.round(dval);
                        type = dval == (double)ival ? 3 : 4;
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    int cn = -1;
                    for (int n = 0; n < ds.NumCols(); ++n) {
                        if (ds.ColName(n).compareTo(key) != 0) continue;
                        cn = n;
                        break;
                    }
                    if (cn < 0) {
                        cn = ds.AppendColumn(key, type, "");
                    }
                    int curType = ds.ColType(cn);
                    if (val.length() == 0) {
                        ds.SetToNull(rn, cn);
                    } else if (curType == 2) {
                        ds.SetString(rn, cn, val);
                    } else if (curType == 4) {
                        if (type == 2) {
                            if (ds.ChangeColumnType(cn, 2, false)) {
                                ds.SetString(rn, cn, val);
                            }
                        } else {
                            ds.SetReal(rn, cn, dval);
                        }
                    } else if (curType == 3) {
                        if (type == 2) {
                            if (ds.ChangeColumnType(cn, 2, false)) {
                                ds.SetString(rn, cn, val);
                            }
                        } else if (type == 4) {
                            if (ds.ChangeColumnType(cn, 4, false)) {
                                ds.SetReal(rn, cn, dval);
                            }
                        } else {
                            ds.SetInteger(rn, cn, ival);
                        }
                    }
                }
                pos += 3;
            }
            entry.clear();
        }
        return ds;
    }

    public static void WriteXML(OutputStream ostr, DataSheet ds) throws IOException {
        DataSheetStream.WriteXML(new BufferedWriter(new OutputStreamWriter(ostr)), ds);
    }

    public static void WriteXML(BufferedWriter out, DataSheet ds) throws IOException {
        TrivialDOM xml = new TrivialDOM("DataSheet");
        int ncols = ds.NumCols();
        int nrows = ds.NumRows();
        TrivialDOM.Node header = xml.Document().AppendNode("Header");
        header.SetAttribute("ncols", ds.NumCols() + "");
        header.SetAttribute("nrows", ds.NumRows() + "");
        for (int n = 0; n < ncols; ++n) {
            TrivialDOM.Node col = header.AppendNode("Column");
            col.SetAttribute("id", String.valueOf(n + 1));
            col.SetAttribute("name", ds.ColName(n));
            int type = ds.ColType(n);
            if (type == 1) {
                col.SetAttribute("type", "molecule");
            } else if (type == 2) {
                col.SetAttribute("type", "string");
            } else if (type == 3) {
                col.SetAttribute("type", "integer");
            } else if (type == 4) {
                col.SetAttribute("type", "real");
            } else if (type == 5) {
                col.SetAttribute("type", "boolean");
            }
            col.SetText(ds.ColDescr(n), false);
        }
        TrivialDOM.Node content = xml.Document().AppendNode("Content");
        for (int i = 0; i < nrows; ++i) {
            TrivialDOM.Node row = content.AppendNode("Row");
            row.SetAttribute("id", String.valueOf(i + 1));
            for (int j = 0; j < ncols; ++j) {
                TrivialDOM.Node col = row.AppendNode("Cell");
                col.SetAttribute("id", String.valueOf(j + 1));
                int type = ds.ColType(j);
                if (ds.IsNull(i, j)) continue;
                if (type == 1) {
                    try {
                        StringWriter sw = new StringWriter();
                        BufferedWriter bw = new BufferedWriter(sw);
                        MoleculeStream.WriteNative(bw, ds.GetMolecule(i, j));
                        col.SetText(sw.toString(), true);
                    }
                    catch (IOException e) {}
                    continue;
                }
                if (type == 2) {
                    col.SetText(ds.GetString(i, j), true);
                    continue;
                }
                if (type == 3) {
                    col.SetText(String.valueOf(ds.GetInteger(i, j)), false);
                    continue;
                }
                if (type == 4) {
                    col.SetText(String.valueOf(ds.GetReal(i, j)), false);
                    continue;
                }
                if (type != 5) continue;
                col.SetText(ds.GetBoolean(i, j) ? "true" : "false", false);
            }
        }
        TrivialDOM.WriteXML(out, xml);
    }

    public static void WriteSDF(OutputStream ostr, DataSheet ds) throws IOException {
        DataSheetStream.WriteSDF(new BufferedWriter(new OutputStreamWriter(ostr)), ds);
    }

    public static void WriteSDF(BufferedWriter out, DataSheet ds) throws IOException {
        int molfld = -1;
        for (int n = 0; n < ds.NumCols(); ++n) {
            if (ds.ColType(n) != 1) continue;
            molfld = n;
            break;
        }
        for (int i = 0; i < ds.NumRows(); ++i) {
            if (molfld >= 0 && !ds.IsNull(i, molfld)) {
                MoleculeStream.WriteMDLMOL(out, ds.GetMolecule(i, molfld));
            }
            for (int j = 0; j < ds.NumCols(); ++j) {
                int n;
                if (ds.ColType(j) == 1 || ds.IsNull(i, j)) continue;
                String line = "";
                if (ds.ColType(j) == 2) {
                    line = ds.GetString(i, j);
                } else if (ds.ColType(j) == 3) {
                    line = String.valueOf(ds.GetInteger(i, j));
                } else if (ds.ColType(j) == 4) {
                    line = String.valueOf(ds.GetReal(i, j));
                } else if (ds.ColType(j) == 5) {
                    String string = line = ds.GetBoolean(i, j) ? "true" : "false";
                }
                if (line.length() == 0) continue;
                String[] bits = line.split("\n");
                boolean anything = false;
                for (n = 0; n < bits.length; ++n) {
                    if (bits[n].length() <= 0) continue;
                    anything = true;
                }
                if (!anything) continue;
                out.write("> <" + ds.ColName(j) + ">\n");
                for (n = 0; n < bits.length; ++n) {
                    if (bits[n].length() <= 0) continue;
                    if (bits[n].length() > 78) {
                        bits[n] = bits[n].substring(0, 78);
                    }
                    out.write(bits[n] + "\n");
                }
                out.write("\n");
            }
            out.write("$$$$\n");
        }
        out.flush();
    }
}

