/* 
 * tkAppInit.c --
 *
 *	Provides a default version of the Tcl_AppInit procedure for
 *	use in wish and similar Tk-based applications.
 *
 * Copyright (c) 1993 The Regents of the University of California.
 * Copyright (c) 1994 Sun Microsystems, Inc.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * RCS: @(#) $Id: init.c,v 1.3 2001/07/13 18:32:47 mpilka Exp $
 */

#include "tk.h"
#include "itcl.h"
#include "itk.h"

/*
 * The following variable is a special hack that is needed in order for
 * Sun shared libraries to be used for Tcl.
 */

extern int matherr();
int *tclDummyMathPtr = (int *) matherr;

/*
 *----------------------------------------------------------------------
 *
 * main --
 *
 *	This is the main program for the application.
 *
 * Results:
 *	None: Tk_Main never returns here, so this procedure never
 *	returns either.
 *
 * Side effects:
 *	Whatever the application does.
 *
 *----------------------------------------------------------------------
 */


//int
//main(argc, argv)
//    int argc;			/* Number of command-line arguments. */
//    char **argv;		/* Values of command-line arguments. */
//{
//    Tk_Main(argc, argv, Tcl_AppInit);
//    return 0;			/* Needed only to prevent compiler warning. */
//}

/*
 *----------------------------------------------------------------------
 *
 * Tcl_AppInit --
 *
 *	This procedure performs application-specific initialization.
 *	Most applications, especially those that incorporate additional
 *	packages, will have their own version of this procedure.
 *
 * Results:
 *	Returns a standard Tcl completion code, and leaves an error
 *	message in interp->result if an error occurs.
 *
 * Side effects:
 *	Depends on the startup script.
 *
 *----------------------------------------------------------------------
 */

int
Et_AppInit(interp)
    Tcl_Interp *interp;		/* Interpreter for application. */
{
    /* Already done in mktclapp Et_Init() proc
    if (Tcl_Init(interp) == TCL_ERROR) {
	return TCL_ERROR;
    }
    if (Tk_Init(interp) == TCL_ERROR) {
	return TCL_ERROR;
    }
    Tcl_StaticPackage(interp, "Tk", Tk_Init, Tk_SafeInit);
    */

    if (Itcl_Init(interp) == TCL_ERROR) {
	fprintf(stderr,"Et_AppInit(): Itcl initialization error.\n");
	return TCL_ERROR;
    }
    Tcl_StaticPackage(interp, "Itcl", Itcl_Init, Itcl_SafeInit);
		    
    if (Itk_Init(interp) == TCL_ERROR) {
	fprintf(stderr,"Et_AppInit(): Itk initialization error.\n");
	return TCL_ERROR;
    }
    Tcl_StaticPackage(interp, "Itk", Itk_Init, (Tcl_PackageInitProc *)NULL);
					
    return TCL_OK;
}
