/*
 * cpu_cygwin.c - module to get cpu usage, for Cygwin
 *
 * Copyright (c) 2001 Seiichi SATO <ssato@sh.rim.or.jp>
 *
 * licensed under the GPL
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include "cpu.h"

#include <w32api/windows.h>
#include <w32api/windef.h>
#include <w32api/winreg.h>

HKEY hkey;
DWORD dwType = REG_DWORD;
DWORD dwDust;
DWORD dw = 4;

void cpu_init(void)
{
    LONG ret;

    ret = RegOpenKeyEx(HKEY_DYN_DATA, "PerfStats\\StartStat", 0, KEY_READ, &hkey);
    if (!ret) {
	ret = RegQueryValueEx(hkey, "KERNEL\\CPUUsage", 0, &dwType,
			      (unsigned char *) &dwDust, &dw);
	ret = RegCloseKey(hkey);
    }

    if (ret)
	exit(1);

}

/* returns current CPU usage in percent */
int cpu_get_usage(struct cpu_options *opts)
{
    int result = 0;

    RegOpenKeyEx(HKEY_DYN_DATA, "PerfStats\\StatData", 0, KEY_READ, &hkey);
    RegQueryValueEx(hkey, "KERNEL\\CPUUsage", 0, &dwType,
		    (unsigned char *) &result, &dw);
    RegCloseKey(hkey);

    return result;
}
