#!/usr/bin/python


try:
  import os, sys
  if os.path.exists('/usr/lib/woody'):
    sys.path.append('/usr/lib/woody')
  from woody_defs import *
  import woody_tree
except IOError, msg:
  print "%s: Fatal Error loading program modules: %s" % (__name__, msg)
  sys.exit(1)
except ImportError, msg:
  print "%s: Fatal Error loading program modules: %s" % (__name__, msg)
  sys.exit(1)


wood = None
parent = None

def to_bool(str, default=None):
  if str == "yes"  or  str == "true":
    str = 1
  elif str == "no"  or  str == "false":
    str = None
  elif type(str) != type(1):
    try:
      str = int(str)
      if str == 0:
        str = None
    except:
      str = default
  return str

def to_int(str, default=0):
  if str == "yes"  or  str == "true":
    str = 1
  elif str == "no"  or  str == "false":
    str = 0
  elif type(str) != type(1):
    try:
      str = int(str)
    except:
      str = default
  return str

def to_float(str, default=0.0):
  if str == "yes"  or  str == "true":
    str = 1.0
  elif str == "no"  or  str == "false":
    str = 0.0
  elif type(str) != type(1.0):
    try:
      str = float(str)
    except:
      str = default
  return str



def text_save(wood, file):
  # stuff to save, in order:
  # - xml header
  # - outline tag
  # - options tag
  # - nodes
  # - outline close tag

  # TODO: save creation and mod dates, too...
  wood.edit_count = wood.edit_count + 1
  num_nodes = wood.len()
  if wood.children.text:
    title = wood.children.text
  else:
    title = "<Untitled>"
  str = '%s (%s items)\n%s\n\n' % \
        (title,
         num_nodes,
         "-" * len(title))
  file.write(str)
  
  # TODO: save the nodes...
  write_node(wood, wood.children, file, 0)
  
  str = '\n---=== end %s ===---\n' % title
  file.write(str)


def write_node(wood, branch, file, depth):
  #print "write_node(%s, %s, %s)" % \
  #      (wood.children.text, branch.text, depth)

  if depth == 0:
    for child in branch.children:
      write_node(wood, child, file, depth+1)
    return

  if branch.todo  and  branch.done >= 1  and not wood.options.show_done_items:
    return

  str = woody_tree.node_to_str(wood, branch, depth-1, wid=76)
  str = str + "\n"
  file.write(str)
  if branch.expanded:
    for child in branch.children:
      write_node(wood, child, file, depth+1)



def save(wood, filename=None):
  err = 0

  if not filename:
    filename = wood.filename + ".txt"
  if filename[-4:] != ".txt":
    filename = filename + ".txt"

  try:
    file = open(filename, "w")
    text_save(wood, file)
    file.close()
  except IOError, msg:
    print "Cannot save %s: IOError: %s" % (filename, msg)
    err = -1

  return err

