/* startprogop.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001-2008 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef STARTPROGOP_H
#define STARTPROGOP_H

#include "wdefines.h"
#include "functionproto.h"
#include <aguix/awindow.h>
#include <aguix/text.h>
#include <aguix/solidbutton.h>
#include <aguix/button.h>
#include <aguix/cyclebutton.h>
#include <aguix/stringgadget.h>
#include "wconfig.h"

class StartProgOp:public FunctionProto
{
public:
  StartProgOp();
  virtual ~StartProgOp();
  StartProgOp( const StartProgOp &other );
  StartProgOp &operator=( const StartProgOp &other );

  virtual StartProgOp *duplicate() const;
  virtual bool isName(const char *);
  virtual const char *getName();
#if ! ( defined ( __GNUC__ ) && ( __GNUC__ < 3 ) )
  using FunctionProto::run;
#endif
  int run( WPUContext *wpu, ActionMessage* );
  virtual bool save(Datei*);
  virtual const char *getDescription();
  virtual int configure();
  
  int doconfigure();

  typedef enum {STARTPROGOP_START_NORMAL=0,
                STARTPROGOP_START_IN_TERMINAL,
                STARTPROGOP_START_IN_TERMINAL_AND_WAIT4KEY,
                STARTPROGOP_SHOW_OUTPUT} startprogstart_t;
  void setStart(startprogstart_t);
  void setGlobal(bool);
  void setRequestFlags(bool);
  void setInBackground( bool );
  void setViewStr( std::string );
  void setDontCD( bool );
  void setGUIMsg( std::string msg );
protected:
  static const char *name;
  // Infos to save

  startprogstart_t startprogstart;

  std::string view_str;
  bool global;
  bool inbackground;
  bool dontcd;
  
  // temp variables
  Lister *startlister,*endlister;
  
  int normalmodestartprog( ActionMessage *am );

  class SettingsWidgets
  {
  public:
    SettingsWidgets( class StringGadget *sg,
		     class CycleButton *cyb,
		     class ChooseButton *gcb,
		     class ChooseButton *ibcb,
		     class ChooseButton *dcdcb );
    SettingsWidgets( const SettingsWidgets &other );
    SettingsWidgets &operator=( const SettingsWidgets &other );
    int validate();
    class StringGadget *_sg;
    class CycleButton *_cyb;
    class ChooseButton *_gcb;
    class ChooseButton *_ibcb;
    class ChooseButton *_dcdcb;
  };
  std::auto_ptr< SettingsWidgets > buildW( AWindow *win );

  class FiletypeWindow
  {
  public:
    FiletypeWindow( class FieldListView *lv, FlatTypeList *flatlist );
    ~FiletypeWindow();
    FiletypeWindow( const FiletypeWindow &other );
    FiletypeWindow &operator=( const FiletypeWindow &other );
    class FieldListView *_lv;
    FlatTypeList *_flatlist;
  };
  std::auto_ptr< FiletypeWindow > buildFTWindow( AWindow *win );

  class ArchiveWindow
  {
  public:
    ArchiveWindow( class FieldListView *lv, class StringGadget *sg );
    ArchiveWindow( const ArchiveWindow &other );
    ArchiveWindow &operator=( const ArchiveWindow &other );
    class FieldListView *_lv;
    class StringGadget *_sg;
    std::vector<std::string> _arclist;
  };
  std::auto_ptr< ArchiveWindow > buildArcWindow( AWindow *win );

  class StartSettings
  {
  public:
    StartSettings();
    StartSettings( const StartSettings &other );
    StartSettings &operator=( const StartSettings &other );
    enum StartModes { CANCEL, STARTPROG, HANDLE_TYPE, HANDLE_ARCHIVE } _startmode;
    std::string _command;
    class WCFiletype *_type;
    std::string _archive;

    startprogstart_t _start;
    std::string _view_str;
    bool _global;
    bool _inbackground;
    bool _dontcd;
  };
  std::auto_ptr< StartSettings > showGUI();
  std::string default_file;
  
  std::string gui_msg;
};

#endif
