/* text.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: text.h,v 1.4 2001/11/03 17:15:58 ralf Exp $ */

#ifndef TEXT_H
#define TEXT_H

#include "aguixdefs.h"
#include "guielement.h"

class Text:public GUIElement {
public:
  Text(class AGUIX *aguix);
  Text(class AGUIX *aguix,int x,int y,const char *text,int color);
  virtual ~Text();
  const char *getText();
  void setText(const char *);
  int getColor();
  void setColor(int color);
  virtual void redraw();
  virtual void flush();
  virtual bool handleMessage(XEvent *E,Message *msg);
  int setFont(char*);
  virtual const char *getType();
  virtual bool isType(const char *type);
private:
  char *text;
  int color;
  bool bgset;
  class AGUIXFont *font;
  static const char *type;
};

#endif
