/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.office;

public final class MIMETypes {
    public static final String WRITER = "application/vnd.sun.xml.writer";
    public static final String CALC = "application/vnd.sun.xml.calc";
    public static final String IMPRESS = "application/vnd.sun.xml.impress";
    public static final String DRAW = "application/vnd.sun.xml.draw";
    public static final String CHART = "application/vnd.sun.xml.chart";
    public static final String MATH = "application/vnd.sun.xml.math";
    public static final String ODT = "application/vnd.oasis.opendocument.text";
    public static final String ODS = "application/vnd.oasis.opendocument.spreadsheet";
    public static final String ODP = "application/vnd.oasis.opendocument.presentation";
    public static final String ODF = "application/vnd.oasis.opendocument.formula";
    public static final String PNG = "image/png";
    public static final String JPEG = "image/jpeg";
    public static final String GIF = "image/gif";
    public static final String TIFF = "image/tiff";
    public static final String BMP = "image/bmp";
    public static final String WMF = "image/x-wmf";
    public static final String EPS = "image/x-eps";
    public static final String SVM = "image/x-svm";
    public static final String ZIP = "application/zip";
    public static final String XHTML = "text/html";
    public static final String XHTML_MATHML = "application/xhtml+xml";
    public static final String XHTML_MATHML_XSL = "application/xml";
    public static final String LATEX = "application/x-latex";
    public static final String BIBTEX = "application/x-bibtex";
    public static final String TEXT = "text";
    public static final byte[] PNG_SIG;
    public static final byte[] JPEG_SIG;
    public static final byte[] GIF87_SIG;
    public static final byte[] GIF89_SIG;
    public static final byte[] TIFF_SIG;
    public static final byte[] BMP_SIG;
    public static final byte[] WMF_SIG;
    public static final byte[] WMF30_SIG;
    public static final byte[] EPS_SIG;
    public static final byte[] SVM_SIG;
    public static final byte[] ZIP_SIG;
    public static final String LATEX_EXT = ".tex";
    public static final String BIBTEX_EXT = ".bib";
    public static final String XHTML_EXT = ".html";
    public static final String XHTML_MATHML_EXT = ".xhtml";
    public static final String XHTML_MATHML_XSL_EXT = ".xml";
    public static final String PNG_EXT = ".png";
    public static final String JPEG_EXT = ".jpg";
    public static final String GIF_EXT = ".gif";
    public static final String TIFF_EXT = ".tif";
    public static final String BMP_EXT = ".bmp";
    public static final String WMF_EXT = ".wmf";
    public static final String EPS_EXT = ".eps";
    public static final String SVM_EXT = ".svm";

    private static final boolean isType(byte[] blob, byte[] sig) {
        int n = sig.length;
        int i = 0;
        while (i < n) {
            if (blob[i] != sig[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final String getMagicMIMEType(byte[] blob) {
        if (MIMETypes.isType(blob, PNG_SIG)) {
            return PNG;
        }
        if (MIMETypes.isType(blob, JPEG_SIG)) {
            return JPEG;
        }
        if (MIMETypes.isType(blob, GIF87_SIG)) {
            return GIF;
        }
        if (MIMETypes.isType(blob, GIF89_SIG)) {
            return GIF;
        }
        if (MIMETypes.isType(blob, TIFF_SIG)) {
            return TIFF;
        }
        if (MIMETypes.isType(blob, BMP_SIG)) {
            return BMP;
        }
        if (MIMETypes.isType(blob, WMF_SIG)) {
            return WMF;
        }
        if (MIMETypes.isType(blob, WMF30_SIG)) {
            return WMF;
        }
        if (MIMETypes.isType(blob, EPS_SIG)) {
            return EPS;
        }
        if (MIMETypes.isType(blob, SVM_SIG)) {
            return SVM;
        }
        if (MIMETypes.isType(blob, ZIP_SIG)) {
            return ZIP;
        }
        return "";
    }

    public static final String getFileExtension(String sMIME) {
        if (PNG.equals(sMIME)) {
            return PNG_EXT;
        }
        if (JPEG.equals(sMIME)) {
            return JPEG_EXT;
        }
        if (GIF.equals(sMIME)) {
            return GIF_EXT;
        }
        if (TIFF.equals(sMIME)) {
            return TIFF_EXT;
        }
        if (BMP.equals(sMIME)) {
            return BMP_EXT;
        }
        if (WMF.equals(sMIME)) {
            return WMF_EXT;
        }
        if (EPS.equals(sMIME)) {
            return EPS_EXT;
        }
        if (SVM.equals(sMIME)) {
            return SVM_EXT;
        }
        if (LATEX.equals(sMIME)) {
            return LATEX_EXT;
        }
        if (BIBTEX.equals(sMIME)) {
            return BIBTEX_EXT;
        }
        if (XHTML.equals(sMIME)) {
            return XHTML_EXT;
        }
        if (XHTML_MATHML.equals(sMIME)) {
            return XHTML_MATHML_EXT;
        }
        if (XHTML_MATHML_XSL.equals(sMIME)) {
            return XHTML_MATHML_XSL_EXT;
        }
        return "";
    }

    static {
        WRITER = WRITER;
        CALC = CALC;
        IMPRESS = IMPRESS;
        DRAW = DRAW;
        CHART = CHART;
        MATH = MATH;
        ODT = ODT;
        ODS = ODS;
        ODP = ODP;
        ODF = ODF;
        PNG = PNG;
        JPEG = JPEG;
        GIF = GIF;
        TIFF = TIFF;
        BMP = BMP;
        WMF = WMF;
        EPS = EPS;
        SVM = SVM;
        ZIP = ZIP;
        XHTML = XHTML;
        XHTML_MATHML = XHTML_MATHML;
        XHTML_MATHML_XSL = XHTML_MATHML_XSL;
        LATEX = LATEX;
        BIBTEX = BIBTEX;
        TEXT = TEXT;
        PNG_SIG = new byte[]{-119, 80, 78, 71};
        JPEG_SIG = new byte[]{-1, -40, -1, -32};
        GIF87_SIG = new byte[]{71, 73, 70, 56, 55, 97};
        GIF89_SIG = new byte[]{71, 73, 70, 56, 57, 97};
        TIFF_SIG = new byte[]{73, 73, 42};
        BMP_SIG = new byte[]{66, 77};
        WMF_SIG = new byte[]{-41, -51, -58, -102};
        WMF30_SIG = new byte[]{1, 0, 9, 0};
        EPS_SIG = new byte[]{37, 33};
        SVM_SIG = new byte[]{86, 67, 76, 77, 84, 70};
        ZIP_SIG = new byte[]{80, 75, 3, 4};
        LATEX_EXT = LATEX_EXT;
        BIBTEX_EXT = BIBTEX_EXT;
        XHTML_EXT = XHTML_EXT;
        XHTML_MATHML_EXT = XHTML_MATHML_EXT;
        XHTML_MATHML_XSL_EXT = XHTML_MATHML_XSL_EXT;
        PNG_EXT = PNG_EXT;
        JPEG_EXT = JPEG_EXT;
        GIF_EXT = GIF_EXT;
        TIFF_EXT = TIFF_EXT;
        BMP_EXT = BMP_EXT;
        WMF_EXT = WMF_EXT;
        EPS_EXT = EPS_EXT;
        SVM_EXT = SVM_EXT;
    }
}

