/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.util;

import java.io.IOException;
import java.io.InputStream;
import writer2latex.api.Converter;
import writer2latex.api.ConverterResult;
import writer2latex.api.GraphicConverter;
import writer2latex.api.OutputFile;
import writer2latex.office.ImageLoader;
import writer2latex.office.MetaData;
import writer2latex.office.OfficeReader;
import writer2latex.util.Config;
import writer2latex.xmerge.ConvertData;
import writer2latex.xmerge.EmbeddedObject;
import writer2latex.xmerge.OfficeDocument;

public abstract class ConverterBase
implements Converter {
    protected Config config = new Config();
    protected GraphicConverter graphicConverter = null;
    protected OfficeDocument odDoc;
    protected OfficeReader ofr;
    protected MetaData metaData;
    protected ImageLoader imageLoader;
    protected String sTargetFileName;
    protected ConvertData convertData = new ConvertData();

    public void setConfig(Config config) {
        this.config = config;
    }

    public void setGraphicConverter(GraphicConverter graphicConverter) {
        this.graphicConverter = graphicConverter;
    }

    public void readTemplate(InputStream is) throws IOException {
    }

    public ConverterResult convert(InputStream is, String sTargetFileName) throws IOException {
        this.odDoc = new OfficeDocument("InFile");
        this.odDoc.read(is);
        this.ofr = new OfficeReader(this.odDoc, false);
        this.metaData = new MetaData(this.odDoc);
        this.imageLoader = new ImageLoader(this.odDoc, sTargetFileName, true);
        this.imageLoader.setGraphicConverter(this.graphicConverter);
        this.sTargetFileName = sTargetFileName;
        this.convertData.reset();
        this.convertInner();
        return this.convertData;
    }

    public abstract void convertInner() throws IOException;

    public MetaData getMetaData() {
        return this.metaData;
    }

    public ImageLoader getImageLoader() {
        return this.imageLoader;
    }

    public void addDocument(OutputFile doc) {
        this.convertData.addDocument(doc);
    }

    public EmbeddedObject getEmbeddedObject(String sHref) {
        return this.odDoc.getEmbeddedObject(sHref);
    }
}

