;;; x-symbol-macs.el --- macros used when compiling or interpreting x-symbol.el

;; Copyright (C) 1998-1999 Free Software Foundation, Inc.
;;
;; Author: Christoph Wedler <wedler@fmi.uni-passau.de>
;; Maintainer: (Please use `M-x x-symbol-package-bug' to contact the maintainer)
;; Version: $Id: x-symbol-macs.el,v 3.3 1999/01/18 14:15:59 wedler Exp d029492 $
;; Keywords: WYSIWYG, LaTeX, HTML, wp, math, internationalization
;; X-URL: http://www.fmi.uni-passau.de/~wedler/x-symbol/

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.
;;
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with this program; if not, write to the Free Software
;; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

;;; Commentary:

;; If you want to use package x-symbol, please visit the URL (use
;; \\[x-symbol-package-web]) and read the info (use \\[x-symbol-package-info]).

;;; Code:

(provide 'x-symbol-macs)
(require 'cl)


;;;===========================================================================
;;;  Function used by macros and the macros
;;;===========================================================================

(defun x-symbol-set/push-assq/assoc (x key alist pushp test)
  (let* ((temp (gensym "--x-symbol-set/push-assq/assoc-temp--"))
	 (evalp (and (consp key) (null (eq (car key) 'quote))))
	 (keysymb (if evalp
		      (gensym "--x-symbol-set/push-assq/assoc-temp--")
		    key))
	 (keydef (and evalp (list (list keysymb key)))))
    `(let* (,@keydef
	    (,temp (,test ,keysymb ,alist)))
       (if ,temp
	   (setcdr ,temp ,(if pushp `(cons ,x (cdr ,temp)) x))
	 (setq ,alist (cons (,(if pushp 'list 'cons) ,keysymb ,x) ,alist)))
       ,temp)))

(defmacro x-symbol-set-assq (x key alist)
  "Set X to be the association for KEY in ALIST.
If no car of an element in ALIST is `eq' to KEY, inserts (KEY . X) at
the head of ALIST."
  (x-symbol-set/push-assq/assoc x key alist nil 'assq))

(defmacro x-symbol-set-assoc (x key alist)
  "Set X to be the association for KEY in ALIST.
If no car of an element in ALIST is `equal' to KEY, inserts (KEY . X) at
the head of ALIST."
  (x-symbol-set/push-assq/assoc x key alist nil 'assoc))

(defmacro x-symbol-push-assq (x key alist)
  "Insert X at the head of the association for KEY in ALIST.
If no car of an element in ALIST is `eq' to KEY, inserts (KEY X) at the
head of ALIST.  An element (KEY A B) would look like (KEY X A B) after
the operation."
  (x-symbol-set/push-assq/assoc x key alist t 'assq))

(defmacro x-symbol-push-assoc (x key alist)
  "Insert X at the head of the association for KEY in ALIST.
If no car of an element in ALIST is `equal' to KEY, inserts (KEY X) at
the head of ALIST.  An element (KEY A B) would look like (KEY X A B)
after the operation."
  (x-symbol-set/push-assq/assoc x key alist t 'assoc))


;;;===========================================================================
;;;  Macros
;;;===========================================================================

(defmacro x-symbol-dolist-delaying (spec cond &rest body)
  ;; checkdoc-params: (spec)
  "Loop over a list delaying elements if condition yields non-nil.
The macro looks like
  (x-symbol-dolist-delaying (VAR LIST [WORKING [DELAYED]]) COND BODY...)
Bind VAR to each `car' from LIST, in turn.  If COND yields nil, evaluate
BODY.  Otherwise, BODY with VAR bound to the list value is evaluated
after all other list values have been processed.  Return all list
values which could not been processed.

The looping is done in cycles.  In each cycle, the value of WORKING,
which defaults to some internal symbol, is the list of elements still to
be processed during the current cycle.  VAR is always the head of
WORKING.  If COND yields non-nil, VAR is inserted at the head of the
list stored in DELAYED which defaults to some internal symbol.  At the
end of each CYCLE, WORKING is set to the reversed value of DELAYED.  The
macro ends if all elements has been processed or all elements in a cycle
has been inserted into the delayed list."
  (let ((working (or (nth 2 spec)
		     (gensym "--x-symbol-dolist-delaying-temp--")))
	(delayed (or (nth 3 spec)
		     (gensym "--x-symbol-dolist-delaying-temp--")))
	(non-circ (gensym "--x-symbol-dolist-delaying-temp--")))
    `(block nil
       (let ((,working ,(nth 1 spec))
	     (,non-circ t)
	     ,delayed
	     ,(car spec))
	 (while (and ,working ,non-circ)
	   (setq ,delayed nil
		 ,non-circ nil)
	   (while ,working
	     (setq ,(car spec) (car ,working))
	     (if ,cond
		 (setq ,delayed (cons ,(car spec) ,delayed))
	       ,@body
	       (setq ,non-circ t))
	     (setq ,working (cdr ,working)))
	   (setq ,working (nreverse ,delayed)))
	 ,working))))

(defmacro x-symbol-do-plist (spec &rest body)
  ;; checkdoc-params: (spec)
  "Loop over a property list.
The macro looks like
  (x-symbol-do-plist (PROP VAR PLIST) BODY...)
Evaluate BODY with each PROP bound to each property of PLIST and VAR
bound to the corresponding value, in turn.  PROP and VAR can also be nil
if their value is not important.  Return nil."
  (let ((plist (gensym "--x-symbol-do-plist-temp--")))
    `(block nil
       (let ((,plist ,(nth 2 spec))
	     ,@(and (car spec) (list (car spec)))
	     ,@(and (nth 1 spec) (list (nth 1 spec))))
	 (while ,plist
	   (setq ,@(and (car spec) `(,(car spec) (car ,plist)))
		 ,@(and (nth 1 spec) `(,(nth 1 spec) (cadr ,plist))))
	   ,@body
	   (setq ,plist (cddr ,plist)))
	 nil))))

;;; Local IspellPersDict: .ispell_xsymb
;;; x-symbol-macs.el ends here
