/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.Context;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.NodeEnumeration;
import com.icl.saxon.expr.NodeSetIntent;
import com.icl.saxon.expr.NodeSetValue;
import com.icl.saxon.expr.Value;
import com.icl.saxon.om.NodeInfo;
import org.xml.sax.SAXException;

public abstract class NodeSetExpression
extends Expression {
    public abstract NodeEnumeration enumerate(Context var1) throws SAXException;

    public final Value evaluate(Context context) throws SAXException {
        Expression expression = this.reduce(255, context);
        if (expression instanceof NodeSetValue) {
            return (Value)expression;
        }
        if (expression instanceof NodeSetExpression) {
            return new NodeSetIntent((NodeSetExpression)expression);
        }
        Value value = expression.evaluate(context);
        if (value instanceof NodeSetValue) {
            return value;
        }
        throw new SAXException("Value must be a node-set: it is a " + expression.getClass());
    }

    public NodeInfo selectFirst(Context context) throws SAXException {
        NodeEnumeration nodeEnumeration = this.enumerate(context);
        if (nodeEnumeration.isSorted()) {
            if (nodeEnumeration.hasMoreElements()) {
                return nodeEnumeration.nextElement();
            }
            return null;
        }
        NodeInfo nodeInfo = null;
        long l = Long.MAX_VALUE;
        while (nodeEnumeration.hasMoreElements()) {
            NodeInfo nodeInfo2 = nodeEnumeration.nextElement();
            long l2 = nodeInfo2.getSequenceNumber();
            if (l2 >= l) continue;
            nodeInfo = nodeInfo2;
            l = l2;
        }
        return nodeInfo;
    }

    public String evaluateAsString(Context context) throws SAXException {
        NodeInfo nodeInfo = this.selectFirst(context);
        if (nodeInfo == null) {
            return "";
        }
        return nodeInfo.getValue();
    }

    public boolean evaluateAsBoolean(Context context) throws SAXException {
        return this.enumerate(context).hasMoreElements();
    }

    public NodeSetValue evaluateAsNodeSet(Context context) throws SAXException {
        return (NodeSetValue)this.evaluate(context);
    }

    public int getDataType() {
        return 4;
    }
}

