/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.expr.Value;
import java.math.BigDecimal;

public final class NumericValue
extends Value {
    private double value;

    public NumericValue(double d) {
        this.value = d;
    }

    public NumericValue(String string) {
        this.value = Value.stringToNumber(string);
    }

    public String asStringOLD() {
        if (Double.isNaN(this.value)) {
            return "NaN";
        }
        if (Double.isInfinite(this.value)) {
            return this.value > 0.0 ? "Infinity" : "-Infinity";
        }
        if (this.value == 0.0) {
            return "0";
        }
        double d = Math.abs(this.value);
        StringBuffer stringBuffer = new StringBuffer();
        if (this.value < 0.0) {
            stringBuffer.append('-');
        }
        int n = this.value < 0.0 ? 1 : 0;
        double d2 = Math.floor(d);
        double d3 = d - d2;
        if (d2 >= 1.0) {
            while (d2 >= 1.0) {
                int n2 = (int)(d2 % 10.0);
                char c = (char)(n2 + 48);
                stringBuffer.insert(n, c);
                d2 = Math.floor(d2 / 10.0);
            }
        } else {
            stringBuffer.append('0');
        }
        if (d3 > 0.0) {
            stringBuffer.append('.');
            while (d3 > 0.0) {
                double d4 = d3 * 10.0;
                if (d4 < 1.000000000001 && d4 > 0.999999999999) {
                    d4 = 1.0;
                }
                double d5 = Math.floor(d4);
                char c = (char)((int)d5 + 48);
                stringBuffer.append(c);
                d3 = d4 % 1.0;
            }
        }
        return stringBuffer.toString();
    }

    public String asString() {
        String string;
        int n;
        if (!Double.isInfinite(this.value) && (this.value >= 9.007199254740992E15 || -this.value >= 9.007199254740992E15)) {
            return new BigDecimal(this.value).toString();
        }
        String string2 = Double.toString(this.value);
        if (string2.charAt((n = string2.length()) - 2) == '.' && string2.charAt(n - 1) == '0') {
            if ((string2 = string2.substring(0, n - 2)).equals("-0")) {
                return "0";
            }
            return string2;
        }
        int n2 = string2.indexOf(69);
        if (n2 < 0) {
            return string2;
        }
        int n3 = Integer.parseInt(string2.substring(n2 + 1));
        if (string2.charAt(0) == '-') {
            string = "-";
            string2 = string2.substring(1);
            --n2;
        } else {
            string = "";
        }
        int n4 = n2 - 2;
        if (n3 >= n4) {
            return string + string2.substring(0, 1) + string2.substring(2, n2) + NumericValue.zeros(n3 - n4);
        }
        if (n3 > 0) {
            return string + string2.substring(0, 1) + string2.substring(2, 2 + n3) + "." + string2.substring(2 + n3, n2);
        }
        return string + "0." + NumericValue.zeros(-1 - n3) + string2.substring(0, 1) + string2.substring(2, n2);
    }

    private static String zeros(int n) {
        char[] cArray = new char[n];
        int n2 = 0;
        while (n2 < n) {
            cArray[n2] = 48;
            ++n2;
        }
        return new String(cArray);
    }

    public double asNumber() {
        return this.value;
    }

    public boolean asBoolean() {
        return this.value != 0.0 && !Double.isNaN(this.value);
    }

    public int getDataType() {
        return 2;
    }

    public boolean isNumeric() {
        return true;
    }

    public String toString() {
        return this.asString();
    }
}

