/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.functions;

import com.icl.saxon.Context;
import com.icl.saxon.expr.EmptyNodeSet;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.Function;
import com.icl.saxon.expr.NodeEnumeration;
import com.icl.saxon.expr.NodeSetExtent;
import com.icl.saxon.expr.NodeSetValue;
import com.icl.saxon.expr.SingletonNodeSet;
import com.icl.saxon.expr.Value;
import com.icl.saxon.om.DocumentInfo;
import com.icl.saxon.om.ElementInfo;
import com.icl.saxon.om.NodeInfo;
import java.util.StringTokenizer;
import java.util.Vector;
import org.xml.sax.SAXException;

public class Id
extends Function {
    private DocumentInfo boundDocument = null;

    public String getName() {
        return "id";
    }

    public int getDataType() {
        return 4;
    }

    public int getIntrinsicDependencies() {
        if (this.boundDocument != null) {
            return 0;
        }
        return 8;
    }

    private void bindDocument(DocumentInfo documentInfo) {
        this.boundDocument = documentInfo;
    }

    public Value eval(Vector vector, Context context) throws SAXException {
        int n = this.checkArgumentCount(1, 1);
        Value value = (Value)vector.elementAt(0);
        return this.findId(value, context);
    }

    protected Expression reduceIntrinsic(int n, Context context) throws SAXException {
        this.checkArgumentCount(1, 1);
        if ((n & 8) != 0) {
            Id id = new Id();
            id.addArgument((Expression)this.arguments.elementAt(0));
            id.bindDocument(context.getContextNode().getDocumentRoot());
            id.setStaticContext(this.getStaticContext());
            return id;
        }
        return this;
    }

    private NodeSetValue findId(Value value, Context context) throws SAXException {
        Vector<ElementInfo> vector = null;
        DocumentInfo documentInfo = this.boundDocument == null ? context.getContextNode().getDocumentRoot() : this.boundDocument;
        if (value instanceof NodeSetValue) {
            NodeEnumeration nodeEnumeration = ((NodeSetValue)value).enumerate();
            while (nodeEnumeration.hasMoreElements()) {
                NodeInfo nodeInfo = nodeEnumeration.nextElement();
                String string = nodeInfo.getValue();
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                while (stringTokenizer.hasMoreTokens()) {
                    ElementInfo elementInfo = documentInfo.selectID(stringTokenizer.nextToken());
                    if (elementInfo == null) continue;
                    if (vector == null) {
                        vector = new Vector(2);
                    }
                    vector.addElement(elementInfo);
                }
            }
        } else {
            String string = value.asString();
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                ElementInfo elementInfo = documentInfo.selectID(stringTokenizer.nextToken());
                if (elementInfo == null) continue;
                if (vector == null) {
                    vector = new Vector<ElementInfo>(2);
                }
                vector.addElement(elementInfo);
            }
        }
        if (vector == null) {
            return new EmptyNodeSet();
        }
        if (vector.size() == 1) {
            return new SingletonNodeSet((NodeInfo)vector.elementAt(0));
        }
        return new NodeSetExtent(vector);
    }
}

