/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Context;
import com.icl.saxon.expr.AttributeValueTemplate;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.om.Name;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.style.StyleElement;
import org.xml.sax.SAXException;

public class XSLElement
extends StyleElement {
    private Expression elementName;
    private Expression namespace = null;
    private String use;
    private boolean declared = false;

    public boolean isInstruction() {
        return true;
    }

    public void prepareAttributes() throws SAXException {
        String[] stringArray = new String[]{"name", "namespace", "use-attribute-sets"};
        this.allowAttributes(stringArray);
        String string = this.getAttributeValue("name");
        if (string == null) {
            this.reportAbsence("name");
        }
        this.elementName = AttributeValueTemplate.make(string, this);
        String string2 = this.getAttributeValue("namespace");
        if (string2 != null) {
            this.namespace = AttributeValueTemplate.make(string2, this);
        }
        this.use = this.getAttributeValue("use-attribute-sets");
    }

    public void validate() throws SAXException {
        this.checkWithinTemplate();
        if (this.use != null) {
            this.findAttributeSets(this.use);
        }
    }

    public void process(Context context) throws SAXException {
        Name name;
        String string;
        String string2;
        String string3 = this.elementName.evaluateAsString(context);
        if (!Name.isQName(string3)) {
            context.getController().reportRecoverableError("Invalid element name: " + string3, this);
            this.processChildren(context);
            return;
        }
        if (this.namespace != null) {
            string2 = this.namespace.evaluateAsString(context).intern();
            int n = string3.indexOf(":");
            string = n < 0 ? "" : string3.substring(0, n).intern();
            String string4 = n < 0 ? string3 : string3.substring(n + 1);
            name = new Name(string, string2, string4);
        } else {
            name = new Name(string3, this, true);
            string = name.getPrefix();
            string2 = name.getURI();
        }
        Outputter outputter = context.getOutputter();
        outputter.writeStartTag(name);
        if (string2 != "") {
            outputter.writeNamespaceDeclaration(string, string2, false);
        }
        this.processAttributeSets(context);
        this.processChildren(context);
        outputter.writeEndTag(name);
    }
}

