/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Context;
import com.icl.saxon.Controller;
import com.icl.saxon.output.Emitter;
import com.icl.saxon.output.MessageEmitter;
import com.icl.saxon.output.OutputDetails;
import com.icl.saxon.style.StyleElement;
import java.io.PrintWriter;
import org.xml.sax.SAXException;

public class XSLMessage
extends StyleElement {
    boolean terminate = false;

    public boolean isInstruction() {
        return true;
    }

    public void prepareAttributes() throws SAXException {
        String[] stringArray = new String[]{"terminate"};
        this.allowAttributes(stringArray);
        String string = this.getAttributeValue("terminate");
        if (string != null) {
            if (string.equals("yes")) {
                this.terminate = true;
            } else if (string.equals("no")) {
                this.terminate = false;
            } else {
                this.styleError("terminate must be \"yes\" or \"no\"");
            }
        }
    }

    public void validate() throws SAXException {
        this.checkWithinTemplate();
    }

    public void process(Context context) throws SAXException {
        Controller controller = context.getController();
        OutputDetails outputDetails = new OutputDetails();
        Emitter emitter = controller.getMessageEmitter();
        if (emitter == null) {
            outputDetails.setEmitter(new MessageEmitter());
        } else {
            outputDetails.setEmitter(emitter);
        }
        outputDetails.setWriter(new PrintWriter(System.err));
        outputDetails.setMethod("saxon:user");
        outputDetails.setCloseAfterUse(false);
        outputDetails.setOmitDeclaration("yes");
        controller.setNewOutputDetails(outputDetails);
        this.processChildren(context);
        controller.resetOutputDetails();
        if (this.terminate) {
            throw this.styleError("Processing terminated");
        }
    }
}

