/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.trax.serialize;

import com.icl.saxon.trax.serialize.OutputFormat;
import com.icl.saxon.trax.serialize.Serializer;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public abstract class SerializerFactory {
    public static final String PropertiesResource = "/org/xml/serilize/serializer.properties";
    public static final String PropertyMethods = "org.xml.serialize.methods";
    public static final String PropertySerializerPrefix = "org.xml.serialize.";
    public static final String PropertyFormatPrefix = "org.xml.serialize.format.";
    private static Hashtable _serializers;
    private static Hashtable _formats;
    static /* synthetic */ Class class$com$icl$saxon$trax$serialize$SerializerFactory;

    public static Serializer getSerializer(String string) {
        Serializer serializer;
        Class clazz = (Class)_serializers.get(string);
        if (clazz == null) {
            return null;
        }
        try {
            serializer = (Serializer)clazz.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
        return serializer;
    }

    public static Serializer getSerializer(OutputFormat outputFormat) {
        Serializer serializer;
        if (outputFormat.getMethod() == null) {
            throw new IllegalArgumentException("The output format has not method name");
        }
        Class clazz = (Class)_serializers.get(outputFormat.getMethod());
        if (clazz == null) {
            return null;
        }
        try {
            serializer = (Serializer)clazz.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
        serializer.setOutputFormat(outputFormat);
        return serializer;
    }

    public static OutputFormat getOutputFormat(String string) {
        Class clazz = (Class)_formats.get(string);
        if (clazz != null) {
            try {
                OutputFormat outputFormat = (OutputFormat)clazz.newInstance();
                return outputFormat;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        OutputFormat outputFormat = new OutputFormat();
        outputFormat.setMethod(string);
        return outputFormat;
    }

    public Enumeration listMethods() {
        return _serializers.keys();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        block11: {
            _serializers = new Hashtable();
            _formats = new Hashtable();
            try {
                Properties properties = new Properties();
                properties.load((class$com$icl$saxon$trax$serialize$SerializerFactory == null ? (class$com$icl$saxon$trax$serialize$SerializerFactory = SerializerFactory.class$("com.icl.saxon.trax.serialize.SerializerFactory")) : class$com$icl$saxon$trax$serialize$SerializerFactory).getResourceAsStream(PropertiesResource));
                if (properties.getProperty(PropertyMethods) == null) {
                    System.err.println("Serializer property file has no org.xml.serialize.methods property");
                    break block11;
                }
                StringTokenizer stringTokenizer = new StringTokenizer(properties.getProperty(PropertyMethods));
                while (stringTokenizer.hasMoreElements()) {
                    Class<?> clazz;
                    String string = stringTokenizer.nextToken();
                    String string2 = properties.getProperty(PropertySerializerPrefix + string);
                    if (string2 == null) {
                        System.err.println("Could not find property for serializer implementing output method " + string);
                    } else {
                        try {
                            clazz = (class$com$icl$saxon$trax$serialize$SerializerFactory == null ? SerializerFactory.class$("com.icl.saxon.trax.serialize.SerializerFactory") : class$com$icl$saxon$trax$serialize$SerializerFactory).getClassLoader().loadClass(string2);
                            _serializers.put(string, clazz);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            System.err.println("Could not locate serializer class " + string2);
                        }
                    }
                    string2 = properties.getProperty(PropertyFormatPrefix + string);
                    if (string2 == null) {
                        System.err.println("Could not find property for output format implementing output method " + string);
                        continue;
                    }
                    try {
                        clazz = (class$com$icl$saxon$trax$serialize$SerializerFactory == null ? SerializerFactory.class$("com.icl.saxon.trax.serialize.SerializerFactory") : class$com$icl$saxon$trax$serialize$SerializerFactory).getClassLoader().loadClass(string2);
                        _formats.put(string, clazz);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        System.err.println("Could not locate output format class " + string2);
                    }
                }
            }
            catch (IOException iOException) {
                System.err.println("Error loading /org/xml/serilize/serializer.properties: " + iOException.toString());
            }
        }
    }
}

