/* Properties Dialog */
#include "properties.h"
#include "remote.h"

/* externs */
extern unsigned int debug;
extern GtkWidget *frame;


/* pointer to dialog-root */
GtkWidget *pbox;
GtkWidget *tbutton;  /* show tooltips toggle button */
GtkWidget *wbutton;  /* warp_pointer toggle button */
GtkWidget *sbutton;  /* startup_fullscreen toggle button */
GtkWidget *entry;
GtkWidget *entry_pre;
GtkWidget *entry_poll;
GtkWidget *radio_channel;

/* FIXME: from remote.c */
extern void place_widgets(GtkWidget *parent, char *mode);

/* this can be "simple", "detailed", "traditional" */
static char display_mode[255];


/* apply user-changes */
void do_apply() 
{
  Display *dpy_tmp;

  if(debug)
    printf("do_apply()\n");

  mouse_wheel_channel = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(radio_channel));
  if(debug)
      printf("channel: %i\n", mouse_wheel_channel);

  tooltips = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(tbutton));
  if(tooltips)
    gtk_tooltips_enable(GTK_TOOLTIPS(button_bar_tips));
  else
    gtk_tooltips_disable(GTK_TOOLTIPS(button_bar_tips));
  warp_pointer = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(wbutton));
  startup_fullscreen = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(sbutton));
  mode = display_mode;
  place_widgets(frame, mode);
  /* apply changed displayname only if it's != "" */
  if( strcmp(g_strdup(gtk_entry_get_text(GTK_ENTRY(entry))), "") != 0  )
      dpyname = g_strdup(gtk_entry_get_text(GTK_ENTRY(entry)));
  strcpy(xawtv_cmd, gtk_entry_get_text(GTK_ENTRY(entry_pre)));
  sscanf(gtk_entry_get_text(GTK_ENTRY(entry_poll)),"%i",&poll_intervall);
  if (NULL == (dpy_tmp = XOpenDisplay(dpyname))) {
    gtk_widget_show(gnome_error_dialog(g_strdup_printf(_("Can't open display: %s"),dpyname)));
  } else {
    XFree(dpy);
    dpy = dpy_tmp;
    /* don't remove this! */
    look_for_xawtv();
  }
}

/*apply handler*/
static void property_apply(GnomePropertyBox *box, int page_num, gpointer data)
{
  if(debug)
    printf("property_apply: %i \n", page_num);
  
  /*ignore page numbers other then -1*/
  if(page_num != -1)
    return;
  
  do_apply();
}

static void prop_dirty_callback(GtkWidget *widget, gpointer data)
{
  gnome_property_box_changed(GNOME_PROPERTY_BOX(pbox));
}

void dialog_help_callback (GnomePropertyBox *property_box, gint page_num)
{
    GnomeHelpMenuEntry help_entry = { "xawtv_applet",
				      "index.html#prop" };
    gnome_help_display(NULL, &help_entry);
}

/* property dialog option menu */
static void prop_mode_callback(GtkWidget *widget, gpointer data)
{
  gnome_property_box_changed(GNOME_PROPERTY_BOX(pbox));
  strcpy(display_mode, data);
  if(debug)
    printf("got: %s\n",display_mode);
}


void show_properties (void)
{
  GtkWidget *hbox, *vbox;
  GtkWidget *menu, *mi;
  GtkWidget *label, *option;
  GtkWidget *frame, *frame_vbox;
  GtkWidget *radio_volume;
  static char string_poll_intervall[20];
  int i=0;

  pbox = gnome_property_box_new();
  gtk_signal_connect(GTK_OBJECT(pbox),"apply",
		     GTK_SIGNAL_FUNC(property_apply),NULL);
  gtk_signal_connect(GTK_OBJECT(pbox),"help",
		     GTK_SIGNAL_FUNC(dialog_help_callback),NULL);

  /* create global vbox */
  vbox = gtk_vbox_new(FALSE, GNOME_PAD);
  
  /* Create "display" frame */
  frame = gtk_frame_new(_("Display"));
  frame_vbox = gtk_vbox_new(FALSE, GNOME_PAD);
  gtk_container_add(GTK_CONTAINER(frame), frame_vbox);

  /* fill display frame */
  hbox = gtk_hbox_new(FALSE, GNOME_PAD); 
  label = gtk_label_new(_(" Xawtv Display"));
  gtk_box_pack_start(GTK_BOX(hbox), GTK_WIDGET(label), FALSE, TRUE, 0); 
  entry = gtk_entry_new(); 
  gtk_entry_set_text(GTK_ENTRY(entry), dpyname == NULL ? "" : dpyname);
  gtk_signal_connect (GTK_OBJECT(entry), "changed", prop_dirty_callback, NULL);
  gtk_box_pack_start(GTK_BOX(hbox), entry, FALSE, FALSE, 0); 
  /* show the horizontal box and it's children */ 
  gtk_widget_show_all(hbox);
  gtk_box_pack_start(GTK_BOX(frame_vbox), hbox, FALSE, TRUE, 0);

  /* build "display mode   =simple" hbox */
  hbox = gtk_hbox_new(FALSE, GNOME_PAD);
  label = gtk_label_new(_(" Display Mode"));
  gtk_box_pack_start(GTK_BOX(hbox), GTK_WIDGET(label), FALSE, TRUE, 0);

  /* create option-menu widget */
  menu = gtk_menu_new();
  mi = gtk_menu_item_new_with_label(_("simple"));
  gtk_signal_connect (GTK_OBJECT(mi), "activate", prop_mode_callback, 
		      "simple");
  gtk_menu_append(GTK_MENU(menu), mi);
  gtk_widget_show (mi);
  mi = gtk_menu_item_new_with_label(_("detailed"));
  gtk_signal_connect (GTK_OBJECT(mi), "activate", prop_mode_callback, 
		      "detailed");
  gtk_menu_append(GTK_MENU(menu), mi);
  gtk_widget_show(mi);
  mi = gtk_menu_item_new_with_label(_("traditional"));
  gtk_signal_connect (GTK_OBJECT(mi), "activate", prop_mode_callback, 
		      "traditional");
  gtk_menu_append(GTK_MENU(menu), mi);
  mi = gtk_menu_item_new_with_label(_("small"));
  gtk_signal_connect (GTK_OBJECT(mi), "activate", prop_mode_callback, 
		      "small");
  gtk_menu_append(GTK_MENU(menu), mi);
  /* now show it */
  gtk_widget_show(mi);
  if(!strcmp(mode, "simple"))
    i=0;
  if(!strcmp(mode, "detailed"))
    i=1;
  if(!strcmp(mode, "traditional"))
    i=2;
  if(!strcmp(mode, "small"))
    i=3;
  gtk_menu_set_active(GTK_MENU(menu),i);
  option = gtk_option_menu_new();
  gtk_option_menu_set_menu(GTK_OPTION_MENU(option),menu);

  gtk_box_pack_start(GTK_BOX(hbox), GTK_WIDGET(option), FALSE, TRUE, 0); 
  gtk_widget_show_all(hbox);
  gtk_box_pack_start(GTK_BOX(frame_vbox), hbox, FALSE, FALSE, 0);
  
  /* show "Display" frame */
  gtk_box_pack_start(GTK_BOX(vbox), GTK_WIDGET(frame), FALSE, FALSE, 0);
  gtk_widget_show_all(frame);

  /* create "misc" frame */
  frame = gtk_frame_new(_("Misc"));
  frame_vbox = gtk_vbox_new(FALSE, GNOME_PAD);
  gtk_container_add(GTK_CONTAINER(frame), frame_vbox);

  /* create checkbuttons in "misc" frame */  
  wbutton =  gtk_check_button_new_with_label(_("Prevent xawtv from displacing the mouse pointer"));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(wbutton),warp_pointer);
  gtk_signal_connect (GTK_OBJECT(wbutton), "toggled",prop_dirty_callback,NULL);
  gtk_box_pack_start(GTK_BOX(frame_vbox), GTK_WIDGET(wbutton), FALSE,FALSE, 0);

  sbutton=gtk_check_button_new_with_label(_("Start xawtv in fullscreen mode"));
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(sbutton), startup_fullscreen);
  gtk_signal_connect(GTK_OBJECT(sbutton),"toggled", prop_dirty_callback, NULL);
  gtk_box_pack_start(GTK_BOX(frame_vbox),GTK_WIDGET(sbutton), FALSE, FALSE, 0);

  tbutton =  gtk_check_button_new_with_label(_("Show applet button tooltips"));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(tbutton),tooltips);
  gtk_signal_connect(GTK_OBJECT(tbutton),"toggled",prop_dirty_callback, NULL); 
  gtk_box_pack_start(GTK_BOX(frame_vbox),GTK_WIDGET(tbutton), FALSE, FALSE, 0);

  hbox = gtk_hbox_new(FALSE, GNOME_PAD); 
  label = gtk_label_new(_(" XawTV command"));
  gtk_box_pack_start(GTK_BOX(hbox), GTK_WIDGET(label), FALSE, TRUE, 0); 
  entry_pre = gtk_entry_new(); 
  gtk_entry_set_text(GTK_ENTRY(entry_pre), xawtv_cmd);
  gtk_signal_connect(GTK_OBJECT(entry_pre),"changed",prop_dirty_callback,NULL);
  gtk_box_pack_start(GTK_BOX(hbox), entry_pre, TRUE, TRUE, 5); 
  gtk_widget_show_all(hbox);
  gtk_box_pack_start(GTK_BOX(frame_vbox), hbox, FALSE, TRUE, 0);

  /* poll intervall */
  hbox = gtk_hbox_new(FALSE, GNOME_PAD); 
  label = gtk_label_new(_(" Look for Xawtv every nth-second"));
  gtk_box_pack_start(GTK_BOX(hbox), GTK_WIDGET(label), FALSE, TRUE, 0); 
  entry_poll = gtk_entry_new(); 
  sprintf(string_poll_intervall, "%i",poll_intervall);
  gtk_entry_set_text(GTK_ENTRY(entry_poll), string_poll_intervall);
  gtk_signal_connect(GTK_OBJECT(entry_poll),"changed",prop_dirty_callback,NULL);
  gtk_box_pack_start(GTK_BOX(hbox), entry_poll, TRUE, TRUE, 5); 
  /* show the horizontal box and it's children */ 
  gtk_widget_show_all(hbox);
  gtk_box_pack_start(GTK_BOX(frame_vbox), hbox, FALSE, TRUE, 0);

  /* show "misc" frame */
  gtk_box_pack_start(GTK_BOX(vbox), GTK_WIDGET(frame), FALSE, FALSE, 0);
  gtk_widget_show_all(frame);

  /* add "mouse-wheel" frame */
  frame = gtk_frame_new(_("Mouse wheel controls:"));
  frame_vbox = gtk_vbox_new(FALSE, GNOME_PAD);
  gtk_container_add(GTK_CONTAINER(frame), frame_vbox);
 
  /* create radio button */
  radio_channel = gtk_radio_button_new_with_label(NULL, _("Channel"));
  radio_volume  = gtk_radio_button_new_with_label_from_widget (GTK_RADIO_BUTTON(radio_channel), 
							       _("Volume")); 
  /* Pack them into a box, then show all the widgets */
  gtk_box_pack_start(GTK_BOX(frame_vbox), radio_channel, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT(radio_channel), "toggled", prop_dirty_callback, NULL);  
  gtk_box_pack_start(GTK_BOX(frame_vbox), radio_volume, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT(radio_volume), "toggled", prop_dirty_callback, NULL);  
  if(mouse_wheel_channel)
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radio_channel), TRUE);
  else
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radio_volume), TRUE);

  /* show "mouse-wheel" frame */
  gtk_box_pack_start(GTK_BOX(vbox), GTK_WIDGET(frame), FALSE, FALSE, 0);
  gtk_widget_show_all(frame);
  
  

  /* finish dialog */
  gnome_property_box_append_page(GNOME_PROPERTY_BOX(pbox), vbox, gtk_label_new(_("Properties")));
  gtk_box_pack_start(GTK_BOX(GNOME_DIALOG(pbox)->vbox), GTK_WIDGET(vbox), FALSE, FALSE, 0);
  gtk_widget_show_all(pbox);
}









