/******************************************************************
 
        MUSCLE SmartCard Development ( http://www.musclecard.com )
            Title  : xcardCreateObj.cpp
            Author : David Corcoran
            Date   : 10/05/01
	    License: Copyright (C) 2001 David Corcoran
	             <corcoran@linuxnet.com>
            Purpose: This provides functionality for the xcard
	             personalization tool for the musclecard.
 
********************************************************************/ 

#include "xcardCreateObj.h"
#include <stdio.h>
#include <string.h>

#ifdef MSC_TARGET_OSX
#include <PCSC/musclecard.h>
#else
#include <musclecard.h>
#endif

#include <qmessagebox.h>
#include <qfiledialog.h>
#include <sys/stat.h>
#include <sys/types.h>

#ifdef MSC_TARGET_UNIX
#include <unistd.h>
#endif

#define Inherited xcardCreateObjData

xcardCreateObj::xcardCreateObj
(
 MSCLPTokenConnection pConn,
 xcardMain *mainWin,
 char *optFile,
 QWidget* parent,
 const char* name
)
	:
	Inherited( parent, name )
{

  MSCLong32 rv;
  MSCUShort16 pinInf;
  MSCKeyInfo keyInf;
  char insertText[50];
  int p, i;

  pConnect   = pConn;
  mainWindow = mainWin;
  selectFile = optFile;
  pinInf     = 0;
  p          = 0;
  isFileOK   = FALSE;

  g_createFileSelectLabel1->setAlignment(QLabel::AlignRight);

  rv = MSCListPINs( pConnect, &pinInf );
  
  for (i=1; i < 0xFFFF; i <<= 1) {
    if (pinInf & i) {
      snprintf(insertText, sizeof(insertText), "PIN #%d", p);
      g_readPermCombo1->insertItem(insertText);
      g_writePermCombo1->insertItem(insertText);
      g_deletePermCombo1->insertItem(insertText);
    }

    ++p;
  }
  
  rv = MSCListKeys( pConnect, MSC_SEQUENCE_RESET, &keyInf );
  
  while ( rv == MSC_SUCCESS ) {
    if ( keyInf.keyNum <= 5 ) {
      snprintf(insertText, sizeof(insertText), "KEY #%d", keyInf.keyNum);
      g_readPermCombo1->insertItem(insertText);
      g_writePermCombo1->insertItem(insertText);
      g_deletePermCombo1->insertItem(insertText);
      rv = MSCListKeys( pConnect, MSC_SEQUENCE_NEXT, &keyInf );
      ++p;
    }
  }    


  g_readPermCombo1->setSelected(0, TRUE);
  g_writePermCombo1->setSelected(0, TRUE);
  g_deletePermCombo1->setSelected(0, TRUE);

  if (selectFile) {
    importFile = QString(selectFile);
    XCCheckInputFile();
  }

}

xcardCreateObj::~xcardCreateObj()
{
}

void xcardCreateObj::XCCreateObjectClicked() {

  MSCLong32 rv;
  char objectID[MSC_MAXSIZE_OBJID];
  MSCULong32 objectSize;
  //MSCUChar8 bytesCap[4];
  MSCULong32 capLength;
  MSCObjectACL objACL;
  QString createString;
  QString sizeString;
  char errorString[200];
  bool isOK, hexID, hexSize;
  int numChars;
  unsigned int maxObjID;


  hexID = FALSE; hexSize = FALSE;
  createString = g_createIDInput1->text();
  sizeString   = g_createSizeInput1->text(); 

  if ( createString && sizeString ) {
    numChars = sizeString.find('x');
    if (numChars != -1) {
      hexSize = TRUE;
      sizeString.remove(0,numChars+1);
    }

    numChars = sizeString.find('X');
    if (numChars != -1) {
      hexSize = TRUE;
      sizeString.remove(0,numChars+1);    
    }

    strncpy(objectID, createString.latin1(), MSC_MAXSIZE_OBJID);

    rv = MSCGetCapabilities(pConnect, MSC_TAG_CAPABLE_OBJ_IDSIZE,
			    (MSCPUChar8)&maxObjID, &capLength);

    if ( rv != MSC_SUCCESS ) {
      maxObjID = 2;
    }

    if ( strlen(objectID) > maxObjID ) {
      snprintf(errorString, sizeof(errorString), 
	       "Maximum Object ID\nLength is: %d", maxObjID);
      QMessageBox::critical( 0, "XCard II",
			     QString(errorString));
      return;
    }

    if ( hexSize == TRUE ) {
      objectSize = sizeString.toULong(&isOK, 16);
    } else {
      objectSize = sizeString.toULong(&isOK, 10);
      if ( isOK == FALSE )
	objectSize = sizeString.toULong(&isOK, 16);
    }

    if ( isOK == FALSE ) {
    QMessageBox::critical( 0, "XCard II",
			   QString("Invalid Object Size"));
    return;
    }

    objACL.readPermission = 0;
    objACL.writePermission = 0;
    objACL.deletePermission = 0;

    rv = MSCCreateObject(pConnect, objectID, objectSize, &objACL);

    if ( rv == MSC_SUCCESS ) {

      if ( isFileOK == TRUE ) {
	mainWindow->XCInputDataObject(objectID, (char *)importFile.latin1());
      }

      mainWindow->XCUpdateList();
      hide();

    } else if ( rv != MSC_SUCCESS ) {
      snprintf(errorString, sizeof(errorString), 
	       "Create Object Failed\nCode: %s", msc_error(rv));
      QMessageBox::critical( 0, "XCard II",
			     QString(errorString));
    } 

  } else {
    QMessageBox::critical( 0, "XCard II",
			   QString("Invalid Input Data"));
  }


}


void xcardCreateObj::XCCancelCreateObjectClicked() {
  hide();
}


void xcardCreateObj::XCCreateInputButtonClicked() {
  
  g_createFileSelectLabel1->setText("No File Selected");
  
  do {    
    importFile = QFileDialog::getOpenFileName(".", "*");

    printf("File is %s\n", importFile.latin1());

    if ( importFile.isNull() ) {
      printf("NULL Filename\n");
      break;
    } 
    
    XCCheckInputFile();

  } while(0);

}


void xcardCreateObj::XCCheckInputFile() {

  int lastSlash;
  //bool isOK;
  QString backupFile;
  char tempString[75];
  int fileSize;
  
  isFileOK = FALSE;

  do {
  
    QFileInfo inFile(importFile);

    if ( inFile.exists() == FALSE ) {
      QMessageBox::critical( 0, "XCard II",
			     QString("Open File Failed"));
      
      break;
    }
            
    fileSize = inFile.size();
            
    if ( fileSize >  mainWindow->XCGetFreeMemory() ) {
      QMessageBox::critical( 0, "XCard II",
			     QString("File Larger than Available Memory"));
      break;
    }
    
    backupFile = importFile;

#ifdef MSC_TARGET_UNIX    
	lastSlash  = backupFile.findRev('/');
#else
    lastSlash  = backupFile.findRev('\\');
#endif

    if ( lastSlash != -1 ) {
      backupFile.remove(0, lastSlash+1);
    } else {
      /* do nothing */
    }
    
    snprintf(tempString, sizeof(tempString), "%d", fileSize);
    g_createSizeInput1->setText(tempString); 
    
    g_createFileSelectLabel1->setText(backupFile);
    isFileOK = TRUE;
  } while (0);
  
}
